/*
 * Decompiled with CFR 0.152.
 */
package javaclients.svg.batik;

import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import javaclients.svg.batik.JSVGCanvasExtended;
import javaclients.svg.batik.SvgIdMapper;
import javaclients.svg.batik.SvgUtility;
import javaclients.svg.batik.XmlUtility;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.gvt.GraphicsNode;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlToDom;

public class Transceiver
implements I_Callback {
    private static final String ME = "Transceiver";
    private final Global glob;
    private final LogChannel log;
    private BridgeContext bridgeContext = null;
    private JSVGCanvasExtended canvas = null;
    private I_XmlBlasterAccess xmlBlasterConnection = null;
    private String svgFileName = null;
    private static final String SVG_PREFIX = "<?xml version='1.0' standalone='no'?>\n<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.0//EN'\n'http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd'><svg>";
    private static final String SVG_POSTFIX = "</svg>";
    private boolean elementsSubscribed = false;

    protected static byte[] readFromFile(String filename) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(filename);
        int fileSize = fileInputStream.available();
        byte[] b = new byte[fileSize];
        fileInputStream.read(b);
        return b;
    }

    public void subscribeElements() throws XmlBlasterException {
        if (this.svgFileName != null && !this.elementsSubscribed) {
            String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n   //svg[@name='" + this.svgFileName + "' and @complete='false']" + "</key>";
            String qos = "<qos></qos>";
            this.xmlBlasterConnection.subscribe(xmlKey, qos);
            this.elementsSubscribed = true;
        }
    }

    public Transceiver(Global glob, JSVGCanvasExtended canvas) {
        this.glob = glob;
        this.log = glob.getLog("batik");
        this.log.trace(ME, "constructor with Global");
        this.canvas = canvas;
        try {
            String qos;
            String xmlKey;
            String svgMaster = glob.getProperty().get("svgMaster", (String)null);
            String svgSlave = glob.getProperty().get("svgSlave", (String)null);
            String svgUser = glob.getProperty().get("svgUser", "dummyUser");
            this.xmlBlasterConnection = glob.getXmlBlasterAccess();
            ConnectQos connectQos = new ConnectQos(glob, svgUser, "secret");
            this.xmlBlasterConnection.connect(connectQos, this);
            if (svgMaster != null) {
                this.svgFileName = svgMaster;
                this.log.trace(ME, "constructor: running as Master: " + svgMaster);
                xmlKey = "<key oid=''><svg name='" + this.svgFileName + "' complete='true'></svg></key>";
                qos = "<qos></qos>";
                byte[] content = Transceiver.readFromFile(this.svgFileName);
                MsgUnit messageUnit = new MsgUnit(xmlKey, content, qos);
                PublishReturnQos ret = this.xmlBlasterConnection.publish(messageUnit);
                this.log.info(ME, "constructor: " + ret.getKeyOid());
            } else if (svgSlave != null) {
                this.svgFileName = svgSlave;
            }
            if (this.svgFileName != null) {
                xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n   //svg[@name='" + this.svgFileName + "' and @complete='true']" + "</key>";
                qos = "<qos></qos>";
                this.xmlBlasterConnection.subscribe(xmlKey, qos);
            }
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "Transceiver Constructor: " + ex.toString());
        }
        catch (FileNotFoundException ex) {
            this.log.error(ME, "Transceiver Constructor: " + ex.toString());
        }
        catch (IOException ex) {
            this.log.error(ME, "Transceiver Constructor: " + ex.toString());
        }
    }

    public void disconnect() {
        this.xmlBlasterConnection.disconnect(new DisconnectQos(this.glob));
    }

    protected void updateDocument(byte[] content) throws XmlBlasterException {
        this.log.warn(ME, ".updateDocument()");
        try {
            this.canvas.loadDocumentFromByteArray(content);
        }
        catch (IOException ex) {
            this.log.error(ME, "io exception: " + ex.toString());
            throw new XmlBlasterException(ME, ".updateDocument: " + ex.getMessage());
        }
    }

    protected void updateElement(byte[] content, String id) throws XmlBlasterException {
        this.log.trace(ME, ".updateElement(): " + id);
        Element el = this.canvas.getElement(id);
        if (el == null) {
            this.log.warn(ME, "the element with id '" + id + "' is not registered");
            return;
        }
        this.bridgeContext.unbind(el);
        String completeSVG = SVG_PREFIX + new String(content) + SVG_POSTFIX;
        this.log.warn(ME, ".updateElement: " + completeSVG);
        try {
            Node tempNode = SvgUtility.createDocument(completeSVG, "file://dummy.svg").getDocumentElement().getFirstChild();
            Document doc = el.getOwnerDocument();
            tempNode = doc.importNode(tempNode, true);
            Node parentNode = el.getParentNode();
            parentNode.replaceChild(tempNode, el);
            GraphicsNode graphicsNode = this.bridgeContext.getGVTBuilder().build(this.bridgeContext, (Element)tempNode);
            this.bridgeContext.bind((Element)tempNode, graphicsNode);
            graphicsNode = this.bridgeContext.getGVTBuilder().build(this.bridgeContext, tempNode.getOwnerDocument());
            this.canvas.setGraphicsNode(graphicsNode);
            this.canvas.updateDocument();
        }
        catch (IOException ex) {
            this.log.error(ME, ".updateElement: IOException " + ex.getMessage());
            throw new XmlBlasterException(ME, ".updateElement: IOException " + ex.getMessage());
        }
    }

    public String update(String loginName, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        this.log.trace(ME, "update called, content: " + new String(content));
        this.log.trace(ME, "update called, loginName: " + loginName);
        this.log.trace(ME, "update called, updateKey: " + updateKey);
        this.log.trace(ME, "update called, updateQos: " + updateQos);
        XmlToDom keyDom = new XmlToDom(Global.instance(), updateKey.toString());
        NodeList nodes = keyDom.getXmlDoc().getDocumentElement().getElementsByTagName("svg");
        int length = nodes.getLength();
        if (nodes == null || length < 1) {
            throw new XmlBlasterException(ME, ".update: no svg node found in the key");
        }
        Node keyNode = nodes.item(0);
        if (keyNode instanceof Element) {
            String id = ((Element)keyNode).getAttribute("id");
            if (id == null || id.length() < 1) {
                this.updateDocument(content);
            } else {
                this.updateElement(content, id);
            }
        } else {
            throw new XmlBlasterException(ME, "update: svg node is not an element");
        }
        return "";
    }

    public void setBridgeContext(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
    }

    protected Element getClickedDynamicElement(Element el) {
        this.log.trace(ME, ".getClickedDynamicElement");
        while (el != null) {
            String id = el.getAttribute("id");
            if (SvgIdMapper.isDynamic(id)) {
                return el;
            }
            Node parent = el.getParentNode();
            if (parent instanceof Element) {
                el = (Element)parent;
                continue;
            }
            return null;
        }
        return null;
    }

    public static void moveElement(Element el, int x, int y) {
        if (el == null) {
            return;
        }
        String transformString = el.getAttribute("transform");
        if (transformString == null || transformString.length() < 1) {
            transformString = "translate(" + x + "," + y + ")";
        } else {
            el.removeAttribute("transform");
            int pos = transformString.indexOf("translate(");
            if (pos < 0) {
                transformString = transformString + " translate(" + x + "," + y + ")";
            } else {
                String endString = transformString.substring(pos + "translate(".length()).trim();
                String startString = transformString.substring(0, pos).trim();
                String coreString = endString.substring(0, endString.indexOf(")")).trim();
                endString = endString.substring(1 + endString.indexOf(")")).trim();
                StringTokenizer tokenizer = new StringTokenizer(coreString, ",");
                double x0 = Double.parseDouble(tokenizer.nextToken().trim());
                double y0 = Double.parseDouble(tokenizer.nextToken().trim());
                transformString = startString + " translate(" + (x0 + (double)x) + "," + (y0 + (double)y) + ") " + endString;
            }
        }
        el.setAttribute("transform", transformString);
    }

    public void move(GraphicsNode graphicsNode, Point displacement) {
        this.log.info(ME, ".move " + displacement.x + " " + displacement.y);
        Element el = this.bridgeContext.getElement(graphicsNode);
        el = this.getClickedDynamicElement(el);
        if (el == null) {
            return;
        }
        String id = el.getAttribute("id");
        Transceiver.moveElement(el, displacement.x, displacement.y);
        this.log.info(ME, ".move: el: " + el.getNodeName());
        String xmlKey = "<key oid=''><svg name='" + this.svgFileName + "' id='" + id + "' complete='false'></svg></key>";
        String qos = "<qos></qos>";
        byte[] content = XmlUtility.write(el).getBytes();
        try {
            MsgUnit messageUnit = new MsgUnit(xmlKey, content, qos);
            PublishReturnQos ret = this.xmlBlasterConnection.publish(messageUnit);
            this.log.trace(ME, "move: " + ret.getKeyOid());
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, ".move exception when publishing: " + ex.getMessage());
        }
    }
}

