/*
 * Decompiled with CFR 0.152.
 */
package javaclients.svg.batik;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtility {
    private static final boolean fCanonical = false;

    public static Document getDocument() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    public static Document parse(InputSource inputSource) throws ParserConfigurationException, IOException, SAXException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
    }

    public static void write(Node node, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        XmlUtility.write(node, printWriter);
    }

    public static String write(Node node) {
        StringWriter writer = new StringWriter();
        XmlUtility.write(node, writer);
        return writer.toString();
    }

    public static void write(Node node, PrintWriter fOut) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                fOut.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>");
                fOut.flush();
                Document document = (Document)node;
                XmlUtility.write((Node)document.getDocumentElement(), fOut);
                break;
            }
            case 1: {
                fOut.print('<');
                fOut.print(node.getNodeName());
                Attr[] attrs = XmlUtility.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    fOut.print(' ');
                    fOut.print(attr.getNodeName());
                    fOut.print("=\"");
                    XmlUtility.normalizeAndPrint(attr.getNodeValue(), fOut);
                    fOut.print('\"');
                    ++i;
                }
                fOut.print('>');
                fOut.flush();
                Node child = node.getFirstChild();
                while (child != null) {
                    XmlUtility.write(child, fOut);
                    child = child.getNextSibling();
                }
                break;
            }
            case 5: {
                fOut.print('&');
                fOut.print(node.getNodeName());
                fOut.print(';');
                fOut.flush();
                break;
            }
            case 4: {
                fOut.print("<![CDATA[");
                fOut.print(node.getNodeValue());
                fOut.print("]]>");
                fOut.flush();
                break;
            }
            case 3: {
                XmlUtility.normalizeAndPrint(node.getNodeValue(), fOut);
                fOut.flush();
                break;
            }
            case 7: {
                fOut.print("<?");
                fOut.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    fOut.print(' ');
                    fOut.print(data);
                }
                fOut.println("?>");
                fOut.flush();
                break;
            }
        }
        if (type == 1) {
            fOut.print("</");
            fOut.print(node.getNodeName());
            fOut.print('>');
            fOut.flush();
        }
    }

    protected static Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    protected static void normalizeAndPrint(String s, PrintWriter fOut) {
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            XmlUtility.normalizeAndPrint(c, fOut);
            ++i;
        }
    }

    protected static void normalizeAndPrint(char c, PrintWriter fOut) {
        switch (c) {
            case '<': {
                fOut.print("&lt;");
                break;
            }
            case '>': {
                fOut.print("&gt;");
                break;
            }
            case '&': {
                fOut.print("&amp;");
                break;
            }
            case '\"': {
                fOut.print("&quot;");
                break;
            }
            default: {
                fOut.print(c);
            }
        }
    }
}

