/*
 * Decompiled with CFR 0.152.
 */
package javaclients.svg.rhino;

import java.util.Random;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class ChessMover {
    private static final String ME = "ChessMover";
    protected I_XmlBlasterAccess connection = null;
    private Random random = null;
    private long sleepTime = 0L;

    public ChessMover(String[] args) throws XmlBlasterException {
        Global glob = new Global(args);
        this.sleepTime = Long.parseLong(args[1]);
        this.random = new Random(100L);
        this.connection = glob.getXmlBlasterAccess();
        ConnectQos connectQos = new ConnectQos(glob, "chessMover", "secret");
        this.connection.connect(connectQos, null);
    }

    public void publish() throws XmlBlasterException {
        int id = this.random.nextInt(32);
        int x = this.random.nextInt(450);
        int y = this.random.nextInt(450);
        String key = "<?xml version='1.0'?><key oid='" + id + "'><chess>some chess name</chess></key>";
        String qos = "<qos></qos>";
        String transform = "translate(" + x + "," + y + ")";
        String content = "<chess><id>" + id + "A</id><transform>" + transform + "</transform></chess>";
        MsgUnit msg = new MsgUnit(key, content.getBytes(), qos);
        this.connection.publish(msg);
        try {
            Thread.currentThread();
            Thread.sleep(this.sleepTime);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            ChessMover mover = new ChessMover(args);
            while (true) {
                mover.publish();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            System.err.println("usage: java javaclients.svg.rhino.ChessMover -interval updateInterval");
            System.err.println("where updateInterval is the time in ms between each move");
            System.exit(1);
            return;
        }
    }
}

