/*
 * Decompiled with CFR 0.152.
 */
package javaclients.xmlrpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class XmlRpcHttpClientRaw {
    private static final String ME = "XmlRpcHttpClientRaw";
    private final Global glob;
    private final LogChannel log;

    public XmlRpcHttpClientRaw(Global glob) {
        this.glob = glob;
        this.log = this.glob.getLog("xmlrpc");
    }

    public String execute(String urlStr, String inputString) throws XmlBlasterException {
        StringBuffer ret = null;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            OutputStream outStream = urlConnection.getOutputStream();
            byte[] conversionHelper = inputString.getBytes();
            outStream.write(conversionHelper);
            outStream.flush();
            ret = new StringBuffer();
            InputStream inStream = urlConnection.getInputStream();
            int bytes = 0;
            int deltaBytes = 0;
            int maxBytes = urlConnection.getContentLength();
            while (bytes < maxBytes) {
                deltaBytes = inStream.available();
                byte[] buffer = new byte[deltaBytes];
                inStream.read(buffer);
                bytes += deltaBytes;
                ret.append(new String(buffer));
            }
        }
        catch (MalformedURLException ex1) {
            this.log.error(ME, ex1.toString());
            throw new XmlBlasterException(ME, ex1.toString());
        }
        catch (IOException ex2) {
            this.log.error(ME, ex2.toString());
            throw new XmlBlasterException(ME, ex2.toString());
        }
        return ret.toString();
    }

    private void testRaw() {
        try {
            String host = this.glob.getProperty().get("dispatch/connection/plugin/xmlrpc/hostname", "localhost");
            int port = this.glob.getProperty().get("dispatch/connection/plugin/xmlrpc/port", 8080);
            int cb_port = this.glob.getProperty().get("dispatch/callback/plugin/xmlrpc/port", 8081);
            String urlStr = "http://" + host + ":" + port;
            this.log.info(ME, "Connected to xmlBlaster using XMLRPC");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = "";
            String cmd = "";
            boolean hasStarted = false;
            this.log.info(ME, "Processing data from stdin ...");
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("COMMAND") == -1) {
                    if (!hasStarted) continue;
                    cmd = cmd + line + "\n";
                    continue;
                }
                if (cmd.length() > 0) {
                    System.out.println("THE COMMAND IS: " + cmd + "\nEND OF COMMAND");
                    System.out.println(this.execute(urlStr, cmd));
                }
                cmd = "";
                hasStarted = true;
            }
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "exception: " + ex);
        }
        catch (IOException ex1) {
            this.log.error(ME, "exception:" + ex1);
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            XmlRpcHttpClientRaw.usage();
            System.exit(1);
        }
        XmlRpcHttpClientRaw client = new XmlRpcHttpClientRaw(glob);
        client.testRaw();
    }

    private static void usage() {
        System.out.println("----------------------------------------------------------");
        System.out.println("java javaclients.xmlrpc.XmlRpcHttpClientRaw < demo.xml <options>");
        System.out.println("----------------------------------------------------------");
        System.out.println("   -h                  Show the complete usage.");
        System.out.println("   -dispatch/connection/plugin/xmlrpc/hostname  The XMLRPC web server host [localhost].");
        System.out.println("   -dispatch/connection/plugin/xmlrpc/port      The XMLRPC web server port [8080].");
        System.out.println(Global.instance().usage());
        System.out.println("----------------------------------------------------------");
        System.out.println("");
    }
}

