/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.csv;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class CSVReader {
    private static final boolean debugging = true;
    private BufferedReader r;
    private char separator;
    private static final int EOL = 0;
    private static final int ORDINARY = 1;
    private static final int QUOTE = 2;
    private static final int SEPARATOR = 3;
    private static final int WHITESPACE = 4;
    private static final int SEEKINGSTART = 0;
    private static final int INPLAIN = 1;
    private static final int INQUOTED = 2;
    private static final int AFTERENDQUOTE = 3;
    private static final int SKIPPINGTAIL = 4;
    private String line = null;
    private int lineCount = 0;

    public CSVReader(Reader reader) {
        this.r = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.separator = (char)44;
    }

    public CSVReader(Reader reader, char c) {
        this.r = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.separator = c;
    }

    private int categorise(char c) {
        switch (c) {
            case '\r': 
            case ' ': 
            case '\u00ff': {
                return 4;
            }
            case '\n': 
            case '#': {
                return 0;
            }
            case '\"': {
                return 2;
            }
        }
        if (c == this.separator) {
            return 3;
        }
        if (c >= '!' && c <= '~') {
            return 1;
        }
        if (c >= '\u0000' && c <= ' ') {
            return 4;
        }
        if (Character.isWhitespace(c)) {
            return 4;
        }
        return 1;
    }

    public void close() throws IOException {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private String get() throws EOFException, IOException {
        var1_1 = new StringBuffer(50);
        this.readLine();
        var2_2 = 0;
        var3_3 = 0;
        while (var3_3 < this.line.length()) {
            var4_4 = this.line.charAt(var3_3);
            var5_5 = this.categorise(var4_4);
            block0 : switch (var2_2) {
                case 0: {
                    switch (var5_5) {
                        case 2: {
                            var2_2 = 2;
                            ** break;
                        }
                        case 3: {
                            this.line = this.line.substring(var3_3 + 1);
                            return "";
                        }
                        case 0: {
                            this.line = null;
                            return null;
                        }
                        case 1: {
                            var1_1.append(var4_4);
                            var2_2 = 1;
                            ** break;
                        }
                        default: {
                            break block0;
                        }
                    }
                }
                case 1: {
                    switch (var5_5) {
                        case 2: {
                            throw new IOException("Malformed CSV stream. Missing quote at start of field on line " + this.lineCount);
                        }
                        case 3: {
                            this.line = this.line.substring(var3_3 + 1);
                            return var1_1.toString().trim();
                        }
                        case 0: {
                            this.line = this.line.substring(var3_3);
                            return var1_1.toString().trim();
                        }
                        case 4: {
                            var1_1.append(' ');
                            ** break;
                        }
                        case 1: {
                            var1_1.append(var4_4);
                            ** break;
                        }
                        default: {
                            break block0;
                        }
                    }
                }
                case 2: {
                    switch (var5_5) {
                        case 2: {
                            var2_2 = 3;
                            ** break;
                        }
                        case 0: {
                            throw new IOException("Malformed CSV stream. Missing quote after field on line " + this.lineCount);
                        }
                        case 4: {
                            var1_1.append(' ');
                            ** break;
                        }
                        case 1: 
                        case 3: {
                            var1_1.append(var4_4);
                            ** break;
                        }
                        default: {
                            break block0;
                        }
                    }
                }
                case 3: {
                    switch (var5_5) {
                        case 2: {
                            var1_1.append(var4_4);
                            var2_2 = 2;
                            ** break;
                        }
                        case 3: {
                            this.line = this.line.substring(var3_3 + 1);
                            return var1_1.toString().trim();
                        }
                        case 0: {
                            this.line = this.line.substring(var3_3);
                            return var1_1.toString().trim();
                        }
                        case 4: {
                            var2_2 = 4;
                            ** break;
                        }
                        case 1: {
                            throw new IOException("Malformed CSV stream, missing separator after field on line " + this.lineCount);
                        }
                        default: {
                            break block0;
                        }
                    }
                }
                case 4: {
                    switch (var5_5) {
                        case 3: {
                            this.line = this.line.substring(var3_3 + 1);
                            return var1_1.toString().trim();
                        }
                        case 0: {
                            this.line = this.line.substring(var3_3);
                            return var1_1.toString().trim();
                        }
                        case 1: 
                        case 2: {
                            throw new IOException("Malformed CSV stream, missing separator after field on line " + this.lineCount);
                        }
                    }
                }
lbl95:
                // 9 sources

                break;
            }
            ++var3_3;
        }
        throw new IOException("Program logic bug. Should not reach here. Processing line " + this.lineCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getLine() {
        Vector<String> vector = new Vector<String>();
        String string = null;
        String[] stringArray = null;
        try {
            while (vector.size() == 0) {
                while ((string = this.get()) != null) {
                    vector.add(string);
                }
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (IOException iOException) {}
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        CSVReader.testLines(stringArray);
    }

    private void readLine() throws EOFException, IOException {
        if (this.line == null) {
            this.line = this.r.readLine();
            if (this.line == null) {
                throw new EOFException();
            }
            this.line = String.valueOf(this.line) + '\n';
            ++this.lineCount;
        }
    }

    public void skip(int n) throws EOFException, IOException {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.get();
            ++n2;
        }
    }

    public void skipToNextLine() throws EOFException, IOException {
        if (this.line == null) {
            this.readLine();
        }
        this.line = null;
    }

    private static void testLines(String[] stringArray) {
        int n = 0;
        String[] stringArray2 = null;
        String string = ",";
        try {
            CSVReader cSVReader = new CSVReader(new FileReader(stringArray[0]), ',');
            while ((stringArray2 = cSVReader.getLine()) != null) {
                ++n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringArray2[0]);
                int n2 = 1;
                while (n2 < stringArray2.length) {
                    stringBuffer.append(string).append(stringArray2[n2]);
                    ++n2;
                }
                String string2 = stringBuffer.toString();
                string2.substring(0, string2.lastIndexOf(string));
                System.out.println(string2);
            }
            cSVReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException.getMessage());
        }
    }

    private static void testSingleTokens(String[] stringArray) {
        try {
            CSVReader cSVReader = new CSVReader(new FileReader(stringArray[0]), ',');
            try {
                while (true) {
                    System.out.println(cSVReader.get());
                }
            }
            catch (EOFException eOFException) {
                cSVReader.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException.getMessage());
        }
    }
}

