/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.init;

import org.jutils.JUtilsException;
import org.jutils.init.Property;

public class Args {
    private static final String ME = "Args";
    private static String[] args = null;

    public static final int getArg(String string, int n) throws JUtilsException {
        if (args == null) {
            return n;
        }
        return Args.getArg(args, string, n);
    }

    public static final String getArg(String string, String string2) throws JUtilsException {
        if (args == null) {
            return string2;
        }
        return Args.getArg(args, string, string2);
    }

    public static final boolean getArg(String string, boolean bl) throws JUtilsException {
        if (args == null) {
            return bl;
        }
        return Args.getArg(args, string, bl);
    }

    public static final boolean getArg(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                return false;
            }
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final int getArg(String[] stringArray, String string, int n) throws JUtilsException {
        if (stringArray == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                throw new JUtilsException("Args.InvalidKey", "Please specify a value for args[" + n2 + "], null is not allowed");
            }
            if (stringArray[n2].equals(string)) {
                String string2;
                if (n2 >= stringArray.length - 1) {
                    throw new JUtilsException("Args.InvalidKey", "Please specify a value for parameter " + string);
                }
                if ((string2 = stringArray[++n2]) == null) {
                    return n;
                }
                try {
                    return Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    return n;
                }
            }
            ++n2;
        }
        return n;
    }

    public static final String getArg(String[] stringArray, String string, String string2) throws JUtilsException {
        if (stringArray == null) {
            return string2;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new JUtilsException("Args.InvalidKey", "Please specify a value for args[" + n + "], null is not allowed");
            }
            if (stringArray[n].equals(string)) {
                if (n >= stringArray.length - 1) {
                    throw new JUtilsException("Args.InvalidKey", "Please specify a value for parameter " + string);
                }
                return stringArray[++n];
            }
            ++n;
        }
        return string2;
    }

    public static final boolean getArg(String[] stringArray, String string, boolean bl) throws JUtilsException {
        if (stringArray == null) {
            return bl;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new JUtilsException("Args.InvalidKey", "Please specify a value for args[" + n + "], null is not allowed");
            }
            if (stringArray[n].equals(string)) {
                String string2;
                if (n >= stringArray.length - 1) {
                    throw new JUtilsException("Args.InvalidKey", "Please specify a value for parameter " + string);
                }
                if ((string2 = stringArray[++n]) == null) {
                    return bl;
                }
                try {
                    return Property.toBool(string2);
                }
                catch (Exception exception) {
                    return bl;
                }
            }
            ++n;
        }
        return bl;
    }

    public static final byte[] getArg(String[] stringArray, String string, byte[] byArray) throws JUtilsException {
        if (stringArray == null) {
            return byArray;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new JUtilsException("Args.InvalidKey", "Please specify a value for args[" + n + "], null is not allowed");
            }
            if (stringArray[n].equals(string)) {
                if (n >= stringArray.length - 1) {
                    throw new JUtilsException("Args.InvalidKey", "Please specify a value for parameter " + string);
                }
                return stringArray[++n].getBytes();
            }
            ++n;
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        String string = "Property";
        String[] stringArray2 = new String[]{"-hello", "1"};
        try {
            System.out.println("-hello=" + Args.getArg(stringArray2, stringArray2[0], false));
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        String[] stringArray3 = new String[]{"hello", "1"};
        try {
            System.out.println("hello=" + Args.getArg(stringArray3, stringArray3[0], false));
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        String[] stringArray4 = new String[]{null, null};
        try {
            Args.getArg(stringArray4, stringArray4[0], false);
            System.err.println("ERROR: Not excpected");
        }
        catch (Exception exception) {
            System.out.println("OK, expected exception for null args: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static final void setArg(String[] stringArray) {
        args = stringArray;
    }
}

