/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jutils.JUtilsException;

public class FileUtil {
    private static final String ME = "FileUtil";

    public static final void appendToFile(String string, String string2) throws JUtilsException {
        try {
            boolean bl = true;
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new JUtilsException(ME, "Can't write file " + exception.toString());
        }
    }

    public static String concatPath(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        if (string.endsWith(File.separator) && string2.startsWith(File.separator)) {
            return String.valueOf(string) + string2.substring(1);
        }
        if (string.endsWith(File.separator)) {
            return String.valueOf(string) + string2;
        }
        if (string2.startsWith(File.separator)) {
            return String.valueOf(string) + string2;
        }
        return String.valueOf(string) + File.separator + string2;
    }

    public static final void deleteFile(String string, String string2) {
        File file = new File(string, string2);
        if (file.exists()) {
            file.delete();
        }
    }

    public static String extensionToMime(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        if (string.equalsIgnoreCase("html")) {
            return "text/html";
        }
        if (string.equalsIgnoreCase("gml")) {
            return "text/gml";
        }
        if (string.equalsIgnoreCase("sgml")) {
            return "text/sgml";
        }
        if (string.equalsIgnoreCase("gif")) {
            return "image/gif";
        }
        if (string.equalsIgnoreCase("png")) {
            return "image/png";
        }
        if (string.equalsIgnoreCase("jpeg")) {
            return "image/jpeg";
        }
        if (string.equalsIgnoreCase("jpg")) {
            return "image/jpg";
        }
        if (string.equalsIgnoreCase("pdf")) {
            return "application/pdf";
        }
        if (string.equalsIgnoreCase("rtf")) {
            return "text/rtf";
        }
        return string2;
    }

    public static String getBody(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        String string2 = null;
        string2 = n == -1 ? string : string.substring(0, n);
        int n2 = string2.lastIndexOf(File.separator);
        if (n2 == -1) {
            return string2;
        }
        return string2.substring(n2 + 1);
    }

    public static Object getByteArrayAsObject(byte[] byArray) throws JUtilsException {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            throw new JUtilsException(ME, "Can't get the array of bytes from Object" + exception.toString());
        }
        return object;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static byte[] getObjectAsByteArray(Object object) throws JUtilsException {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            throw new JUtilsException(ME, "Can't get the Object as an array of bytes" + exception.toString());
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        String string = ME;
        String string2 = "Hello.txt";
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = ".";
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = "Hello";
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = "....";
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = ".xml";
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = "";
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = null;
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = String.valueOf(File.separator) + "home" + File.separator + "joe" + File.separator + "Hello.txt";
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
        string2 = String.valueOf(File.separator) + File.separator + File.separator;
        System.out.println(String.valueOf(string2) + " -> <" + FileUtil.getBody(string2) + "> and <" + FileUtil.getExtension(string2) + ">");
    }

    public static final String readAsciiFile(String string) throws JUtilsException {
        return FileUtil.readAsciiFile(null, string);
    }

    public static final String readAsciiFile(String string, String string2) throws JUtilsException {
        byte[] byArray = FileUtil.readFile(string, string2);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public static final byte[] readFile(String string) throws JUtilsException {
        return FileUtil.readFile(null, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] readFile(String string, String string2) throws JUtilsException {
        File file;
        byte[] byArray;
        block12: {
            byArray = null;
            file = new File(string, string2);
            if (!file.exists()) {
                throw new JUtilsException(ME, "Sorry, can't find file " + string2);
            }
            if (!file.isFile()) throw new JUtilsException(ME, "Sorry, doesn't seem to be a file " + string2 + " or is empty");
            if (file.length() < 1L) {
                throw new JUtilsException(ME, "Sorry, doesn't seem to be a file " + string2 + " or is empty");
            }
            if (!file.canRead()) {
                throw new JUtilsException(ME, "Sorry, no access permissions for file " + string2);
            }
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    byArray = new byte[(int)file.length()];
                    int n = fileInputStream.read(byArray);
                    if ((long)n != file.length()) {
                        throw new JUtilsException(ME, "File read error in " + string2 + ": Excpected " + file.length() + " bytes, but only found " + n + "bytes");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JUtilsException(ME, fileNotFoundException.toString());
                }
                catch (IOException iOException) {
                    throw new JUtilsException(ME, iOException.toString());
                }
                Object var6_8 = null;
                if (fileInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            fileInputStream.close();
        }
        if (file.length() == (long)byArray.length) return byArray;
        throw new JUtilsException(ME, "Read file " + string2 + " with size=" + file.length() + " but only got " + byArray.length + " bytes");
    }

    public static final Vector readFileNoComments(String string, String string2, String string3) throws JUtilsException {
        String string4;
        Vector<String> vector = new Vector<String>();
        String string5 = FileUtil.readAsciiFile(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string5, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4 == null) continue;
            if (string2 != null) {
                if (string4.startsWith(string2)) continue;
                int n = string4.indexOf(string2);
                if (n >= 0) {
                    string4 = string4.substring(0, n);
                }
            }
            if (string4.trim().length() < 1) continue;
            stringBuffer.append(" " + string4);
        }
        stringTokenizer = new StringTokenizer(stringBuffer.toString(), string3);
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            vector.addElement(string4);
        }
        return vector;
    }

    public static boolean rename(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        boolean bl = file.renameTo(file2);
        return bl;
    }

    public static final void writeFile(String string, String string2) throws JUtilsException {
        FileUtil.writeFile(null, string, string2.getBytes());
    }

    public static final void writeFile(String string, String string2, String string3) throws JUtilsException {
        FileUtil.writeFile(string, string2, string3.getBytes());
    }

    public static final void writeFile(String string, String string2, byte[] byArray) throws JUtilsException {
        try {
            File file = new File(string, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new JUtilsException(ME, "Can't write file " + exception.toString());
        }
    }

    public static final void writeFile(String string, byte[] byArray) throws JUtilsException {
        FileUtil.writeFile(null, string, byArray);
    }
}

