/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.log;

import java.io.File;
import java.io.FileOutputStream;
import org.jutils.log.LogChannel;
import org.jutils.log.LogConstants;
import org.jutils.log.LogableDevice;

public class LogDeviceFile
implements LogConstants,
LogableDevice {
    private static String ME = "LogDeviceFile";
    private static final String errorX = new String("ERROR");
    private static final String warnX = new String("WARN ");
    private static final String infoX = new String("INFO ");
    private static final String callX = new String("CALL ");
    private static final String timeX = new String("TIME ");
    private static final String traceX = new String("TRACE");
    private static final String dumpX = new String("DUMP ");
    private static final String plainX = new String("     ");
    private LogChannel channel = null;
    private String fileName = "jutils.log";
    private File logFile = null;
    private FileOutputStream to = null;
    private int maxLogFileLines = 50000;
    private int numLogLines = 0;
    private byte[] newLine = null;
    private int fileCounter = 1;

    public LogDeviceFile(LogChannel logChannel, String string) {
        this.channel = logChannel;
        if (string != null && string.length() > 1) {
            this.fileName = string;
        }
        this.initialize();
    }

    private String convertLevelToString(int n) {
        if ((n & 1) > 0) {
            return errorX;
        }
        if ((n & 2) > 0) {
            return warnX;
        }
        if ((n & 4) > 0) {
            return infoX;
        }
        if ((n & 8) > 0) {
            return callX;
        }
        if ((n & 0x10) > 0) {
            return timeX;
        }
        if ((n & 0x20) > 0) {
            return traceX;
        }
        if ((n & 0x40) > 0) {
            return dumpX;
        }
        return "UNKNOWN LEVEL" + n;
    }

    public void initialize() {
        String string = System.getProperty("line.separator");
        this.newLine = string.getBytes();
        try {
            this.to = new FileOutputStream(this.fileName, true);
        }
        catch (Exception exception) {
            this.channel.removeLogDevice(this);
            this.channel.error(ME, "Can't access file " + this.fileName + ": " + exception.toString());
            this.channel.info(ME, "Removing logging device for " + this.fileName);
        }
    }

    public void log(int n, String string, String string2) {
        if (this.channel == null) {
            return;
        }
        String string3 = this.convertLevelToString(n);
        String string4 = this.channel.formatLogData(string3, n, string, string2);
        if (this.numLogLines > this.maxLogFileLines) {
            this.newLogFile();
        }
        ++this.numLogLines;
        try {
            this.to.write(string4.getBytes());
            this.to.write(this.newLine);
        }
        catch (Exception exception) {
            this.channel.removeLogDevice(this);
            this.channel.error(ME, "Can't write to file " + this.fileName + ": " + exception.toString());
            this.channel.info(ME, "Removing logging device for " + this.fileName);
        }
    }

    private void newLogFile() {
        try {
            this.to.close();
        }
        catch (Throwable throwable) {}
        String string = String.valueOf(this.fileName) + ".backup" + this.fileCounter;
        ++this.fileCounter;
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        this.logFile = new File(this.fileName);
        if (this.logFile.exists()) {
            this.logFile.renameTo(file);
        }
        this.logFile = new File(this.fileName);
        if (this.logFile.exists()) {
            this.logFile.delete();
        }
        this.numLogLines = 0;
        try {
            this.to = new FileOutputStream(this.fileName, true);
        }
        catch (Exception exception) {
            this.channel.removeLogDevice(this);
            this.channel.error(ME, "Can't access file " + this.fileName + ": " + exception.toString());
            this.channel.info(ME, "Removing logging device for " + this.fileName);
        }
    }
}

