/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.log;

import java.util.Hashtable;
import org.jutils.log.LogChannel;
import org.jutils.log.LogConstants;
import org.jutils.log.LogDeviceConsole;
import org.jutils.runtime.StackTrace;

public class LogManager
implements LogConstants {
    private static final String DEFAULT_CHANNEL = "default";
    private static Hashtable channels = new Hashtable();

    static {
        LogManager.initialize();
    }

    public static boolean addLogChannel(String string, LogChannel logChannel) {
        if (string != null && !string.equals("") && logChannel != null) {
            channels.put(string, logChannel);
            return true;
        }
        return false;
    }

    public static void call(String string, String string2, String string3) {
        LogManager.log(string, 8, string2, string3);
    }

    public static void dump(String string, String string2, String string3) {
        LogManager.log(string, 64, string2, string3);
    }

    public static void error(String string, String string2, String string3) {
        LogManager.log(string, 1, string2, string3);
    }

    public static void exception(String string, String string2, Throwable throwable) {
        String string3 = StackTrace.getStackTrace(throwable);
        LogManager.log(string, 1, string2, string3);
    }

    public static LogChannel getLogChannel(String string) {
        LogChannel logChannel = (LogChannel)channels.get(string);
        return logChannel;
    }

    public static void info(String string, String string2, String string3) {
        LogManager.log(string, 4, string2, string3);
    }

    public static void initialize() {
        LogChannel logChannel = new LogChannel(null);
        logChannel.addLogLevel(255);
        logChannel.addLogDevice(new LogDeviceConsole(logChannel));
        LogManager.addLogChannel(DEFAULT_CHANNEL, logChannel);
    }

    public static void log(String string) {
        LogManager.log(DEFAULT_CHANNEL, 128, "", string);
    }

    public static void log(String string, int n, String string2, String string3) {
        if (string == null || string.equals("")) {
            LogManager.log(DEFAULT_CHANNEL, n, string2, string3);
            return;
        }
        LogChannel logChannel = (LogChannel)channels.get(string);
        if (logChannel != null) {
            logChannel.log(n, string2, string3);
        } else if (!string.equals(DEFAULT_CHANNEL)) {
            LogManager.log(DEFAULT_CHANNEL, 1, string2, "LogManager.java - logchannel '" + string + "' not found! [" + string3 + "]");
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("\n### BEGIN TEST 1 ###");
        LogManager.log("Test1");
        LogManager.log(DEFAULT_CHANNEL, 128, "LogManager", "Test1");
        LogManager.log(DEFAULT_CHANNEL, 1, "LogManager", "Test1");
        System.out.println("### END TEST 1 ###\n");
        System.out.println("\n### BEGIN TEST 2 ###");
        LogChannel logChannel = new LogChannel(null);
        LogDeviceConsole logDeviceConsole = new LogDeviceConsole(logChannel);
        logDeviceConsole.setColorMode(true);
        logChannel.addLogDevice(logDeviceConsole);
        LogManager.addLogChannel("log1", logChannel);
        LogChannel logChannel2 = new LogChannel(null);
        LogDeviceConsole logDeviceConsole2 = new LogDeviceConsole(logChannel2);
        logDeviceConsole2.setColorMode(false);
        logChannel2.addLogDevice(logDeviceConsole2);
        LogManager.addLogChannel("log2", logChannel2);
        LogManager.log("log1", 4, "LogManager.main()", "Output1");
        LogManager.log("log2", 1, "LogManager.main()", "Output2");
        System.out.println("### END TEST 2 ###\n");
        System.out.println("\n### BEGIN TEST 3 ###");
        LogManager.error("log1", "LogManager.main()", "3_1");
        LogManager.warn("log1", "LogManager.main()", "3_2");
        LogManager.info("log1", "LogManager.main()", "3_3");
        LogManager.call("log1", "LogManager.main()", "3_4");
        LogManager.time("log1", "LogManager.main()", "3_5");
        LogManager.trace("log1", "LogManager.main()", "3_6");
        LogManager.plain("log1", "LogManager.main()", "3_7");
        System.out.println("### END TEST 3 ###\n");
    }

    public static void plain(String string, String string2, String string3) {
        LogManager.log(string, 128, string2, string3);
    }

    public static void time(String string, String string2, String string3) {
        LogManager.log(string, 16, string2, string3);
    }

    public static void trace(String string, String string2, String string3) {
        LogManager.log(string, 32, string2, string3);
    }

    public static void warn(String string, String string2, String string3) {
        LogManager.log(string, 2, string2, string3);
    }
}

