/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.media;

public class MediaHelper {
    public static final String MIME_UNKNOWN = "application/octet-stream";
    public static final String EXTENSION_UNKNOWN = "unknown";
    protected static final String[] EXTENSIONS_UNKNOWN = new String[]{"unknown"};
    private static String[][][] dataTable = new String[][][]{{{"application/activemessage"}, {""}}, {{"application/andrew-inset"}, {"ez"}}, {{"application/applefile"}, {""}}, {{"application/atomicmail"}, {""}}, {{"application/cu-seeme"}, {"csm"}}, {{"application/cu-seeme"}, {"cu"}}, {{"application/dca-rft"}, {""}}, {{"application/dec-dx"}, {""}}, {{"application/excel"}, {"xls"}}, {{"application/ghostview"}, {""}}, {{"application/mac-binhex40"}, {"hqx"}}, {{"application/mac-compactpro"}, {"cpt"}}, {{"application/macwriteii"}, {""}}, {{"application/msword"}, {"doc", "dot", "wrd"}}, {{"application/news-message-id"}, {""}}, {{"application/news-transmission"}, {""}}, {{"application/octet-stream"}, {"bin", "dms", "lha", "lzh", "exe", "class"}}, {{"application/oda"}, {"oda"}}, {{"application/pdf"}, {"pdf"}}, {{"application/pgp"}, {"pgp"}}, {{"application/pgp-signature"}, {"pgp"}}, {{"application/postscript"}, {"ps", "eps", "ai"}}, {{"application/powerpoint"}, {"ppt"}}, {{"application/remote-printing"}, {""}}, {{"application/rtf"}, {"rtf"}}, {{"application/slate"}, {""}}, {{"application/wita"}, {""}}, {{"application/wordperfect5.1"}, {"wp5"}}, {{"application/x-123"}, {"wk"}}, {{"application/x-Wingz"}, {"wz"}}, {{"application/x-bcpio"}, {"bcpio"}}, {{"application/x-cdlink"}, {"vcd"}}, {{"application/x-chess-pgn"}, {"pgn"}}, {{"application/x-compress"}, {"z", "Z"}}, {{"application/x-cpio"}, {"cpio"}}, {{"application/x-csh"}, {"csh"}}, {{"application/x-debian-package"}, {"deb"}}, {{"application/x-director"}, {"dcr", "dir", "dxr"}}, {{"application/x-dvi"}, {"dvi"}}, {{"application/x-gtar"}, {"gtar", "tgz"}}, {{"application/x-gunzip"}, {"gz"}}, {{"application/x-gzip"}, {"gz"}}, {{"application/x-hdf"}, {"hdf"}}, {{"application/x-httpd-php"}, {"phtml", "pht", "php"}}, {{"application/x-javascript"}, {"js"}}, {{"application/x-koan"}, {"skp", "skd", "skt", "skm"}}, {{"application/x-latex"}, {"latex"}}, {{"application/x-maker"}, {"frm", "maker", "frame", "fm", "fb", "book", "fbdoc"}}, {{"application/x-mif"}, {"mif"}}, {{"application/x-msdos-program"}, {"com", "exe", "bat"}}, {{"application/x-netcdf"}, {"nc", "cdf"}}, {{"application/x-perl"}, {"pl", "pm"}}, {{"application/x-pilot"}, {"prc"}}, {{"application/x-sh"}, {"sh"}}, {{"application/x-shar"}, {"shar"}}, {{"application/x-shockwave-flash"}, {"swf"}}, {{"application/x-stuffit"}, {"sit"}}, {{"application/x-sv4cpio"}, {"sv4cpio"}}, {{"application/x-sv4crc"}, {"sv4crc"}}, {{"application/x-tar"}, {"tar"}}, {{"application/x-tcl"}, {"tcl"}}, {{"application/x-tex"}, {"tex"}}, {{"application/x-texinfo"}, {"texinfo", "texi"}}, {{"application/x-troff"}, {"t", "tr", "roff"}}, {{"application/x-troff-man"}, {"man"}}, {{"application/x-troff-me"}, {"me"}}, {{"application/x-troff-ms"}, {"ms"}}, {{"application/x-ustar"}, {"ustar"}}, {{"application/x-wais-source"}, {"src"}}, {{"application/zip"}, {"zip"}}, {{"audio/basic"}, {"au", "snd"}}, {{"audio/midi"}, {"mid", "midi", "kar"}}, {{"audio/mpeg"}, {"mp3", "mpga", "mp2"}}, {{"audio/x-aiff"}, {"aif", "aifc", "aiff"}}, {{"audio/x-pn-realaudio"}, {"ra", "ram"}}, {{"audio/x-pn-realaudio-plugin"}, {""}}, {{"audio/x-realaudio"}, {"ra"}}, {{"audio/x-wav"}, {"wav"}}, {{"chemical/x-pdb"}, {"pdb", "xyz"}}, {{"image/bmp"}, {"bmp"}}, {{"image/gif"}, {"gif"}}, {{"image/ief"}, {"ief"}}, {{"image/jpeg"}, {"jpg", "jpeg", "jpe"}}, {{"image/pcx"}, {"pcx"}}, {{"image/png"}, {"png"}}, {{"image/svg+xml"}, {"svg", "svgz"}}, {{"image/tiff"}, {"tif", "tiff"}}, {{"image/x-cmu-raster"}, {"ras"}}, {{"image/x-coreldraw"}, {"cdr"}}, {{"image/x-jng"}, {"jng"}}, {{"image/x-portable-anymap"}, {"pnm"}}, {{"image/x-portable-bitmap"}, {"pbm"}}, {{"image/x-portable-graymap"}, {"pgm"}}, {{"image/x-portable-pixmap"}, {"ppm"}}, {{"image/x-rgb"}, {"rgb"}}, {{"image/x-xbitmap"}, {"xbm"}}, {{"image/x-xpixmap"}, {"xpm"}}, {{"image/x-xwindowdump"}, {"xwd"}}, {{"message/external-body"}, {""}}, {{"message/news"}, {""}}, {{"message/partial"}, {""}}, {{"message/rfc822"}, {""}}, {{"model/iges"}, {"igs", "iges"}}, {{"model/mesh"}, {"msh", "mesh", "silo"}}, {{"model/vrml"}, {"wrl", "vrml"}}, {{"multipart/alternative"}, {""}}, {{"multipart/appledouble"}, {""}}, {{"multipart/digest"}, {""}}, {{"multipart/mixed"}, {""}}, {{"multipart/parallel"}, {""}}, {{"text/comma-separated-values"}, {"csv"}}, {{"text/css"}, {"css"}}, {{"text/html"}, {"html", "htm"}}, {{"text/mathml"}, {"mml"}}, {{"text/plain"}, {"txt", "asc", "c", "cc", "h", "hh", "cpp", "hpp"}}, {{"text/richtext"}, {"rtx"}}, {{"text/tab-separated-values"}, {"tsv"}}, {{"text/x-setext"}, {"etx"}}, {{"text/x-sgml"}, {"sgml", "sgm"}}, {{"text/x-vCalendar"}, {"vcs"}}, {{"text/x-vCard"}, {"vcf"}}, {{"text/xml"}, {"xml", "dtd"}}, {{"video/dl"}, {"dl"}}, {{"video/fli"}, {"fli"}}, {{"video/gl"}, {"gl"}}, {{"video/mpeg"}, {"mpeg", "mp2", "mpe", "mpg"}}, {{"video/quicktime"}, {"mov", "qt"}}, {{"video/x-msvideo"}, {"avi"}}, {{"video/x-sgi-movie"}, {"movie"}}, {{"x-conference/x-cooltalk"}, {"ice"}}, {{"x-world/x-vrml"}, {"vrml", "wrl"}}};

    public static String[] getAllExtensions(String string) {
        int n = 0;
        if (string == null) {
            return EXTENSIONS_UNKNOWN;
        }
        n = (string = string.trim()).indexOf(47);
        if (n < 0) {
            return EXTENSIONS_UNKNOWN;
        }
        int n2 = 0;
        while (n2 < dataTable.length) {
            if (dataTable[n2][0][0].equalsIgnoreCase(string)) {
                return dataTable[n2][1];
            }
            ++n2;
        }
        return EXTENSIONS_UNKNOWN;
    }

    public static String getMimeType(String string) {
        int n = 0;
        if (string == null) {
            return MIME_UNKNOWN;
        }
        n = (string = string.trim()).lastIndexOf(46);
        String string2 = n < 0 ? string : string.substring(n + 1);
        if (string2.equalsIgnoreCase(EXTENSION_UNKNOWN)) {
            return MIME_UNKNOWN;
        }
        int n2 = 0;
        while (n2 < dataTable.length) {
            String[] stringArray = dataTable[n2][1];
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equalsIgnoreCase(string2)) {
                    return dataTable[n2][0][0];
                }
                ++n3;
            }
            ++n2;
        }
        return MIME_UNKNOWN;
    }

    public static String getSingleExtension(String string) {
        return MediaHelper.getAllExtensions(string)[0];
    }

    public static void main(String[] stringArray) {
        System.out.println("\n");
        System.out.println("TEST getMimeType");
        System.out.println("----------------");
        System.out.println("getMimeType(\"c\") = '" + MediaHelper.getMimeType("c") + "'");
        System.out.println("getMimeType(\"foo.bmp\") = '" + MediaHelper.getMimeType("foo.bmp") + "'");
        System.out.println("getMimeType(\"foo.cdr\") = '" + MediaHelper.getMimeType("foo.cdr") + "'");
        System.out.println("getMimeType(\"foo.jng\") = '" + MediaHelper.getMimeType("foo.jng") + "'");
        System.out.println("getMimeType(\"foo.pcx\") = '" + MediaHelper.getMimeType("foo.pcx") + "'");
        System.out.println("getMimeType(\"foo.prc\") = '" + MediaHelper.getMimeType("foo.prc") + "'");
        System.out.println("getMimeType(\"foo.svg\") = '" + MediaHelper.getMimeType("foo.svg") + "'");
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < 10000) {
            MediaHelper.getMimeType("c");
            ++n;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("Lasttest: 10000 x getMimeType: " + l3 + " ms");
        System.out.println("\n");
        System.out.println("TEST getSingleExtension");
        System.out.println("-----------------------");
        System.out.println("getSingleExtension(\"text/html\") = '" + MediaHelper.getSingleExtension("text/html") + "'");
        l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < 10000) {
            MediaHelper.getSingleExtension("text/html");
            ++n2;
        }
        l2 = System.currentTimeMillis();
        l3 = l2 - l;
        System.out.println("Lasttest: 10000 x getSingleExtension: " + l3 + " ms");
        System.out.println("\n");
        System.out.println("TEST getAllExtensions");
        System.out.println("---------------------");
        System.out.println("getAllExtensions(\"text/html\"): Anzahl = '" + MediaHelper.getAllExtensions("text/html").length + "'");
        l = System.currentTimeMillis();
        int n3 = 0;
        while (n3 < 10000) {
            MediaHelper.getAllExtensions("text/html");
            ++n3;
        }
        l2 = System.currentTimeMillis();
        l3 = l2 - l;
        System.out.println("Lasttest: 10000 x getAllExtensions: " + l3 + " ms");
        System.out.println("\n");
    }
}

