/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.runtime;

import java.util.List;
import java.util.Vector;
import org.jutils.runtime.IdleJobHandler;

public class IdleJobHandler
implements Runnable {
    private List jobs_;
    private boolean shutDown_ = false;
    private int DEFAULT_SLEEP_TIME = 5000;
    private static IdleJobHandler instance_ = null;
    private Thread myThread_ = null;
    private int passes_ = 0;
    private int sleepTime_ = this.DEFAULT_SLEEP_TIME;
    private boolean running_ = false;

    private IdleJobHandler() {
        this.jobs_ = new Vector(5);
    }

    public void addJob(Runnable runnable) {
        if (runnable != null && !this.jobs_.contains(runnable)) {
            this.jobs_.add(runnable);
        }
    }

    public int getPasses() {
        return this.passes_;
    }

    public int getSleepTime() {
        return this.sleepTime_;
    }

    public Thread getThread() {
        if (this.myThread_ == null) {
            this.myThread_ = new Thread(this);
            this.myThread_.setPriority(1);
            this.myThread_.setName("IdleThread");
        }
        return this.myThread_;
    }

    public static IdleJobHandler instance() {
        if (instance_ == null) {
            instance_ = new IdleJobHandler();
        }
        return instance_;
    }

    public boolean isRunning() {
        return this.running_;
    }

    public void join() throws InterruptedException {
        this.myThread_.join();
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing IdleJobHandler ...");
        System.out.println("Creating instance ...");
        IdleJobHandler idleJobHandler = IdleJobHandler.instance();
        idleJobHandler.start();
        idleJobHandler.setSleepTime(500);
        System.out.println("Inserting an idle job ...");
        class IdlePrintJob
        implements Runnable {
            IdlePrintJob() {
            }

            public void run() {
                System.out.println("IdleRunner printing 'Hello' !");
            }
        }
        IdlePrintJob idlePrintJob = new IdlePrintJob();
        idleJobHandler.addJob(idlePrintJob);
        System.out.println("Waiting for 5 passes ...");
        while (idleJobHandler.getPasses() < 5) {
            System.out.println("... looping ...");
            try {
                IdleJobHandler idleJobHandler2 = idleJobHandler;
                synchronized (idleJobHandler2) {
                    idleJobHandler.wait(2500L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("shutting down idle job ...");
        idleJobHandler.shutDown(true);
        System.out.println("Passes : " + idleJobHandler.getPasses());
        System.out.println("Thats it!");
    }

    public void removeJob(Runnable runnable) {
        if (runnable != null && this.jobs_.contains(runnable)) {
            this.jobs_.remove(runnable);
        }
    }

    public void run() {
        Object object;
        this.running_ = true;
        while (!this.shutDown_) {
            object = this.jobs_;
            synchronized (object) {
                if (this.jobs_.size() > 0) {
                    ++this.passes_;
                    int n = 0;
                    while (n < this.jobs_.size()) {
                        Runnable runnable = (Runnable)this.jobs_.get(n);
                        try {
                            runnable.run();
                        }
                        catch (Exception exception) {
                            System.err.println("IdleJob " + runnable.toString() + " caused an uncaught exception:");
                            exception.printStackTrace(System.err);
                        }
                        ++n;
                    }
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepTime_);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = this.myThread_;
        synchronized (object) {
            this.myThread_.notifyAll();
        }
        this.myThread_ = null;
        this.running_ = false;
    }

    public void setSleepTime(int n) {
        this.sleepTime_ = n;
    }

    public boolean shutDown(boolean bl) {
        this.shutDown_ = true;
        if (this.myThread_ != null && bl && this.myThread_.isAlive()) {
            try {
                this.myThread_.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.myThread_ == null || !this.myThread_.isAlive();
    }

    public boolean start() {
        Thread thread = this.getThread();
        if (!thread.isAlive()) {
            thread.start();
        }
        return thread.isAlive();
    }
}

