/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.runtime;

import org.jutils.runtime.ThreadPool;

public class PooledThread
extends Thread {
    private ThreadPool pool_;
    private Runnable target_;
    private boolean shutDown_ = false;
    private boolean idle_ = false;

    private PooledThread() {
    }

    private PooledThread(Runnable runnable) {
        super(runnable);
    }

    private PooledThread(Runnable runnable, String string) {
        super(runnable, string);
    }

    public PooledThread(Runnable runnable, String string, ThreadPool threadPool) {
        super(string);
        this.pool_ = threadPool;
        this.target_ = runnable;
    }

    private PooledThread(String string) {
        super(string);
    }

    private PooledThread(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
    }

    private PooledThread(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, runnable, string);
    }

    private PooledThread(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
    }

    public Runnable getTarget() {
        return this.target_;
    }

    public boolean isIdle() {
        return this.idle_;
    }

    public void run() {
        while (!this.shutDown_) {
            this.idle_ = false;
            if (this.target_ != null) {
                this.target_.run();
            }
            this.idle_ = true;
            try {
                this.pool_.repool(this);
                PooledThread pooledThread = this;
                synchronized (pooledThread) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.idle_ = false;
        }
    }

    public synchronized void setTarget(Runnable runnable) {
        this.target_ = runnable;
        this.notifyAll();
    }

    public synchronized void shutDown() {
        this.shutDown_ = true;
        this.notifyAll();
    }
}

