/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.runtime;

import java.util.List;
import java.util.Vector;
import org.jutils.runtime.PooledThread;
import org.jutils.runtime.ThreadPool;

public class ThreadPool {
    private static ThreadPool instance_ = null;
    public static final int LOW_PRIORITY = 0;
    public static final int NORMAL_PRIORITY = 1;
    public static final int HIGH_PRIORITY = 2;
    private List[] idleThreads_;
    private boolean shutDown_ = false;
    private int threadCreationCounter_;
    private boolean debug_ = false;

    private ThreadPool() {
        List[] listArray = new List[]{new Vector(5), new Vector(5), new Vector(5)};
        this.idleThreads_ = listArray;
        this.threadCreationCounter_ = 0;
    }

    public int getCreatedThreadsCount() {
        return this.threadCreationCounter_;
    }

    public static ThreadPool instance() {
        if (instance_ == null) {
            instance_ = new ThreadPool();
        }
        return instance_;
    }

    public boolean isDebug() {
        return this.debug_;
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing ThreadPool ...");
        System.out.println("Creating ThreadPool ...");
        ThreadPool threadPool = ThreadPool.instance();
        threadPool.setDebug(true);
        System.out.println("Starting a new thread ...");
        class TestRunner
        implements Runnable {
            public int count;

            TestRunner() {
                this.count = 0;
            }

            public void run() {
                System.out.println("Testrunner sleeping 5 seconds ...");
                TestRunner testRunner = this;
                synchronized (testRunner) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.out.println("Testrunner leaving  ...");
                ++this.count;
            }
        }
        TestRunner testRunner = new TestRunner();
        threadPool.start(testRunner, 2);
        System.out.println("count : " + testRunner.count);
        System.out.println("Thread count : " + threadPool.getCreatedThreadsCount());
        threadPool.shutdown();
    }

    protected synchronized void repool(PooledThread pooledThread) {
        if (!this.shutDown_) {
            if (this.debug_) {
                System.out.println("ThreadPool.repool() : repooling ...");
            }
            switch (pooledThread.getPriority()) {
                case 1: {
                    this.idleThreads_[0].add(pooledThread);
                    break;
                }
                case 5: {
                    this.idleThreads_[1].add(pooledThread);
                    break;
                }
                case 10: {
                    this.idleThreads_[2].add(pooledThread);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal priority found while repooling a Thread!");
                }
            }
            this.notifyAll();
        } else {
            if (this.debug_) {
                System.out.println("ThreadPool.repool() : Destroying incoming thread....");
            }
            pooledThread.shutDown();
        }
        if (this.debug_) {
            System.out.println("ThreadPool.recycle() : done.");
        }
    }

    public void setDebug(boolean bl) {
        this.debug_ = bl;
    }

    public synchronized void shutdown() {
        this.shutDown_ = true;
        if (this.debug_) {
            System.out.println("ThreadPool : shutting down ...");
        }
        int n = 0;
        while (n <= 2) {
            List list = this.idleThreads_[n];
            int n2 = 0;
            while (n2 < list.size()) {
                PooledThread pooledThread = (PooledThread)list.get(n2);
                pooledThread.shutDown();
                ++n2;
            }
            ++n;
        }
        this.notifyAll();
        if (this.debug_) {
            System.out.println("ThreadPool : shutdown done.");
        }
    }

    public synchronized void start(Runnable runnable, int n) {
        PooledThread pooledThread = null;
        List list = this.idleThreads_[n];
        if (list.size() > 0) {
            int n2 = list.size() - 1;
            pooledThread = (PooledThread)list.get(n2);
            list.remove(n2);
            pooledThread.setTarget(runnable);
        } else {
            ++this.threadCreationCounter_;
            pooledThread = new PooledThread(runnable, "PooledThread #" + this.threadCreationCounter_, this);
            switch (n) {
                case 0: {
                    pooledThread.setPriority(1);
                    break;
                }
                case 1: {
                    pooledThread.setPriority(5);
                    break;
                }
                case 2: {
                    pooledThread.setPriority(10);
                    break;
                }
                default: {
                    pooledThread.setPriority(5);
                }
            }
            pooledThread.start();
        }
    }
}

