/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.text;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class LinkExtractor {
    private LinkExtractor() {
    }

    private static Reader getReader(String string) throws IOException {
        if (string.startsWith("http:")) {
            URLConnection uRLConnection = new URL(string).openConnection();
            return new InputStreamReader(uRLConnection.getInputStream());
        }
        return new FileReader(string);
    }

    public static void main(String[] stringArray) {
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        Document document = ((EditorKit)hTMLEditorKit).createDefaultDocument();
        document.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            Element element;
            Reader reader = LinkExtractor.getReader(stringArray[0]);
            ((EditorKit)hTMLEditorKit).read(reader, document, 0);
            ElementIterator elementIterator = new ElementIterator(document);
            while ((element = elementIterator.next()) != null) {
                SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)element.getAttributes().getAttribute(HTML.Tag.A);
                if (simpleAttributeSet == null) continue;
                System.out.println(String.valueOf(stringArray[0]) + " : " + simpleAttributeSet.getAttribute(HTML.Attribute.HREF));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(1);
    }
}

