/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Vector;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.jutils.runtime.Memory;
import org.jutils.text.StringHelper;
import org.xmlBlaster.I_Main;
import org.xmlBlaster.MainGUI;
import org.xmlBlaster.engine.cluster.ClusterManager;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.engine.runlevel.RunlevelManager;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_SignalListener;
import org.xmlBlaster.util.SignalCatcher;
import org.xmlBlaster.util.XmlBlasterException;

public class Main
implements I_RunlevelListener,
I_Main,
I_SignalListener {
    private String ME = "Main";
    private org.xmlBlaster.engine.Global glob = null;
    private LogChannel log;
    private RunlevelManager runlevelManager = null;
    private boolean showUsage = false;
    private boolean inShutdownProcess = false;
    private SignalCatcher signalCatcher;
    static MainGUI controlPanel = null;

    public Main() {
    }

    public Main(org.xmlBlaster.engine.Global glob, MainGUI controlPanel) {
        Main.controlPanel = controlPanel;
        controlPanel.xmlBlasterMain = this;
        this.init(glob);
    }

    public Main(Global utilGlob) {
        this.init(utilGlob);
    }

    public Main(String[] args) {
        this.init(new org.xmlBlaster.engine.Global(args));
    }

    public org.xmlBlaster.engine.Global getGlobal() {
        return this.glob;
    }

    public void init(Global utilGlob) {
        org.xmlBlaster.engine.Global gg = new org.xmlBlaster.engine.Global(utilGlob.getProperty().getProperties(), false);
        utilGlob.setId(gg.getId());
        this.init(gg);
    }

    public void init(Properties props) {
        this.init(new org.xmlBlaster.engine.Global(props, true));
    }

    public final void init(org.xmlBlaster.engine.Global glob) {
        this.glob = glob;
        this.log = glob.getLog("core");
        this.ME = "Main" + glob.getLogPrefixDashed();
        this.showUsage = glob.wantsHelp();
        Thread.currentThread().setName("XmlBlaster.MainThread");
        if (glob.wantsHelp()) {
            this.showUsage = true;
        } else if (glob.getErrorText() != null) {
            this.usage();
            this.log.error(this.ME, glob.getErrorText());
            if (glob.isEmbedded()) {
                throw new IllegalArgumentException(glob.getErrorText());
            }
            System.exit(0);
        }
        int runlevel = glob.getProperty().get("runlevel", 9);
        try {
            this.runlevelManager = glob.getRunlevelManager();
            this.runlevelManager.addRunlevelListener(this);
            this.runlevelManager.initPluginManagers();
            this.runlevelManager.changeRunlevel(runlevel, false);
        }
        catch (Throwable e) {
            if (e instanceof XmlBlasterException) {
                this.log.error(this.ME, e.getMessage());
            } else {
                e.printStackTrace();
                this.log.error(this.ME, e.toString());
            }
            if (glob.isEmbedded()) {
                throw new IllegalArgumentException(e.toString());
            }
            this.log.error(this.ME, "Changing runlevel to '" + RunlevelManager.toRunlevelStr(runlevel) + "' failed, good bye");
            System.exit(1);
        }
        boolean useKeyboard = glob.getProperty().get("useKeyboard", true);
        if (!useKeyboard) {
            while (true) {
                try {
                    Thread.sleep(100000000L);
                }
                catch (InterruptedException e) {
                    this.log.warn(this.ME, "Caught exception: " + e.toString());
                }
            }
        }
        boolean doBlocking = glob.getProperty().get("doBlocking", true);
        if (doBlocking) {
            this.checkForKeyboardInput();
        }
    }

    public synchronized void destroy() {
        this.shutdown();
        if (this.glob != null) {
            this.glob.shutdown();
            this.glob = null;
        }
    }

    public synchronized void shutdown() {
        if (this.inShutdownProcess) {
            return;
        }
        this.inShutdownProcess = true;
        int errors = 0;
        try {
            errors = this.runlevelManager.changeRunlevel(0, true);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Problem during shutdown: " + e.toString());
        }
        if (errors > 0) {
            this.log.warn(this.ME, "There were " + errors + " errors during shutdown.");
        } else if (this.log.TRACE) {
            this.log.trace(this.ME, "shutdown() done");
        }
    }

    public I_Authenticate getAuthenticate() {
        return this.glob.getAuthenticate();
    }

    public I_XmlBlaster getXmlBlaster() {
        return this.getAuthenticate().getXmlBlaster();
    }

    private void checkForKeyboardInput() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                String line;
                while ((line = in.readLine()) == null) {
                }
                if ((line = line.trim()).toLowerCase().equals("g")) {
                    if (controlPanel == null) {
                        this.log.info(this.ME, "Invoking control panel GUI ...");
                        controlPanel = new MainGUI(this.glob, this);
                        controlPanel.run();
                        continue;
                    }
                    controlPanel.showWindow();
                    continue;
                }
                if (line.toLowerCase().equals("gc")) {
                    System.gc();
                    this.log.info(this.ME, "Garbage collector has run");
                    continue;
                }
                if (line.toLowerCase().startsWith("r")) {
                    if (line.length() > 1) {
                        String tmp = line.substring(1).trim();
                        int runlevel = -10;
                        try {
                            runlevel = Integer.parseInt(tmp.trim());
                        }
                        catch (NumberFormatException e) {
                            this.log.error(this.ME, "Invalid run level '" + tmp + "', it should be a number.");
                        }
                        try {
                            this.runlevelManager.changeRunlevel(runlevel, true);
                        }
                        catch (XmlBlasterException e) {
                            this.log.error(this.ME, e.toString());
                        }
                        continue;
                    }
                    this.log.info(this.ME, "Current runlevel is " + RunlevelManager.toRunlevelStr(this.runlevelManager.getCurrentRunlevel()) + "=" + this.runlevelManager.getCurrentRunlevel() + "");
                    continue;
                }
                if (line.toLowerCase().startsWith("d")) {
                    try {
                        String fileName = null;
                        if (line.length() > 1) {
                            fileName = line.substring(1).trim();
                        }
                        if (fileName == null) {
                            this.log.plain(this.ME, this.glob.getDump());
                            this.log.info(this.ME, "Dump done");
                            continue;
                        }
                        FileUtil.writeFile(fileName, this.glob.getDump());
                        this.log.info(this.ME, "Dumped internal state to '" + fileName + "'");
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(this.ME, "Sorry, dump failed: " + e.getMessage());
                    }
                    catch (JUtilsException e) {
                        this.log.error(this.ME, "Sorry, dump failed: " + e.getMessage());
                    }
                    continue;
                }
                if (line.toLowerCase().equals("q")) {
                    this.shutdown();
                    if (this.glob.isEmbedded()) continue;
                    System.exit(0);
                    continue;
                }
                this.keyboardUsage();
                continue;
            }
            catch (IOException e) {
                this.log.warn(this.ME, e.toString());
                continue;
            }
            break;
        }
    }

    private String createNodeId() throws XmlBlasterException {
        String ip;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
        }
        catch (Exception e) {
            this.log.warn(this.ME, "Can't determin your IP address");
            ip = "localhost";
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append("ClusterNodeId-").append(ip).append("-").append(System.currentTimeMillis());
        String nodeName = buf.toString();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Created node id='" + nodeName + "'");
        }
        return nodeName;
    }

    public boolean isHalted() {
        if (this.runlevelManager != null) {
            return this.runlevelManager.isHalted();
        }
        return true;
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (to == from) {
            return;
        }
        if (to > from) {
            boolean useSignalCatcher;
            if (to == 2 && (useSignalCatcher = this.glob.getProperty().get("useSignalCatcher", true))) {
                this.signalCatcher = new SignalCatcher(this.glob, this);
                this.signalCatcher.catchSignals();
            }
            if (to == 3) {
                // empty if block
            }
            if (to == 4 && this.showUsage) {
                this.usage();
                this.shutdown();
                if (!this.glob.isEmbedded()) {
                    System.exit(0);
                }
            }
            if (to == 6) {
                // empty if block
            }
            if (to == 9) {
                // empty if block
            }
            if (to == 10) {
                this.log.info(this.ME, Memory.getStatistic());
                if (controlPanel == null) {
                    int width = 48;
                    StringHelper sh = new StringHelper();
                    String line = sh.charChain('-', width - 2);
                    String bound = "+";
                    this.log.info(this.ME, " " + line + " ");
                    String ver = bound + " xmlBlaster " + this.glob.getVersion() + " build " + this.glob.getBuildTimestamp();
                    this.log.info(this.ME, ver + sh.charChain(' ', width - ver.length() - 1) + bound);
                    boolean useKeyboard = this.glob.getProperty().get("useKeyboard", true);
                    if (useKeyboard) {
                        String help = bound + " READY - press <?> and <enter> for options";
                        this.log.info(this.ME, help + sh.charChain(' ', width - help.length() - 1) + bound);
                    } else {
                        String help = bound + " READY - no keyboard input available";
                        this.log.info(this.ME, help + sh.charChain(' ', width - help.length() - 1) + bound);
                    }
                    this.log.info(this.ME, " " + line + " ");
                } else {
                    this.log.info(this.ME, "xmlBlaster is ready for requests");
                }
            }
        }
        if (to <= from) {
            if (to == 8 && this.log.TRACE) {
                this.log.trace(this.ME, "Shutting down xmlBlaster to runlevel " + RunlevelManager.toRunlevelStr(to) + " ...");
            }
            if (to == -1) {
                Main main = this;
                synchronized (main) {
                    if (this.glob != null) {
                        this.glob.shutdown();
                    }
                }
                this.log.info(this.ME, "XmlBlaster halted.");
            }
            if (to == 0) {
                Main main = this;
                synchronized (main) {
                    if (this.signalCatcher != null) {
                        this.signalCatcher.removeSignalCatcher();
                        this.signalCatcher = null;
                    }
                }
            }
        }
    }

    public void shutdownHook() {
        this.destroy();
    }

    private void keyboardUsage() {
        this.log.plain(this.ME, "----------------------------------------------------------");
        this.log.plain(this.ME, "XmlBlaster " + (this.glob != null ? this.glob.getVersion() : "") + (this.glob != null ? " build " + this.glob.getBuildTimestamp() : ""));
        this.log.plain(this.ME, "Following interactive keyboard input is recognized:");
        this.log.plain(this.ME, "Key:");
        this.log.plain(this.ME, "   g             Popup the control panel GUI.");
        this.log.plain(this.ME, "   r <run level> Change to run level (0,3,6,9).");
        this.log.plain(this.ME, "   d <file name> Dump internal state of xmlBlaster to file.");
        this.log.plain(this.ME, "   q             Quit xmlBlaster.");
        this.log.plain(this.ME, "----------------------------------------------------------");
    }

    private void usage() {
        this.log.plain(this.ME, "-----------------------" + this.glob.getVersion() + "-------------------------------");
        this.log.plain(this.ME, "java org.xmlBlaster.Main <options>");
        this.log.plain(this.ME, "----------------------------------------------------------");
        this.log.plain(this.ME, "   -h                  Show the complete usage.");
        this.log.plain(this.ME, "");
        Vector drivers = this.glob.getPluginRegistry().getPluginsOfInterfaceI_Driver();
        int i = 0;
        while (i < drivers.size()) {
            I_Driver driver = (I_Driver)drivers.get(i);
            this.log.plain(this.ME, driver.usage());
            ++i;
        }
        this.log.plain(this.ME, "");
        this.log.plain(this.ME, ClusterManager.usage());
        this.log.plain(this.ME, "");
        this.log.plain(this.ME, this.glob.usage());
        this.log.plain(this.ME, "");
        this.log.plain(this.ME, "Other stuff:");
        this.log.plain(this.ME, "   -useKeyboard false  Switch off keyboard input, to allow xmlBlaster running in background.");
        this.log.plain(this.ME, "   -doBlocking  false  Switch off blocking, the main method is by default never returning.");
        this.log.plain(this.ME, "   -admin.remoteconsole.port If port > 1000 a server is started which is available with telnet [2702].");
        this.log.plain(this.ME, "   -xmlBlaster.isEmbedded    If set to true no System.exit() is possible [false].");
        this.log.plain(this.ME, "   -xmlBlaster.activateJmx   Set to true to enable JMX access [false].");
        this.log.plain(this.ME, "   -wipeOutJdbcDB true Destroy the complete JDBC persistence store entries of prefix=XMLBLASTER (DANGER)");
        this.log.plain(this.ME, "----------------------------------------------------------");
        this.log.plain(this.ME, "Example:");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -cluster false");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -cluster.node.id heron");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -bootstrapPort 3412");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -plugin/ior/iorFile /tmp/XmlBlaster_Ref.ior");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -trace true -dump true -call true -time true");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -trace[mime] true -call[cluster] true -dump[corba] true");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -logFile /tmp/test.log -logDevice file,console");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -plugin/xmlrpc/hostname 102.24.64.60 -plugin/xmlrpc/port 8081");
        this.log.plain(this.ME, "   java org.xmlBlaster.Main -?");
        this.log.plain(this.ME, "See xmlBlaster.properties for more options");
        this.log.plain(this.ME, "");
    }

    public static void main(String[] args) {
        new Main(args);
    }
}

