/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Vector;
import org.jacorb.poa.gui.beans.FillLevelBar;
import org.jutils.log.LogChannel;
import org.jutils.log.LogableDevice;
import org.jutils.time.StopWatch;
import org.xmlBlaster.Main;
import org.xmlBlaster.MainGUI;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.engine.RequestBroker;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;

public class MainGUI
extends Frame
implements Runnable,
LogableDevice {
    private org.xmlBlaster.engine.Global glob;
    private LogChannel log;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private final String ME = "MainGUI";
    Main xmlBlasterMain = null;
    private Button exitButton;
    private Button hideButton;
    private Button clearLogButton;
    private Button dumpButton;
    private TextArea logOutput = null;
    private final long MAX_LOG_LINES = 3000L;
    private long numLogLines = 0L;
    private long elapsedTime = 0L;
    private long startupTime = 0L;
    private long lastPollingTime = 0L;
    private FillLevelBar publishedMessagesBar = new FillLevelBar();
    private Label publishedLabel = new Label();
    private int peakPublishedMessages = 0;
    private long publishedMessages = 0L;
    private long lastPublishedMessages = 0L;
    private FillLevelBar sentMessagesBar = new FillLevelBar();
    private Label sentLabel = new Label();
    private int peakSentMessages = 0;
    private long sentMessages = 0L;
    private long lastSentMessages = 0L;
    private FillLevelBar getMessagesBar = new FillLevelBar();
    private Label getLabel = new Label();
    private int peakGetMessages = 0;
    private long getMessages = 0L;
    private long lastGetMessages = 0L;
    private TextField inputTextField = new TextField();
    private TextArea queryOutput = null;
    private GuiQuery clientQuery = null;
    private QueryHistory queryHistory;

    public MainGUI(org.xmlBlaster.engine.Global glob, Main main) {
        this.xmlBlasterMain = main;
        this.glob = glob;
        this.log = glob.getLog("core");
        URL oUrl = this.getClass().getResource("AppIcon.gif");
        Image img = null;
        if (oUrl != null) {
            img = Toolkit.getDefaultToolkit().getImage(oUrl);
        }
        if (img != null) {
            this.setIconImage(img);
            System.out.println(img.toString());
        } else {
            System.out.println("AppIcon.gif not found");
        }
        this.setTitle("XmlBlaster Control Panel");
        this.init();
        PollingThread poller = new PollingThread(this);
        poller.start();
    }

    public void run() {
        this.show();
        if (this.xmlBlasterMain == null) {
            this.xmlBlasterMain = new Main(this.glob, this);
        }
    }

    public void log(int level, String source, String str) {
        str = LogChannel.bitToLogLevel(level) + " [" + source + "] " + str;
        if (this.logOutput == null) {
            System.err.println(str + "\n");
            return;
        }
        if (this.numLogLines > 3000L) {
            String text = this.logOutput.getText();
            text = text.substring(text.length() / 2, text.length());
            this.logOutput.setText(text);
        }
        ++this.numLogLines;
        this.logOutput.append(str + "\n");
    }

    void pollEvent(long sleepTime) {
        long current = System.currentTimeMillis();
        if (this.lastPollingTime > 0L) {
            sleepTime = current - this.lastPollingTime;
        }
        this.lastPollingTime = current;
        this.elapsedTime += current - this.startupTime;
        double sleepSeconds = (double)sleepTime / 1000.0;
        double elapsedSeconds = (double)this.elapsedTime / 1000.0;
        this.publishedMessages = RequestBroker.publishedMessages;
        int currentPublishedAvg = (int)((double)(this.publishedMessages - this.lastPublishedMessages) / sleepSeconds);
        if (this.publishedMessages - this.lastPublishedMessages == 1L) {
            currentPublishedAvg = 1;
        }
        int totalPublishedAvg = (int)((double)this.publishedMessages / elapsedSeconds);
        this.publishedMessagesBar.setCurrentValue(currentPublishedAvg);
        if (currentPublishedAvg > this.peakPublishedMessages) {
            this.peakPublishedMessages = currentPublishedAvg;
            this.publishedMessagesBar.setAvgValue(this.peakPublishedMessages);
        }
        this.publishedLabel.setText("Total:  " + this.publishedMessages);
        this.lastPublishedMessages = this.publishedMessages;
        this.sentMessages = SessionInfo.sentMessages;
        int currentSentAvg = (int)((double)(this.sentMessages - this.lastSentMessages) / sleepSeconds);
        if (this.sentMessages - this.lastSentMessages == 1L) {
            currentSentAvg = 1;
        }
        int totalSentAvg = (int)((double)this.sentMessages / elapsedSeconds);
        this.sentMessagesBar.setCurrentValue(currentSentAvg);
        if (currentSentAvg > this.peakSentMessages) {
            this.peakSentMessages = currentSentAvg;
            this.sentMessagesBar.setAvgValue(this.peakSentMessages);
        }
        this.sentLabel.setText("Total:  " + this.sentMessages);
        this.lastSentMessages = this.sentMessages;
        this.getMessages = RequestBroker.getMessages;
        int currentGetAvg = (int)((double)(this.getMessages - this.lastGetMessages) / sleepSeconds);
        if (this.getMessages - this.lastGetMessages == 1L) {
            currentGetAvg = 1;
        }
        int totalGetAvg = (int)((double)this.getMessages / elapsedSeconds);
        this.getMessagesBar.setCurrentValue(currentGetAvg);
        if (currentGetAvg > this.peakGetMessages) {
            this.peakGetMessages = currentGetAvg;
            this.getMessagesBar.setAvgValue(this.peakGetMessages);
        }
        this.getLabel.setText("Total:  " + this.getMessages);
        this.lastGetMessages = this.getMessages;
    }

    private void init() {
        int offset;
        this.log.setDefaultLogLevel();
        this.log.addLogDevice(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.exitButton = new Button("Exit");
        class BeepListener
        implements ActionListener {
            private final /* synthetic */ MainGUI this$0;

            BeepListener(MainGUI this$0) {
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                MainGUI.access$000(this.this$0).beep();
                if (MainGUI.access$100(this.this$0) != null) {
                    MainGUI.access$100(this.this$0).logout();
                }
                MainGUI.access$200(this.this$0).info("MainGUI", "Good bye!");
                System.exit(0);
            }
        }
        this.exitButton.addActionListener(new BeepListener(this));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)this.exitButton, gbc);
        this.hideButton = new Button("Hide Window");
        class HideListener
        implements ActionListener {
            private final /* synthetic */ MainGUI this$0;

            HideListener(MainGUI this$0) {
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                MainGUI.access$300(this.this$0);
            }
        }
        this.hideButton.addActionListener(new HideListener(this));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)this.hideButton, gbc);
        gbc.gridx = offset = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.createBarPanel(this.publishedMessagesBar, this.publishedLabel, "Published", gbc, offset++);
        this.createBarPanel(this.sentMessagesBar, this.sentLabel, "Update", gbc, offset++);
        this.createBarPanel(this.getMessagesBar, this.getLabel, "Get", gbc, offset++);
        Panel panel = new Panel();
        panel.setName("QueryPanel");
        panel.setLayout(new BorderLayout());
        panel.setBackground(SystemColor.control);
        Panel inputPanel = new Panel();
        inputPanel.setLayout(new BorderLayout());
        Label inputLabel = new Label("XPath query: ");
        inputPanel.add("West", inputLabel);
        this.inputTextField.setText("//key");
        inputPanel.add("Center", this.inputTextField);
        this.inputTextField.addKeyListener(new XPathKeyListener());
        panel.add("North", inputPanel);
        this.queryOutput = new TextArea();
        this.queryOutput.setEditable(false);
        panel.add("South", this.queryOutput);
        gbc.gridx = offset;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        this.add((Component)panel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        this.add((Component)new Label("Choose Logging Level: "), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        this.add((Component)this.createLogLevelBoxes(), gbc);
        this.clearLogButton = new Button("Clear Log Window");
        class ClearListener
        implements ActionListener {
            private final /* synthetic */ MainGUI this$0;

            ClearListener(MainGUI this$0) {
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                MainGUI.access$500(this.this$0).setText("");
            }
        }
        this.clearLogButton.addActionListener(new ClearListener(this));
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)this.clearLogButton, gbc);
        this.dumpButton = new Button("Dump State");
        class DumpListener
        implements ActionListener {
            private final /* synthetic */ MainGUI this$0;

            DumpListener(MainGUI this$0) {
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    MainGUI.access$200(this.this$0).info("MainGUI", "Dump start");
                    I_Authenticate auth = this.this$0.xmlBlasterMain.getAuthenticate();
                    StringBuffer buf = new StringBuffer(auth.toXml());
                    buf.append(this.this$0.xmlBlasterMain.getXmlBlaster().toXml());
                    this.this$0.log(64, "MainGUI", buf.toString());
                    MainGUI.access$200(this.this$0).info("MainGUI", "Dump end");
                }
                catch (XmlBlasterException ee) {
                    MainGUI.access$200(this.this$0).error("MainGUI", "Sorry, dump failed: " + ee.getMessage());
                }
            }
        }
        this.dumpButton.addActionListener(new DumpListener(this));
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)this.dumpButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 6;
        gbc.gridheight = 6;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.logOutput = new TextArea("", 30, 100);
        this.logOutput.setEditable(false);
        this.add((Component)this.logOutput, gbc);
        this.pack();
        this.startupTime = System.currentTimeMillis();
    }

    private void hideWindow() {
        if (this.isShowing()) {
            this.log.removeLogDevice(this);
            this.log.info("MainGUI", "Press <g> and <Enter> to popup the GUI again (press ? for other options).");
            ((Component)this).setVisible(false);
        }
    }

    void showWindow() {
        if (!this.isShowing()) {
            if (this.log.TRACE) {
                this.log.trace("MainGUI", "Show window again ...");
            }
            this.log.addLogDevice(this);
            this.show();
        }
    }

    private void createBarPanel(FillLevelBar messageBar, Label totalCountLabel, String token, GridBagConstraints gbc, int offset) {
        int LABEL_LOCATION_X = 2;
        int LABEL_LOCATION_Y = 10;
        int LABEL_WIDTH = 90;
        int LABEL_HEIGHT = 12;
        int BAR_X = 32;
        int BAR_Y = 34;
        int BAR_WIDTH = 50;
        int BAR_HEIGHT = 130;
        int TOTAL_LABEL_Y = 164;
        int PANEL_WIDTH = 94;
        int PANEL_HEIGHT = 180;
        Font barFont = new Font("dialog", 2, 10);
        Panel panel = new Panel();
        panel.setName(token + "MessagePanel");
        panel.setLayout(null);
        panel.setBackground(SystemColor.control);
        panel.setSize(94, 180);
        Label label1 = new Label();
        label1.setName("Label1");
        label1.setLocation(2, 10);
        label1.setText(token);
        label1.setBackground(SystemColor.control);
        label1.setSize(90, 12);
        label1.setForeground(Color.black);
        label1.setFont(barFont);
        label1.setAlignment(1);
        panel.add((Component)label1, label1.getName());
        Label label2 = new Label();
        label2.setName("Label2");
        label2.setLocation(2, 22);
        label2.setText("[messages/sec]");
        label2.setBackground(SystemColor.control);
        label2.setSize(90, 12);
        label2.setForeground(Color.black);
        label2.setFont(barFont);
        label2.setAlignment(1);
        panel.add((Component)label2, label2.getName());
        messageBar.setName(token + "Messages");
        messageBar.setLocation(32, 34);
        messageBar.setBackground(SystemColor.control);
        messageBar.setSize(50, 130);
        boolean useAvg = true;
        boolean isVariable = true;
        int MAX_SCALE = 10;
        messageBar.init(0, 5, MAX_SCALE, Color.green, Color.green, useAvg, isVariable);
        messageBar.setAvgValue(0);
        panel.add((Component)messageBar, messageBar.getName());
        totalCountLabel.setName(token + "Label");
        totalCountLabel.setLocation(2, 164);
        totalCountLabel.setText("Total:  0");
        totalCountLabel.setBackground(SystemColor.control);
        totalCountLabel.setSize(90, 12);
        totalCountLabel.setForeground(Color.black);
        totalCountLabel.setFont(barFont);
        totalCountLabel.setAlignment(1);
        panel.add((Component)totalCountLabel, totalCountLabel.getName());
        gbc.gridx = offset;
        this.add((Component)panel, gbc);
    }

    private Panel createLogLevelBoxes() {
        Panel container = new Panel();
        container.setLayout(new GridLayout(1, 7));
        Checkbox error = new Checkbox("ERROR", null, true);
        error.addItemListener(new LogLevelListener());
        container.add(error);
        Checkbox warning = new Checkbox("WARN", null, true);
        warning.addItemListener(new LogLevelListener());
        container.add(warning);
        Checkbox info = new Checkbox("INFO", null, true);
        info.addItemListener(new LogLevelListener());
        container.add(info);
        Checkbox calls = new Checkbox("CALL", null, false);
        calls.addItemListener(new LogLevelListener());
        container.add(calls);
        Checkbox time = new Checkbox("TIME", null, false);
        time.addItemListener(new LogLevelListener());
        container.add(time);
        Checkbox trace = new Checkbox("TRACE", null, false);
        trace.addItemListener(new LogLevelListener());
        container.add(trace);
        Checkbox dump = new Checkbox("DUMP", null, false);
        dump.addItemListener(new LogLevelListener());
        container.add(dump);
        return container;
    }

    private QueryHistory getQueryHistory() {
        if (this.queryHistory == null) {
            this.queryHistory = new QueryHistory();
        }
        return this.queryHistory;
    }

    public static void main(String[] args) {
        org.xmlBlaster.engine.Global glob = new org.xmlBlaster.engine.Global(args);
        Main.controlPanel = new MainGUI(glob, null);
        Main.controlPanel.run();
    }

    private void displayHistory(String stmt) {
        if (stmt.length() < 1) {
            return;
        }
        this.inputTextField.setText(stmt);
    }

    static /* synthetic */ Toolkit access$000(MainGUI x0) {
        return x0.toolkit;
    }

    static /* synthetic */ void access$300(MainGUI x0) {
        x0.hideWindow();
    }

    static /* synthetic */ TextArea access$500(MainGUI x0) {
        return x0.logOutput;
    }

    private class QueryHistory {
        private String ME = "QueryHistory";
        private Vector stack = new Vector();
        private int currentIndex = 0;

        public void changedHistory(String stmt) {
            String last;
            if (this.stack.size() > 1 && (last = (String)this.stack.elementAt(this.stack.size() - 1)).equals(stmt)) {
                return;
            }
            this.currentIndex = this.stack.size();
            this.stack.addElement(stmt);
        }

        String getPrev() {
            if (this.stack.size() < 1) {
                return "";
            }
            if (this.currentIndex > 0) {
                --this.currentIndex;
            }
            return (String)this.stack.elementAt(this.currentIndex);
        }

        String getNext() {
            if (this.stack.size() < 1) {
                return "";
            }
            if (this.currentIndex < this.stack.size() - 1) {
                ++this.currentIndex;
            }
            return (String)this.stack.elementAt(this.currentIndex);
        }

        String getLast() {
            if (this.stack.size() < 1) {
                return "";
            }
            this.currentIndex = this.stack.size() - 1;
            return (String)this.stack.elementAt(this.currentIndex);
        }

        String getFirst() {
            if (this.stack.size() < 1) {
                return "";
            }
            this.currentIndex = 0;
            return (String)this.stack.elementAt(this.currentIndex);
        }
    }

    private class GuiQuery {
        private final String ME = "__sys__GuiQuery";
        private String queryType = "XPATH";
        private StopWatch stop = new StopWatch();
        I_Authenticate authenticate;
        private I_XmlBlaster xmlBlasterImpl;
        private String secretSessionId;

        public GuiQuery(I_Authenticate authenticate, I_XmlBlaster xmlBlasterImpl) throws XmlBlasterException {
            this.xmlBlasterImpl = xmlBlasterImpl;
            this.authenticate = authenticate;
            String loginName = MainGUI.this.glob.getProperty().get("__sys__GuiQuery.loginName", "__sys__GuiQuery");
            String passwd = MainGUI.this.glob.getProperty().get("__sys__GuiQuery.password", "secret");
            ConnectQos connectQos = new ConnectQos(authenticate.getGlobal());
            connectQos.loadClientPlugin("htpasswd", "1.0", loginName, passwd);
            connectQos.getSessionQos().setSessionTimeout(0L);
            String ret = authenticate.connect(connectQos.toXml(), null);
            ConnectReturnQos retQos = new ConnectReturnQos((Global)authenticate.getGlobal(), ret);
            this.secretSessionId = retQos.getSecretSessionId();
            MainGUI.this.log.info("__sys__GuiQuery", "login for '" + loginName + "' successful.");
        }

        MsgUnitRaw[] get(String queryString) {
            try {
                GetKey getKey = new GetKey(this.authenticate.getGlobal(), queryString, this.queryType);
                this.stop.restart();
                MsgUnitRaw[] msgArr = this.xmlBlasterImpl.get(this.secretSessionId, getKey.toXml(), "<qos/>");
                MainGUI.this.log.info("__sys__GuiQuery", "Got " + msgArr.length + " messages for query '" + queryString + "'" + this.stop.nice());
                return msgArr;
            }
            catch (XmlBlasterException e) {
                MainGUI.this.log.error("__sys__GuiQuery", "XmlBlasterException: " + e.getMessage());
                return new MsgUnitRaw[0];
            }
        }

        void logout() {
            try {
                this.authenticate.disconnect(this.secretSessionId, null);
            }
            catch (XmlBlasterException xmlBlasterException) {
                // empty catch block
            }
        }
    }

    private class XPathKeyListener
    implements KeyListener {
        private XPathKeyListener() {
        }

        public final void keyPressed(KeyEvent ev) {
            switch (ev.getKeyCode()) {
                case 10: {
                    try {
                        if (MainGUI.this.clientQuery == null) {
                            MainGUI.this.clientQuery = new GuiQuery(MainGUI.this.xmlBlasterMain.getAuthenticate(), MainGUI.this.xmlBlasterMain.getXmlBlaster());
                        }
                        MainGUI.this.queryOutput.setText("");
                        MainGUI.this.getQueryHistory().changedHistory(MainGUI.this.inputTextField.getText());
                        MsgUnitRaw[] msgArr = MainGUI.this.clientQuery.get(MainGUI.this.inputTextField.getText());
                        int ii = 0;
                        while (ii < msgArr.length) {
                            MainGUI.this.queryOutput.append("### XmlKey:\n" + msgArr[ii].getKey());
                            MainGUI.this.queryOutput.append("\n");
                            MainGUI.this.queryOutput.append("### Content:\n" + new String(msgArr[ii].getContent()) + "\n");
                            MainGUI.this.queryOutput.append("======================================================\n");
                            ++ii;
                        }
                        if (msgArr.length != 0) break;
                        if (MainGUI.this.publishedMessages == 0L) {
                            MainGUI.this.queryOutput.setText("\n");
                            MainGUI.this.queryOutput.append("   Sorry, no data in xmlBlaster.\n");
                            MainGUI.this.queryOutput.append("   Use a demo client to publish some.\n");
                            MainGUI.this.queryOutput.append("\n");
                            break;
                        }
                        MainGUI.this.queryOutput.setText("****** Sorry, no match ******");
                    }
                    catch (XmlBlasterException e) {
                        MainGUI.this.log.error("MainGUI", "XmlBlasterException: " + e.getMessage());
                    }
                    break;
                }
                case 40: {
                    MainGUI.this.displayHistory(MainGUI.this.getQueryHistory().getNext());
                    break;
                }
                case 38: {
                    MainGUI.this.displayHistory(MainGUI.this.getQueryHistory().getPrev());
                }
            }
        }

        public final void keyReleased(KeyEvent ev) {
        }

        public final void keyTyped(KeyEvent ev) {
        }
    }

    private class PollingThread
    extends Thread {
        private final int POLLING_FREQUENCY = 1000;
        private final MainGUI mainGUI;

        public PollingThread(MainGUI mainGUI) {
            this.mainGUI = mainGUI;
        }

        public void run() {
            Thread.currentThread().setName("XmlBlaster GUIPollingThread");
            try {
                if (((MainGUI)MainGUI.this).log.TRACE) {
                    MainGUI.this.log.trace("MainGUI", "Starting poller");
                }
                while (true) {
                    Thread.sleep(1000L);
                    this.mainGUI.pollEvent(1000L);
                }
            }
            catch (Exception e) {
                MainGUI.this.log.trace("MainGUI", "PollingThread problem: " + e.toString());
                return;
            }
        }
    }

    class LogLevelListener
    implements ItemListener {
        LogLevelListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            boolean switchOn = e.getStateChange() == 1;
            String logLevel = (String)e.getItem();
            if (switchOn) {
                MainGUI.this.log.addLogLevel(logLevel);
            } else {
                MainGUI.this.log.removeLogLevel(logLevel);
            }
            StringBuffer stringBuffer = new StringBuffer().append("MainGUI: New log level is: ");
            MainGUI.this.log;
            System.out.println(stringBuffer.append(LogChannel.bitToLogLevel(MainGUI.this.log.getLogLevel())).toString());
        }
    }
}

