/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.jutils.time.TimeHelper;
import org.xmlBlaster.authentication.AuthenticateProtector;
import org.xmlBlaster.authentication.ClientEvent;
import org.xmlBlaster.authentication.I_ClientListener;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.authentication.SubjectInfo;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.I_Subject;
import org.xmlBlaster.authentication.plugins.PluginManager;
import org.xmlBlaster.authentication.plugins.simple.Manager;
import org.xmlBlaster.authentication.plugins.simple.SecurityQos;
import org.xmlBlaster.authentication.plugins.simple.Session;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.engine.XmlBlasterImpl;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.engine.qos.DisconnectQosServer;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;

public final class Authenticate
implements I_RunlevelListener {
    private final String ME;
    private final PluginManager plgnLdr;
    private long counter = 1L;
    private final org.xmlBlaster.engine.Global glob;
    private final LogChannel log;
    private final Map sessionInfoMap = new HashMap();
    private final Map loginNameSubjectInfoMap = new HashMap();
    private final Set clientListenerSet = new HashSet();
    private final I_XmlBlaster xmlBlasterImpl;
    private final AuthenticateProtector encapsulator;

    public Authenticate(org.xmlBlaster.engine.Global global) throws XmlBlasterException {
        this.glob = global;
        this.log = this.glob.getLog("auth");
        this.ME = "Authenticate" + this.glob.getLogPrefixDashed();
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering constructor");
        }
        this.encapsulator = new AuthenticateProtector(this.glob, this);
        this.glob.getRunlevelManager().addRunlevelListener(this);
        this.plgnLdr = new PluginManager(global);
        this.plgnLdr.init(this);
        this.xmlBlasterImpl = new XmlBlasterImpl(this);
    }

    public Map getSessionInfoMap() {
        return this.sessionInfoMap;
    }

    public org.xmlBlaster.engine.Global getGlobal() {
        return this.glob;
    }

    public I_XmlBlaster getXmlBlaster() {
        return this.xmlBlasterImpl;
    }

    public String login(String loginName, String passwd, String xmlQoS_literal, String secretSessionId) throws XmlBlasterException {
        Thread.dumpStack();
        this.log.error(this.ME, "login() not implemented");
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "login() not implemented and deprecated");
    }

    public SessionInfo unsecureCreateSession(ConnectQos connectQos) throws XmlBlasterException {
        SessionName sessionName = connectQos.getSessionName();
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering unsecureCreateSession(" + sessionName + ")");
        }
        String secretSessionId = this.createSessionId(sessionName.getLoginName());
        Manager manager = new Manager();
        manager.init(this.glob, null);
        Session session = new Session(manager, secretSessionId);
        SecurityQos securityQos = new SecurityQos(this.glob, sessionName.getLoginName(), "");
        session.init(securityQos);
        I_Subject subject = session.getSubject();
        SubjectInfo subjectInfo = null;
        if (sessionName.getLoginName().startsWith("__")) {
            SessionName subjectName = new SessionName((Global)this.glob, sessionName.getNodeId(), sessionName.getLoginName());
            subjectInfo = new SubjectInfo(this.getGlobal(), this, subjectName);
            Map map = this.loginNameSubjectInfoMap;
            synchronized (map) {
                this.loginNameSubjectInfoMap.put(subjectInfo.getLoginName(), subjectInfo);
            }
            subjectInfo.toAlive(subject, new CbQueueProperty(this.getGlobal(), "subject", null));
        } else {
            subjectInfo = this.getOrCreateSubjectInfoByName(sessionName, false, subject, new CbQueueProperty(this.getGlobal(), "subject", null));
        }
        SessionInfo sessionInfo = subjectInfo.getSession(sessionName);
        if (sessionInfo == null) {
            sessionInfo = new SessionInfo(subjectInfo, session, new ConnectQosServer((Global)this.glob, connectQos.getData()), this.getGlobal());
        }
        return sessionInfo;
    }

    public final ConnectReturnQosServer connect(ConnectQosServer xmlQos) throws XmlBlasterException {
        return this.connect(xmlQos, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ConnectReturnQosServer connect(ConnectQosServer connectQos, String secretSessionId) throws XmlBlasterException {
        SessionInfo sessionInfo;
        I_Session sessionCtx;
        block49: {
            SessionInfo info;
            try {
                if (this.log.CALL) {
                    this.log.call(this.ME, "Entering connect(sessionName=" + connectQos.getSessionName() + ")");
                }
                if (this.log.DUMP) {
                    this.log.dump(this.ME, "ConnectQos=" + connectQos.toXml());
                }
                if ((secretSessionId == null || secretSessionId.length() < 2) && (secretSessionId = connectQos.getSessionQos().getSecretSessionId()) != null && secretSessionId.length() >= 2) {
                    this.log.info(this.ME, "Using secretSessionId '" + secretSessionId + "' from ConnectQos");
                }
                if (secretSessionId != null && secretSessionId.length() >= 2 && (info = this.getSessionInfo(secretSessionId)) != null) {
                    info.updateConnectQos(connectQos);
                    ConnectReturnQosServer returnQos = new ConnectReturnQosServer((Global)this.glob, info.getConnectQos().getData());
                    returnQos.getSessionQos().setSecretSessionId(secretSessionId);
                    returnQos.getSessionQos().setSessionName(info.getSessionName());
                    returnQos.setReconnected(true);
                    this.log.info(this.ME, "Reconnected with given secretSessionId.");
                    return returnQos;
                }
            }
            catch (Throwable e) {
                this.log.error(this.ME, "Internal error when trying to reconnect to session " + connectQos.getSessionName() + " with secret session ID: " + e.toString());
                e.printStackTrace();
                throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_CONNECTIONFAILURE.toString(), e);
            }
            if (connectQos.hasPublicSessionId() && (info = this.getSessionInfo(connectQos.getSessionName())) != null && !info.isShutdown() && !info.getConnectQos().bypassCredentialCheck()) {
                if (connectQos.getSessionQos().reconnectSameClientOnly()) {
                    String text = "Only the creator of session " + connectQos.getSessionName().toString() + " may reconnect, access denied.";
                    this.log.warn(this.ME + ".connect()", text);
                    throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION_IDENTICALCLIENT, this.ME + ".connect()", text);
                }
                try {
                    info.getSecuritySession().verify(connectQos.getSecurityQos());
                    String oldSecretSessionId = info.getSecretSessionId();
                    if (secretSessionId == null || secretSessionId.length() < 2) {
                        connectQos.getSessionQos().setSecretSessionId(oldSecretSessionId);
                    } else {
                        this.changeSecretSessionId(oldSecretSessionId, secretSessionId);
                        connectQos.getSessionQos().setSecretSessionId(secretSessionId);
                    }
                    info.updateConnectQos(connectQos);
                    ConnectReturnQosServer returnQos = new ConnectReturnQosServer((Global)this.glob, info.getConnectQos().getData());
                    returnQos.getSessionQos().setSessionName(info.getSessionName());
                    returnQos.setReconnected(true);
                    this.log.info(this.ME, "Reconnected with given publicSessionId to '" + info.getSessionName() + "'.");
                    return returnQos;
                }
                catch (XmlBlasterException e) {
                    this.log.warn(this.ME, "Access is denied when trying to reconnect to session " + info.getSessionName() + ": " + e.getMessage());
                    throw e;
                }
                catch (Throwable e) {
                    this.log.error(this.ME, "Internal error when trying to reconnect to session " + info.getSessionName() + " with public session ID: " + e.toString());
                    e.printStackTrace();
                    throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_CONNECTIONFAILURE.toString(), e);
                }
            }
            if (secretSessionId == null || secretSessionId.length() < 2) {
                secretSessionId = this.createSessionId("null");
                connectQos.getSessionQos().setSecretSessionId(secretSessionId);
                if (this.log.TRACE) {
                    this.log.trace(this.ME + ".connect()", "Empty secretSessionId - generated secretSessionId=" + secretSessionId);
                }
            }
            sessionCtx = null;
            I_Manager securityMgr = null;
            sessionInfo = null;
            try {
                securityMgr = this.plgnLdr.getManager(connectQos.getClientPluginType(), connectQos.getClientPluginVersion());
                if (securityMgr == null) {
                    this.log.warn(this.ME, "Access is denied, there is no security manager configured for this connect QoS: " + connectQos.toXml());
                    throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, "There is no security manager configured with the given connect QoS");
                }
                sessionCtx = securityMgr.reserveSession(secretSessionId);
                if (connectQos.bypassCredentialCheck()) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME + ".connect()", "SECURITY SWITCH OFF: Granted access to xmlBlaster without password, bypassCredentialCheck=true");
                    }
                    break block49;
                }
                String securityInfo = sessionCtx.init(connectQos.getSecurityQos());
                if (securityInfo != null && securityInfo.length() > 1) {
                    this.log.warn(this.ME, "Ignoring security info: " + securityInfo);
                }
            }
            catch (XmlBlasterException e) {
                this.log.warn(this.ME, "Access is denied: " + e.getMessage());
                if (securityMgr == null) throw e;
                securityMgr.releaseSession(secretSessionId, null);
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.error(this.ME, "PANIC: Access is denied: " + e.getMessage());
                securityMgr.releaseSession(secretSessionId, null);
                throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_CONNECTIONFAILURE.toString(), e);
            }
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Checking if user is known ...");
        }
        SubjectInfo subjectInfo = null;
        try {
            boolean returnLocked = true;
            subjectInfo = this.getOrCreateSubjectInfoByName(connectQos.getSessionName(), returnLocked, sessionCtx.getSubject(), connectQos.getSubjectQueueProperty());
            try {
                Object oldSecretSessionId;
                if (subjectInfo.isAlive() && connectQos.getData().hasSubjectQueueProperty()) {
                    subjectInfo.setSubjectQueueProperty(connectQos.getSubjectQueueProperty());
                }
                if (connectQos.getSessionQos().clearSessions() && subjectInfo.getNumSessions() > 0) {
                    SessionInfo[] sessions = subjectInfo.getSessions();
                    int i = 0;
                    while (true) {
                        if (i >= sessions.length) break;
                        SessionInfo si = sessions[i];
                        this.log.warn(this.ME, "Destroying session '" + si.getSecretSessionId() + "' of user '" + subjectInfo.getSubjectName() + "' as requested by client");
                        this.disconnect(si.getSecretSessionId(), null);
                        ++i;
                    }
                    ConnectReturnQosServer connectReturnQosServer = this.connect(connectQos, secretSessionId);
                    Object var13_27 = null;
                    if (subjectInfo == null) return connectReturnQosServer;
                    subjectInfo.getLock().release();
                    return connectReturnQosServer;
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Creating sessionInfo for " + subjectInfo.getId());
                }
                if ((sessionInfo = this.getSessionInfo(connectQos.getSessionName())) != null && !sessionInfo.isShutdown() && sessionInfo.getConnectQos().bypassCredentialCheck()) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "connect: Reused session with had bypassCredentialCheck=true");
                    }
                    oldSecretSessionId = sessionInfo.getSecretSessionId();
                    sessionInfo.setSecuritySession(sessionCtx);
                    if (secretSessionId == null || secretSessionId.length() < 2) {
                        connectQos.getSessionQos().setSecretSessionId((String)oldSecretSessionId);
                    } else {
                        this.changeSecretSessionId((String)oldSecretSessionId, secretSessionId);
                        connectQos.getSessionQos().setSecretSessionId(secretSessionId);
                    }
                    sessionInfo.updateConnectQos(connectQos);
                } else {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "connect: sessionId='" + secretSessionId + "' connectQos='" + connectQos.toXml() + "'");
                    }
                    sessionInfo = new SessionInfo(subjectInfo, sessionCtx, connectQos, this.getGlobal());
                    oldSecretSessionId = this.sessionInfoMap;
                    synchronized (oldSecretSessionId) {
                        this.sessionInfoMap.put(secretSessionId, sessionInfo);
                    }
                }
                connectQos.getSessionQos().setSecretSessionId(secretSessionId);
                connectQos.getSessionQos().setSessionName(sessionInfo.getSessionName());
                subjectInfo.notifyAboutLogin(sessionInfo);
                this.fireClientEvent(sessionInfo, true);
            }
            catch (Throwable throwable) {
                Object var13_29 = null;
                if (subjectInfo == null) throw throwable;
                subjectInfo.getLock().release();
                throw throwable;
            }
            Object var13_28 = null;
            if (subjectInfo != null) {
                subjectInfo.getLock().release();
            }
            ConnectReturnQosServer returnQos = new ConnectReturnQosServer((Global)this.glob, connectQos.getData());
            returnQos.getSessionQos().setSecretSessionId(secretSessionId);
            returnQos.getSessionQos().setSessionName(sessionInfo.getSessionName());
            StringBuffer sb = new StringBuffer(256);
            if (connectQos.bypassCredentialCheck()) {
                sb.append("Created tempory session for client ");
            } else {
                sb.append("Successful login for client ");
            }
            sb.append(sessionInfo.getSessionName().getAbsoluteName());
            sb.append(", session");
            sb.append(connectQos.getSessionTimeout() > 0L ? " expires after" + TimeHelper.millisToNice(connectQos.getSessionTimeout()) : " lasts forever");
            sb.append(", ").append(subjectInfo.getNumSessions()).append(" of ");
            sb.append(connectQos.getMaxSessions()).append(" sessions are in use.");
            this.log.info(this.ME, sb.toString());
            if (this.log.DUMP) {
                this.log.dump(this.ME, this.toXml());
            }
            if (this.log.DUMP) {
                this.log.dump(this.ME, "Returned QoS:\n" + returnQos.toXml());
            }
            if (!this.log.CALL) return returnQos;
            this.log.call(this.ME, "Leaving connect()");
            return returnQos;
        }
        catch (XmlBlasterException e) {
            String id = sessionInfo != null ? sessionInfo.getId() : (subjectInfo != null ? subjectInfo.getId() : "");
            this.log.warn(this.ME, "Connection for " + id + " failed: " + e.getMessage());
            try {
                this.disconnect(secretSessionId, null);
                throw e;
            }
            catch (Throwable th) {
                this.log.warn(this.ME, "Ignoring problems during cleanup of exception '" + e.getMessage() + "':" + th.getMessage());
            }
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.error(this.ME, "Internal error: Connect failed: " + e.getMessage());
            try {
                this.disconnect(secretSessionId, null);
                throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_CONNECTIONFAILURE.toString(), e);
            }
            catch (Throwable th) {
                this.log.warn(this.ME, "Ignoring problems during cleanup of exception '" + e.getMessage() + "':" + th.getMessage());
            }
            throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_CONNECTIONFAILURE.toString(), e);
        }
    }

    public final void disconnect(String secretSessionId, String qos_literal) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering disconnect()");
            }
            if (this.log.DUMP) {
                this.log.dump(this.ME, this.toXml().toString());
            }
            if (secretSessionId == null) {
                throw new IllegalArgumentException("disconnect() failed, the given secretSessionId is null");
            }
            I_Manager securityMgr = this.plgnLdr.getManager(secretSessionId);
            I_Session sessionSecCtx = securityMgr.getSessionById(secretSessionId);
            if (sessionSecCtx == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME + " Authenticate.disconnect", "You are not connected, your secretSessionId is invalid.");
            }
            try {
                securityMgr.releaseSession(secretSessionId, sessionSecCtx.importMessage(qos_literal));
            }
            catch (Throwable e) {
                this.log.warn(this.ME, "Ignoring importMessage() problems, we continue to cleanup resources: " + e.getMessage());
            }
            SessionInfo sessionInfo = this.getSessionInfo(secretSessionId);
            if (sessionInfo.getCbQueueNumMsgs() > 0L) {
                long sleep = this.glob.getProperty().get("cb.disconnect.pending.sleep", 1000L);
                this.log.info(this.ME, "Sleeping cb.disconnect.pending.sleep=" + sleep + " millis in disconnect(" + sessionInfo.getId() + ") to deliver " + sessionInfo.getCbQueueNumMsgs() + " pending messages ...");
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
            }
            SubjectInfo subjectInfo = sessionInfo.getSubjectInfo();
            DisconnectQosServer disconnectQos = new DisconnectQosServer((Global)this.glob, qos_literal);
            boolean forceShutdownEvenIfEntriesExist = false;
            this.resetSessionInfo(sessionInfo, disconnectQos.deleteSubjectQueue(), forceShutdownEvenIfEntriesExist, true);
            if (disconnectQos.clearSessions() && subjectInfo.getNumSessions() > 0) {
                SessionInfo[] sessions = subjectInfo.getSessions();
                int i = 0;
                while (i < sessions.length) {
                    SessionInfo si = sessions[i];
                    this.log.warn(this.ME, "Destroying session '" + si.getSecretSessionId() + "' of user '" + subjectInfo.getSubjectName() + "' as requested by client");
                    this.disconnect(si.getSecretSessionId(), null);
                    ++i;
                }
            }
            if (this.log.DUMP) {
                this.log.dump(this.ME, this.toXml().toString());
            }
            if (this.log.CALL) {
                this.log.call(this.ME, "Leaving disconnect()");
            }
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "disconnect failed: " + e.getMessage());
            }
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.error(this.ME, "Internal error: Disconnect failed: " + e.getMessage());
            throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_DISCONNECT.toString(), e);
        }
    }

    public final SubjectInfo getOrCreateSubjectInfoByName(SessionName subjectName, boolean returnLocked, I_Subject subjectCtx, CbQueueProperty prop) throws XmlBlasterException {
        if (subjectName == null || subjectName.getLoginName().length() < 2) {
            this.log.warn(this.ME + ".InvalidClientName", "Given loginName is null");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".InvalidClientName", "Your given loginName is null or shorter 2 chars, loginName rejected");
        }
        SubjectInfo subjectInfo = null;
        boolean isNew = false;
        Map map = this.loginNameSubjectInfoMap;
        synchronized (map) {
            subjectInfo = (SubjectInfo)this.loginNameSubjectInfoMap.get(subjectName.getLoginName());
            if (subjectInfo == null) {
                SessionName name = new SessionName((Global)this.glob, this.glob.getNodeId(), subjectName.getLoginName());
                subjectInfo = new SubjectInfo(this.getGlobal(), this, name);
                this.loginNameSubjectInfoMap.put(subjectName.getLoginName(), subjectInfo);
                isNew = true;
            }
        }
        if (isNew) {
            if (returnLocked) {
                subjectInfo.getLock().lock();
            }
            try {
                subjectInfo.toAlive(subjectCtx, prop != null ? prop : new CbQueueProperty(this.getGlobal(), "subject", null));
            }
            catch (Throwable e) {
                Map map2 = this.loginNameSubjectInfoMap;
                synchronized (map2) {
                    this.loginNameSubjectInfoMap.remove(subjectInfo.getLoginName());
                }
                if (returnLocked) {
                    subjectInfo.getLock().release();
                }
                throw XmlBlasterException.convert(this.getGlobal(), ErrorCode.INTERNAL_UNKNOWN, this.ME, e.toString(), e);
            }
        }
        subjectInfo.waitUntilAlive(returnLocked);
        if (subjectCtx != null && subjectInfo.getSecurityCtx() == null) {
            subjectInfo.setSecurityCtx(subjectCtx);
        }
        return subjectInfo;
    }

    void removeLoginName(SubjectInfo subjectInfo) {
        Object entry = null;
        Map map = this.loginNameSubjectInfoMap;
        synchronized (map) {
            entry = this.loginNameSubjectInfoMap.remove(subjectInfo.getLoginName());
        }
        if (entry == null) {
            return;
        }
        try {
            this.glob.getRequestBroker().updateInternalUserList();
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Publishing internal user list failed: " + e.getMessage());
        }
    }

    public int getNumSubjects() {
        return this.loginNameSubjectInfoMap.size();
    }

    public final SubjectInfo getSubjectInfoByName(SessionName subjectName) {
        Map map = this.loginNameSubjectInfoMap;
        synchronized (map) {
            SubjectInfo subjectInfo = (SubjectInfo)this.loginNameSubjectInfoMap.get(subjectName.getLoginName());
            return subjectInfo;
        }
    }

    public final void changeSecretSessionId(String oldSessionId, String newSessionId) throws XmlBlasterException {
        Map map = this.sessionInfoMap;
        synchronized (map) {
            SessionInfo sessionInfo = (SessionInfo)this.sessionInfoMap.get(oldSessionId);
            if (sessionInfo == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".changeSecretSessionId()", "Couldn't lookup secretSessionId.");
            }
            if (this.sessionInfoMap.get(newSessionId) != null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".changeSecretSessionId()", "The new secretSessionId is already in use.");
            }
            this.sessionInfoMap.put(newSessionId, sessionInfo);
            this.sessionInfoMap.remove(oldSessionId);
            sessionInfo.getSecuritySession().changeSecretSessionId(newSessionId);
            sessionInfo.getConnectQos().getSessionQos().setSecretSessionId(newSessionId);
        }
    }

    private final SessionInfo getSessionInfo(String secretSessionId) {
        Map map = this.sessionInfoMap;
        synchronized (map) {
            SessionInfo sessionInfo = (SessionInfo)this.sessionInfoMap.get(secretSessionId);
            return sessionInfo;
        }
    }

    private final SessionInfo[] getSessionInfoArr() {
        Map map = this.sessionInfoMap;
        synchronized (map) {
            SessionInfo[] sessionInfoArray = this.sessionInfoMap.values().toArray(new SessionInfo[this.sessionInfoMap.size()]);
            return sessionInfoArray;
        }
    }

    public final SessionInfo getSessionInfo(SessionName sessionName) {
        SubjectInfo subjectInfo = this.getSubjectInfoByName(sessionName);
        if (subjectInfo == null) {
            return null;
        }
        return subjectInfo.getSessionInfo(sessionName);
    }

    public boolean sessionExists(String secretSessionId) {
        Map map = this.sessionInfoMap;
        synchronized (map) {
            boolean bl = this.sessionInfoMap.containsKey(secretSessionId);
            return bl;
        }
    }

    public final void logout(String secretSessionId) throws XmlBlasterException {
        this.log.error(this.ME, "logout not implemented");
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME + ".logout not implemented");
    }

    private void resetSessionInfo(SessionInfo sessionInfo, boolean clearQueue, boolean forceShutdownEvenIfEntriesExist, boolean isDisconnecting) throws XmlBlasterException {
        Object obj;
        this.firePreRemovedClientEvent(sessionInfo);
        String secretSessionId = sessionInfo.getSecretSessionId();
        Map map = this.sessionInfoMap;
        synchronized (map) {
            obj = this.sessionInfoMap.remove(secretSessionId);
        }
        if (obj == null) {
            this.log.warn(this.ME, "Sorry, '" + sessionInfo.getId() + "' is not known, no logout.");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, "Client '" + sessionInfo.getId() + "' is not known, disconnect is not possible.");
        }
        this.log.info(this.ME, "Disconnecting client " + sessionInfo.getSessionName() + ", instanceId=" + sessionInfo.getInstanceId() + ", secretSessionId=" + secretSessionId);
        I_Session oldSessionCtx = sessionInfo.getSecuritySession();
        oldSessionCtx.getManager().releaseSession(secretSessionId, null);
        this.fireClientEvent(sessionInfo, false);
        SubjectInfo subjectInfo = sessionInfo.getSubjectInfo();
        subjectInfo.notifyAboutLogout(sessionInfo.getId(), clearQueue, forceShutdownEvenIfEntriesExist);
        sessionInfo.shutdown();
        if (isDisconnecting) {
            sessionInfo.getSessionQueue().clear();
        }
        sessionInfo = null;
        this.log.info(this.ME, "loginNameSubjectInfoMap has " + this.getNumSubjects() + " entries and sessionInfoMap has " + this.sessionInfoMap.size() + " entries");
    }

    private String createSessionId(String loginName) throws XmlBlasterException {
        try {
            String ip = this.glob.getLocalIP();
            Random ran = new Random();
            StringBuffer buf = new StringBuffer(512);
            buf.append("sessionId:").append(ip).append("-").append(loginName).append("-");
            buf.append(System.currentTimeMillis()).append("-").append(ran.nextInt()).append("-").append(this.counter++);
            String secretSessionId = buf.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Created secretSessionId='" + secretSessionId + "'");
            }
            return secretSessionId;
        }
        catch (Exception e) {
            String text = "Can't generate a unique secretSessionId: " + e.getMessage();
            this.log.error(this.ME, text);
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, text);
        }
    }

    private final I_ClientListener[] getClientListenerArr() {
        Set set = this.clientListenerSet;
        synchronized (set) {
            I_ClientListener[] i_ClientListenerArray = this.clientListenerSet.toArray(new I_ClientListener[this.clientListenerSet.size()]);
            return i_ClientListenerArray;
        }
    }

    private void firePreRemovedClientEvent(SessionInfo sessionInfo) throws XmlBlasterException {
        I_ClientListener[] clientListenerArr = this.getClientListenerArr();
        if (clientListenerArr.length == 0) {
            return;
        }
        ClientEvent event = new ClientEvent(sessionInfo);
        int ii = 0;
        while (ii < clientListenerArr.length) {
            clientListenerArr[ii].sessionPreRemoved(event);
            ++ii;
        }
        Object var3_3 = null;
    }

    private void fireClientEvent(SessionInfo sessionInfo, boolean login) throws XmlBlasterException {
        I_ClientListener[] clientListenerArr = this.getClientListenerArr();
        if (clientListenerArr.length == 0) {
            return;
        }
        ClientEvent event = new ClientEvent(sessionInfo);
        int ii = 0;
        while (ii < clientListenerArr.length) {
            if (login) {
                clientListenerArr[ii].sessionAdded(event);
            } else {
                clientListenerArr[ii].sessionRemoved(event);
            }
            ++ii;
        }
        event = null;
    }

    public SessionInfo check(String secretSessionId) throws XmlBlasterException {
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        Object obj = null;
        Map map = this.sessionInfoMap;
        synchronized (map) {
            obj = this.sessionInfoMap.get(secretSessionId);
        }
        if (obj == null) {
            this.log.warn(this.ME + ".AccessDenied", "SessionId '" + secretSessionId + "' is invalid, no access to xmlBlaster.");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, "Your secretSessionId is invalid, no access to " + this.glob.getId() + ".");
        }
        SessionInfo sessionInfo = obj;
        sessionInfo.refreshSession();
        if (this.log.TIME) {
            this.log.time(this.ME, "Elapsed time in check()" + stop.nice());
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Succesfully granted access for " + sessionInfo.toString());
        }
        return sessionInfo;
    }

    public void addClientListener(I_ClientListener l) {
        if (l == null) {
            return;
        }
        Set set = this.clientListenerSet;
        synchronized (set) {
            this.clientListenerSet.add(l);
        }
    }

    public synchronized void removeClientListener(I_ClientListener l) {
        if (l == null) {
            return;
        }
        Set set = this.clientListenerSet;
        synchronized (set) {
            this.clientListenerSet.remove(l);
        }
    }

    public int getMaxSubjects() {
        return Integer.MAX_VALUE;
    }

    public String getSubjectList() {
        int numSubjects = this.getNumSubjects();
        if (numSubjects < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(numSubjects * 30);
        Map map = this.loginNameSubjectInfoMap;
        synchronized (map) {
            Iterator iterator = this.loginNameSubjectInfoMap.values().iterator();
            while (iterator.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                SubjectInfo subjectInfo = (SubjectInfo)iterator.next();
                sb.append(subjectInfo.getLoginName());
            }
        }
        return sb.toString();
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (to == from) {
            return;
        }
        if (to <= from || to == 5) {
            // empty if block
        }
        if (to < from && to == 0) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Killing " + this.sessionInfoMap.size() + " login sessions");
            }
            SessionInfo[] sessionInfoArr = this.getSessionInfoArr();
            int ii = 0;
            while (ii < sessionInfoArr.length) {
                block7: {
                    try {
                        boolean clearQueue = false;
                        boolean forceShutdownEvenIfEntriesExist = true;
                        this.resetSessionInfo(sessionInfoArr[ii], clearQueue, forceShutdownEvenIfEntriesExist, false);
                    }
                    catch (Throwable e) {
                        this.log.error(this.ME, "Problem on session shutdown, we ignore it: " + e.getMessage());
                        if (e instanceof XmlBlasterException) break block7;
                        e.printStackTrace();
                    }
                }
                ++ii;
            }
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        this.log.info(this.ME, "Client maps, sessionInfoMap.size()=" + this.sessionInfoMap.size() + " and loginNameSubjectInfoMap.size()=" + this.getNumSubjects());
        Map map = this.loginNameSubjectInfoMap;
        synchronized (map) {
            Iterator iterator = this.loginNameSubjectInfoMap.values().iterator();
            sb.append(offset).append("<Authenticate>");
            while (iterator.hasNext()) {
                SubjectInfo subjectInfo = (SubjectInfo)iterator.next();
                sb.append(subjectInfo.toXml(extraOffset + " "));
            }
            sb.append(offset).append("</Authenticate>\n");
        }
        return sb.toString();
    }
}

