/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.authentication.SubjectInfo;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.engine.AvailabilityChecker;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.I_AdminSubject;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.ConnectQosData;

public final class AuthenticateProtector
implements I_Authenticate {
    private final String ME;
    private final Global glob;
    private final LogChannel log;
    private final Authenticate authenticate;
    private final AvailabilityChecker availabilityChecker;

    public AuthenticateProtector(Global global, Authenticate authenticate) throws XmlBlasterException {
        this.glob = global;
        this.log = this.glob.getLog("auth");
        this.ME = "AuthenticateProtector" + this.glob.getLogPrefixDashed();
        this.authenticate = authenticate;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering constructor");
        }
        this.glob.setAuthenticate(this);
        this.availabilityChecker = new AvailabilityChecker(this.glob);
    }

    public Global getGlobal() {
        return this.glob;
    }

    public I_XmlBlaster getXmlBlaster() {
        return this.authenticate.getXmlBlaster();
    }

    public boolean sessionExists(String sessionId) {
        return this.authenticate.sessionExists(sessionId);
    }

    public final ConnectReturnQosServer connect(ConnectQosServer xmlQos) throws XmlBlasterException {
        return this.connect(xmlQos, null);
    }

    public final ConnectReturnQosServer connect(ConnectQosServer xmlQos, String secretSessionId) throws XmlBlasterException {
        MsgUnit msgUnit = new MsgUnit(null, null, xmlQos.getData());
        this.availabilityChecker.checkServerIsReady(xmlQos.getSessionName(), msgUnit, MethodName.CONNECT);
        try {
            ConnectReturnQosServer tmp = this.authenticate.connect(xmlQos.getClone(this.glob), secretSessionId);
            return new ConnectReturnQosServer((org.xmlBlaster.util.Global)this.glob, tmp.toXml());
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.CONNECT, e);
        }
    }

    public final String connect(String connectQos_literal) throws XmlBlasterException {
        return this.connect(connectQos_literal, null);
    }

    public final String connect(String connectQos_literal, String secretSessionId) throws XmlBlasterException {
        MsgUnit msgUnit = new MsgUnit(this.glob, null, null, connectQos_literal, MethodName.CONNECT);
        ConnectQosServer qos = new ConnectQosServer((org.xmlBlaster.util.Global)this.glob, (ConnectQosData)msgUnit.getQosData());
        if (qos.getData().getClientProperty("__persistenceId") != null) {
            qos.isFromPersistenceRecovery(true);
        }
        this.availabilityChecker.checkServerIsReady(qos.getSessionName(), msgUnit, MethodName.CONNECT);
        try {
            ConnectReturnQosServer ret = this.authenticate.connect(qos, secretSessionId);
            return ret.toXml();
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.CONNECT, e);
        }
    }

    public final void disconnect(String secretSessionId, String qos_literal) throws XmlBlasterException {
        MsgUnit msgUnit = new MsgUnit(this.glob, null, null, qos_literal, MethodName.DISCONNECT);
        this.availabilityChecker.checkServerIsReady(null, msgUnit, MethodName.DISCONNECT);
        try {
            this.authenticate.disconnect(secretSessionId, qos_literal);
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.DISCONNECT, e);
        }
    }

    public final String ping(String qos) {
        return "<qos><state id='" + this.availabilityChecker.getStatus(qos) + "'/></qos>";
    }

    public I_AdminSubject getSubjectInfoByName(SessionName sessionName) throws XmlBlasterException {
        SubjectInfo subjectInfo = this.authenticate.getSubjectInfoByName(sessionName);
        return subjectInfo == null ? null : subjectInfo.getSubjectInfoProtector();
    }

    public SessionInfo unsecureCreateSession(SessionName loginName) throws XmlBlasterException {
        ConnectQos connectQos = new ConnectQos(this.glob);
        connectQos.setSessionName(loginName);
        return this.authenticate.unsecureCreateSession(connectQos);
    }

    public String toXml() throws XmlBlasterException {
        return this.authenticate.toXml();
    }

    public final void shutdown() {
        this.availabilityChecker.shutdown();
    }
}

