/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.HandleRequest;
import org.xmlBlaster.util.Global;

public class HttpIORServer
extends Thread {
    private String ME = "HttpServer";
    private final Global glob;
    private final LogChannel log;
    private String ip_addr = null;
    private final int HTTP_PORT;
    private ServerSocket listen = null;
    private boolean running = true;
    private Hashtable knownRequests = new Hashtable();

    public HttpIORServer(Global glob, String ip_addr, int port) {
        super("XmlBlaster.HttpIORServer");
        this.glob = glob;
        this.log = glob.getLog("protocol");
        this.ip_addr = ip_addr;
        this.HTTP_PORT = port;
        this.ME = this.ME + this.glob.getLogPrefixDashed();
        if (this.HTTP_PORT <= 0) {
            if (this.log.CALL) {
                this.log.call(this.ME, "Internal HttpServer not started, as -bootstrapPort is " + this.HTTP_PORT);
            }
            return;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Creating new HttpServer on IP=" + this.ip_addr + " bootstrap port=" + this.HTTP_PORT);
        }
        this.setDaemon(true);
        this.start();
    }

    public void registerRequest(String urlPath, String data) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Registering urlPath: " + urlPath + "=" + data);
        }
        this.knownRequests.put(urlPath.trim(), data);
    }

    public void removeRequest(String urlPath) {
        this.knownRequests.remove(urlPath.trim());
    }

    public void run() {
        try {
            int backlog = this.glob.getProperty().get("http.backlog", 50);
            this.listen = new ServerSocket(this.HTTP_PORT, backlog, InetAddress.getByName(this.ip_addr));
            while (this.running) {
                Socket accept = this.listen.accept();
                this.log.trace(this.ME, "New incoming request on bootstrapPort=" + this.HTTP_PORT + " ...");
                if (!this.running) {
                    this.log.info(this.ME, "Closing http server bootstrapPort=" + this.HTTP_PORT + ".");
                    break;
                }
                HandleRequest hh = new HandleRequest(this.glob, this.log, accept, this.knownRequests);
            }
        }
        catch (UnknownHostException e) {
            this.log.error(this.ME, "HTTP server problem, IP address '" + this.ip_addr + "' is invalid: " + e.toString());
        }
        catch (BindException e) {
            this.log.error(this.ME, "HTTP server problem, bootstrapPort " + this.ip_addr + ":" + this.HTTP_PORT + " is not available: " + e.toString());
        }
        catch (SocketException e) {
            this.log.info(this.ME, "Socket " + this.ip_addr + ":" + this.HTTP_PORT + " closed successfully: " + e.toString());
        }
        catch (IOException e) {
            this.log.error(this.ME, "HTTP server problem on " + this.ip_addr + ":" + this.HTTP_PORT + ": " + e.toString());
        }
        if (this.listen != null) {
            try {
                this.listen.close();
            }
            catch (IOException e) {
                this.log.warn(this.ME, "this.listen.close()" + e.toString());
            }
            this.listen = null;
        }
    }

    public void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown");
        }
        this.running = false;
        boolean closeHack = true;
        if (this.listen != null && closeHack) {
            try {
                Socket socket = new Socket(this.listen.getInetAddress(), this.HTTP_PORT);
                socket.close();
            }
            catch (IOException e) {
                this.log.warn(this.ME, "shutdown problem: " + e.toString());
            }
        }
        try {
            if (this.listen != null) {
                this.listen.close();
                this.listen = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME, "shutdown problem: " + e.toString());
        }
    }
}

