/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfoProtector;
import org.xmlBlaster.authentication.SubjectInfo;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.engine.MsgErrorHandler;
import org.xmlBlaster.engine.SubscriptionInfo;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.DisconnectQosServer;
import org.xmlBlaster.engine.query.plugins.QueueQueryPlugin;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.ReentrantLock;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.error.I_MsgErrorHandler;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueSizeListener;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class SessionInfo
implements I_Timeout,
I_QueueSizeListener {
    public static long sentMessages = 0L;
    private String ME = "SessionInfo";
    private final SessionName sessionName;
    private SubjectInfo subjectInfo;
    private I_Session securityCtx;
    private static long instanceCounter = 0L;
    private long instanceId = 0L;
    private ConnectQosServer connectQos;
    private Timeout expiryTimer;
    private Timestamp timerKey;
    private final org.xmlBlaster.engine.Global glob;
    private final LogChannel log;
    private final MsgErrorHandler msgErrorHandler;
    private DispatchManager dispatchManager;
    private boolean isShutdown = false;
    private final Object EXPIRY_TIMER_MONITOR = new Object();
    private final SessionInfoProtector sessionInfoProtector;
    private I_Queue sessionQueue;
    private long lastNumEntries = -1L;
    private long uptime;
    private long persistenceId = -1L;
    private ReentrantLock lock = new ReentrantLock();
    private QueueQueryPlugin queueQueryPlugin;
    static /* synthetic */ Class class$org$xmlBlaster$authentication$SessionInfo;

    public SessionInfo(SubjectInfo subjectInfo, I_Session securityCtx, ConnectQosServer connectQos, org.xmlBlaster.engine.Global glob) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("auth");
        if (securityCtx == null) {
            String tmp = "SessionInfo(securityCtx==null); A correct security manager must be set.";
            this.log.error(this.ME + ".illegalArgument", tmp);
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, tmp);
        }
        this.sessionInfoProtector = new SessionInfoProtector(this);
        subjectInfo.checkNumberOfSessions(connectQos.getData());
        Class clazz = class$org$xmlBlaster$authentication$SessionInfo == null ? (class$org$xmlBlaster$authentication$SessionInfo = SessionInfo.class$("org.xmlBlaster.authentication.SessionInfo")) : class$org$xmlBlaster$authentication$SessionInfo;
        synchronized (clazz) {
            this.instanceId = instanceCounter--;
        }
        this.sessionName = connectQos.getSessionName().isPubSessionIdUser() ? connectQos.getSessionName() : new SessionName((Global)glob, subjectInfo.getSubjectName(), this.getInstanceId());
        this.ME = "SessionInfo-" + this.sessionName.getAbsoluteName();
        if (this.log.CALL) {
            this.log.call(this.ME, "Creating new SessionInfo " + this.instanceId + ": " + subjectInfo.toString());
        }
        this.uptime = System.currentTimeMillis();
        this.subjectInfo = subjectInfo;
        this.securityCtx = securityCtx;
        this.connectQos = connectQos;
        this.msgErrorHandler = new MsgErrorHandler(glob, this);
        String type = connectQos.getSessionCbQueueProperty().getType();
        String version = connectQos.getSessionCbQueueProperty().getVersion();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Creating callback queue type=" + type + " version=" + version);
        }
        this.sessionQueue = glob.getQueuePluginManager().getPlugin(type, version, new StorageId("callback", this.sessionName.getAbsoluteName()), connectQos.getSessionCbQueueProperty());
        this.sessionQueue.setNotifiedAboutAddOrRemove(true);
        this.sessionQueue.addQueueSizeListener(this);
        if (this.connectQos.getSessionCbQueueProperty().getCallbackAddresses().length > 0) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Creating dispatch manager as ConnectQos contains callback addresses");
            }
            this.dispatchManager = new DispatchManager(glob, this.msgErrorHandler, this.securityCtx, this.sessionQueue, null, this.connectQos.getSessionCbQueueProperty().getCallbackAddresses());
        } else {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Don't create dispatch manager as ConnectQos contains no callback addresses");
            }
            this.dispatchManager = null;
        }
        this.expiryTimer = glob.getSessionTimer();
        if (connectQos.getSessionTimeout() > 0L) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Setting expiry timer for " + this.getLoginName() + " to " + connectQos.getSessionTimeout() + " msec");
            }
            this.timerKey = this.expiryTimer.addTimeoutListener(this, connectQos.getSessionTimeout(), null);
        } else if (this.log.TRACE) {
            this.log.trace(this.ME, "Session lasts forever, requested expiry timer was 0");
        }
    }

    public final boolean isAlive() {
        return !this.isShutdown;
    }

    public final SessionInfoProtector getSessionInfoProtector() {
        return this.sessionInfoProtector;
    }

    public final long getInstanceId() {
        return this.instanceId;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public final boolean hasCallback() {
        return this.dispatchManager != null && !this.isShutdown;
    }

    public final I_MsgErrorHandler getMsgErrorHandler() {
        return this.msgErrorHandler;
    }

    public final long getPublicSessionId() {
        return this.sessionName.getPublicSessionId();
    }

    public void finalize() {
        if (this.timerKey != null) {
            this.expiryTimer.removeTimeoutListener(this.timerKey);
            this.timerKey = null;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collected " + this.getSecretSessionId());
        }
    }

    public boolean isShutdown() {
        boolean bl;
        this.lock.lock();
        try {
            bl = this.isShutdown;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.release();
            throw throwable;
        }
        this.lock.release();
        return bl;
    }

    public void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown() of session");
        }
        this.lock.lock();
        try {
            this.isShutdown = true;
            if (this.timerKey != null) {
                this.expiryTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
            if (this.sessionQueue != null) {
                this.sessionQueue.shutdown();
            }
            if (this.msgErrorHandler != null) {
                this.msgErrorHandler.shutdown();
            }
            if (this.dispatchManager != null) {
                this.dispatchManager.shutdown();
            }
            this.subjectInfo = null;
            this.expiryTimer = null;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.release();
            throw throwable;
        }
        this.lock.release();
    }

    public final DispatchManager getDispatchManager() {
        return this.dispatchManager;
    }

    public final void refreshSession() throws XmlBlasterException {
        if (this.connectQos.getSessionTimeout() > 0L) {
            Object object = this.EXPIRY_TIMER_MONITOR;
            synchronized (object) {
                this.timerKey = this.expiryTimer.addOrRefreshTimeoutListener(this, this.connectQos.getSessionTimeout(), null, this.timerKey);
            }
        }
    }

    public final void timeout(Object userData) {
        this.lock.lock();
        try {
            this.timerKey = null;
            this.log.warn(this.ME, "Session timeout for " + this.getLoginName() + " occurred, session '" + this.getSecretSessionId() + "' is expired, autologout");
            DisconnectQosServer qos = new DisconnectQosServer(this.glob);
            qos.deleteSubjectQueue(true);
            try {
                this.glob.getAuthenticate().disconnect(this.getSecretSessionId(), qos.toXml());
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, "Internal problem with disconnect: " + e.toString());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.release();
            throw throwable;
        }
        this.lock.release();
    }

    public final boolean hasAddress(AddressBase addr) {
        if (addr == null) {
            return false;
        }
        CallbackAddress[] arr = ((CbQueueProperty)this.getSessionQueue().getProperties()).getCallbackAddresses();
        int ii = 0;
        while (arr != null && ii < arr.length) {
            if (arr[ii].equals(addr)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public final void queueMessage(MsgQueueEntry entry) throws XmlBlasterException {
        if (!this.hasCallback() && this.log.TRACE) {
            this.log.trace(this.ME, "Queing PtP message without having configured a callback to the client, the client needs to reconnect with a valid callback address later");
        }
        this.sessionQueue.put(entry, false);
    }

    public final ConnectQosServer getConnectQos() {
        return this.connectQos;
    }

    public final void updateConnectQos(ConnectQosServer newConnectQos) throws XmlBlasterException {
        boolean wantsCallbacks = newConnectQos.getSessionCbQueueProperty().getCallbackAddresses().length > 0;
        CbQueueProperty cbQueueProperty = newConnectQos.getSessionCbQueueProperty();
        this.sessionQueue.setProperties(cbQueueProperty);
        if (wantsCallbacks && this.hasCallback()) {
            this.dispatchManager.updateProperty(cbQueueProperty.getCallbackAddresses());
            this.log.info(this.ME, "Successfully reconfigured callback address with new settings, other reconfigurations are not yet implemented");
            this.dispatchManager.notifyAboutNewEntry();
        } else if (wantsCallbacks && !this.hasCallback()) {
            this.log.info(this.ME, "Successfully reconfigured and created dispatch manager with given callback address");
            this.dispatchManager = new DispatchManager(this.glob, this.msgErrorHandler, this.securityCtx, this.sessionQueue, null, newConnectQos.getSessionCbQueueProperty().getCallbackAddresses());
        } else if (!wantsCallbacks && this.hasCallback()) {
            this.dispatchManager.shutdown();
            this.dispatchManager = null;
            this.log.info(this.ME, "Successfully shutdown dispatch manager as no callback address is configured");
        } else if (!wantsCallbacks && !this.hasCallback() && this.log.TRACE) {
            this.log.trace(this.ME, "No callback exists and no callback is desired");
        }
        newConnectQos.isFromPersistenceRecovery(this.connectQos.isFromPersistenceRecovery());
        newConnectQos.setPersistenceUniqueId(this.connectQos.getPersistenceUniqueId());
        this.connectQos = newConnectQos;
    }

    public final String getLoginName() {
        return this.subjectInfo == null ? "--" : this.subjectInfo.getLoginName();
    }

    public final SubjectInfo getSubjectInfo() {
        return this.subjectInfo;
    }

    public String getSecretSessionId() {
        return this.securityCtx.getSecretSessionId();
    }

    public I_Session getSecuritySession() {
        return this.securityCtx;
    }

    public void setSecuritySession(I_Session ctx) {
        this.securityCtx = ctx;
    }

    public I_Queue getSessionQueue() {
        return this.sessionQueue;
    }

    public final String getId() {
        return this.sessionName.getAbsoluteName();
    }

    public final SessionName getSessionName() {
        return this.sessionName;
    }

    public boolean isSameSession(SessionInfo sessionInfo) {
        return this.getId().equals(sessionInfo.getId());
    }

    public void changed(I_Queue queue, long numEntries, long numBytes) {
        boolean hasSubjectEntries;
        boolean bl = hasSubjectEntries = this.getSubjectInfo().getSubjectQueue().getNumOfEntries() > 0L;
        if (this.lastNumEntries != numEntries) {
            long max = this.getSessionQueue().getMaxNumOfEntries();
            if (hasSubjectEntries && numEntries < max && this.lastNumEntries > numEntries) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "SessionQueue has emptied from " + this.lastNumEntries + " to " + numEntries + " entries, calling SubjectInfoShuffler.shuffle()");
                }
                this.glob.getSubjectInfoShuffler().shuffle(this.subjectInfo);
            }
            this.lastNumEntries = numEntries;
        }
    }

    public final String toString() {
        return this.getId();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<SessionInfo id='").append(this.getId());
        long timeToLife = this.expiryTimer.spanToTimeout(this.timerKey);
        sb.append("' timeout='").append(timeToLife).append("'>");
        if (this.hasCallback()) {
            sb.append(this.dispatchManager.toXml(extraOffset + " "));
        } else {
            sb.append(offset).append(" ").append("<DispatchManager id='NULL'/>");
        }
        if (this.sessionQueue != null) {
            sb.append(this.sessionQueue.toXml(extraOffset + " "));
        }
        sb.append(offset).append("</SessionInfo>");
        return sb.toString();
    }

    public final long getUptime() {
        return (System.currentTimeMillis() - this.uptime) / 1000L;
    }

    public final long getNumUpdates() {
        if (this.dispatchManager == null) {
            return 0L;
        }
        return this.dispatchManager.getDispatchStatistic().getNumUpdate();
    }

    public final long getCbQueueNumMsgs() {
        if (this.sessionQueue == null) {
            return 0L;
        }
        return this.sessionQueue.getNumOfEntries();
    }

    public final long getCbQueueMaxMsgs() {
        if (this.sessionQueue == null) {
            return 0L;
        }
        return this.sessionQueue.getMaxNumOfEntries();
    }

    public final String getSubscriptionList() throws XmlBlasterException {
        SubscriptionInfo[] subs = this.glob.getRequestBroker().getClientSubscriptions().getSubscriptions(this);
        if (subs.length < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(subs.length * 30);
        int i = 0;
        while (i < subs.length) {
            if (!subs[i].isCreatedByQuerySubscription()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(subs[i].getSubscriptionId());
            }
            ++i;
        }
        return sb.toString();
    }

    public final String getKillSession() throws XmlBlasterException {
        this.glob.getAuthenticate().disconnect(this.securityCtx.getSecretSessionId(), "<qos/>");
        return this.getId() + " killed";
    }

    public final long getPersistenceUniqueId() {
        return this.connectQos.getPersistenceUniqueId();
    }

    public final void setPersistenceUniqueId(long persistenceId) {
        this.connectQos.setPersistenceUniqueId(persistenceId);
    }

    public void setDispatcherActive(boolean dispatcherActive) {
        this.dispatchManager.setDispatcherActive(dispatcherActive);
    }

    public boolean getDispatcherActive() {
        return this.dispatchManager.isDispatcherActive();
    }

    public MsgUnit[] getCbQueueEntries(QueryKeyData keyData, QueryQosData qosData) throws XmlBlasterException {
        if (this.queueQueryPlugin == null) {
            SessionInfo sessionInfo = this;
            synchronized (sessionInfo) {
                if (this.queueQueryPlugin == null) {
                    this.queueQueryPlugin = new QueueQueryPlugin(this.glob);
                }
            }
        }
        return this.queueQueryPlugin.query(this.sessionQueue, keyData, qosData);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

