/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.authentication.SubjectInfoProtector;
import org.xmlBlaster.authentication.plugins.I_Subject;
import org.xmlBlaster.engine.MsgErrorHandler;
import org.xmlBlaster.engine.admin.I_AdminSession;
import org.xmlBlaster.engine.cluster.ClusterNode;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.engine.queuemsg.ReferenceEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.ReentrantLock;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.DispatchStatistic;
import org.xmlBlaster.util.error.I_MsgErrorHandler;
import org.xmlBlaster.util.error.MsgErrorInfo;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class SubjectInfo {
    private String ME = "SubjectInfo";
    private final org.xmlBlaster.engine.Global glob;
    private final LogChannel log;
    private final Authenticate authenticate;
    private SessionName subjectName;
    private I_Subject securityCtx = null;
    private Map sessionMap = new HashMap();
    private SessionInfo[] sessionArrCache;
    public CallbackAddress[] callbackAddressCache = null;
    private MsgErrorHandler msgErrorHandler;
    private final DispatchStatistic dispatchStatistic;
    private final SubjectInfoProtector subjectInfoProtector;
    private NodeId nodeId = null;
    private boolean determineNodeId = true;
    private long uptime;
    private int maxSessions;
    public final int UNDEF = -1;
    public final int ALIVE = 0;
    public final int DEAD = 1;
    private int state = -1;
    private ReentrantLock lock = new ReentrantLock();
    private I_Queue subjectQueue;
    private static long instanceCounter = 0L;
    private long instanceId = 0L;
    static /* synthetic */ Class class$org$xmlBlaster$authentication$SubjectInfo;

    public SubjectInfo(org.xmlBlaster.engine.Global glob, Authenticate authenticate, SessionName subjectName) throws XmlBlasterException {
        Class clazz = class$org$xmlBlaster$authentication$SubjectInfo == null ? (class$org$xmlBlaster$authentication$SubjectInfo = SubjectInfo.class$("org.xmlBlaster.authentication.SubjectInfo")) : class$org$xmlBlaster$authentication$SubjectInfo;
        synchronized (clazz) {
            this.instanceId = instanceCounter++;
        }
        this.glob = glob;
        this.log = this.glob.getLog("auth");
        this.authenticate = authenticate;
        this.subjectInfoProtector = new SubjectInfoProtector(this);
        String prae = glob.getLogPrefix();
        this.subjectName = subjectName;
        if (this.subjectName.isSession()) {
            this.log.error(this.ME, "Didn't expect a session name for a subject: " + this.subjectName.toXml());
            Thread.dumpStack();
        }
        this.ME = "SubjectInfo-" + instanceCounter + "-" + this.subjectName.getAbsoluteName();
        this.dispatchStatistic = new DispatchStatistic();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Created new SubjectInfo");
        }
    }

    public void waitUntilAlive(boolean returnLocked) throws XmlBlasterException {
        if (this.state == 0) {
            if (returnLocked) {
                this.lock.lock();
            }
            return;
        }
        if (this.state == 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".waitUntilAlive()", "Did not expect state DEAD, please try again.");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "waitUntilAlive() is going to wait max. one minute");
        }
        long msecs = 60000L;
        while (true) {
            SubjectInfo subjectInfo = this;
            synchronized (subjectInfo) {
                try {
                    this.wait(msecs);
                    break;
                }
                catch (InterruptedException e) {
                    this.log.error(this.ME, "waitUntilAlive() Ignoring unexpected exception: " + e.toString());
                }
            }
        }
        if (returnLocked) {
            this.lock.lock();
        }
        if (this.state != 0) {
            if (returnLocked) {
                this.lock.release();
            }
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".waitUntilAlive()", "ALIVE not reached, state=" + this.state);
        }
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    SubjectInfoProtector getSubjectInfoProtector() {
        return this.subjectInfoProtector;
    }

    public void toAlive(I_Subject securityCtx, CbQueueProperty prop) throws XmlBlasterException {
        if (this.isAlive()) {
            return;
        }
        this.lock.lock();
        try {
            if (securityCtx != null) {
                this.securityCtx = securityCtx;
            }
            this.uptime = System.currentTimeMillis();
            this.maxSessions = this.glob.getProperty().get("session.maxSessions", 10);
            if (this.glob.getId() != null) {
                this.maxSessions = this.glob.getProperty().get("session.maxSessions[" + this.glob.getId() + "]", this.maxSessions);
            }
            this.subjectQueue = this.createSubjectQueue(prop);
            this.state = 0;
            SubjectInfo subjectInfo = this;
            synchronized (subjectInfo) {
                this.notifyAll();
            }
            try {
                this.glob.getRequestBroker().updateInternalUserList();
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, "Publishing internal user list failed: " + e.getMessage());
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Transition from UNDEF to ALIVE done");
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.release();
            throw throwable;
        }
        this.lock.release();
    }

    private I_Queue createSubjectQueue(CbQueueProperty prop) throws XmlBlasterException {
        if (prop == null) {
            prop = new CbQueueProperty(this.glob, "subject", this.glob.getId());
        }
        String type = prop.getType();
        String version = prop.getVersion();
        I_Queue queue = this.glob.getQueuePluginManager().getPlugin(type, version, new StorageId("subject", this.subjectName.getAbsoluteName()), prop);
        queue.setNotifiedAboutAddOrRemove(true);
        return queue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown(boolean clearQueue, boolean forceIfEntries) {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown(clearQueue=" + clearQueue + ", forceIfEntries=" + forceIfEntries + ") of subject " + this.getLoginName());
        }
        this.lock.lock();
        try {
            if (!this.isAlive()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Ignoring shutdown request as we are in state " + this.getStateStr());
                }
                Object var7_3 = null;
                this.lock.release();
                return;
            }
            if (this.isLoggedIn()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Ignoring shutdown request as there are still login sessions");
                }
                Object var7_4 = null;
                this.lock.release();
                return;
            }
            if (!forceIfEntries && !clearQueue && this.getSubjectQueue().getNumOfEntries() > 0L) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Ignoring shutdown request as there are still messages in the subject queue");
                }
                Object var7_5 = null;
                this.lock.release();
                return;
            }
            if (this.getSubjectQueue().getNumOfEntries() < 1L) {
                this.log.info(this.ME, "Destroying SubjectInfo " + this.getSubjectName() + ". Nobody is logged in and no queue entries available");
            } else if (clearQueue) {
                this.log.warn(this.ME, "Destroying SubjectInfo " + this.getSubjectName() + ". Lost " + this.getSubjectQueue().getNumOfEntries() + " messages in the subject queue as clearQueue is set to true");
            } else {
                this.log.warn(this.ME, "Destroying SubjectInfo " + this.getSubjectName() + ". The subject queue still contains " + this.getSubjectQueue().getNumOfEntries() + " messages, " + this.getSubjectQueue().getNumOfPersistentEntries() + " persistent messages remain on disk, the transients are lost");
            }
            this.authenticate.removeLoginName(this);
            this.state = 1;
            if (clearQueue) {
                this.subjectQueue.clear();
            }
            if (this.getSessions().length > 0) {
                this.log.warn(this.ME, "shutdown() of subject " + this.getLoginName() + " has still " + this.getSessions().length + " sessions - memory leak?");
            }
            Map map = this.sessionMap;
            // MONITORENTER : map
            this.sessionArrCache = null;
            this.sessionMap.clear();
            this.callbackAddressCache = null;
            // MONITOREXIT : map
            if (this.msgErrorHandler != null) {
                this.msgErrorHandler.shutdown();
            }
            SubjectInfo subjectInfo = this;
            // MONITORENTER : subjectInfo
            this.notifyAll();
            // MONITOREXIT : subjectInfo
            Object var7_6 = null;
            this.lock.release();
            return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.release();
            throw throwable;
        }
    }

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collected " + this.getLoginName());
        }
        boolean force = true;
        this.subjectQueue.shutdown();
    }

    public SessionInfo getSessionInfo(SessionName sessionName) {
        SessionInfo[] sessions = this.getSessions();
        int ii = 0;
        while (ii < sessions.length) {
            if (sessions[ii].getSessionName().equalsRelative(sessionName)) {
                return sessions[ii];
            }
            ++ii;
        }
        return null;
    }

    public final NodeId getNodeId() throws XmlBlasterException {
        if (this.determineNodeId) {
            this.determineNodeId = false;
            if (this.subjectName.getLoginName().startsWith("__RequestBroker_internal")) {
                return null;
            }
            if (this.glob.useCluster()) {
                ClusterNode clusterNode = this.glob.getClusterManager().getClusterNode(this.subjectName.getLoginName());
                if (clusterNode != null) {
                    this.nodeId = clusterNode.getNodeId();
                } else {
                    SessionInfo ses = this.getFirstSession();
                    if (ses != null && ses.getConnectQos().isClusterNode()) {
                        this.nodeId = new NodeId(this.subjectName.getLoginName());
                    }
                }
            }
        }
        return this.nodeId;
    }

    public boolean isCluster() throws XmlBlasterException {
        return this.getNodeId() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setSubjectQueueProperty(CbQueueProperty prop) throws XmlBlasterException {
        CbQueueProperty origProp;
        block14: {
            block15: {
                block13: {
                    origProp = (CbQueueProperty)this.subjectQueue.getProperties();
                    if (origProp == null) {
                        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".setSubjectQueueProperty()", "Existing subject queue properties are null");
                    }
                    if (prop == null) {
                        prop = new CbQueueProperty(this.glob, "subject", this.glob.getId());
                    }
                    this.lock.lock();
                    try {
                        I_Queue newQueue;
                        if (prop.getTypeVersion().equals(origProp.getTypeVersion())) {
                            this.subjectQueue.setProperties(prop);
                            Object var10_3 = null;
                            break block13;
                        }
                        if (this.subjectQueue.isTransient() || !(newQueue = this.createSubjectQueue(prop)).isTransient()) break block14;
                        this.log.info(this.ME, "Reconfiguring subject queue: Copying " + this.subjectQueue.getNumOfEntries() + " entries from old " + origProp.getType() + " queue to " + prop.getTypeVersion() + " queue");
                        ArrayList list = null;
                        int lastSize = -99;
                        while (this.subjectQueue.getNumOfEntries() > 0L) {
                            try {
                                list = this.subjectQueue.peek(-1, -1L);
                                if (this.subjectQueue.getNumOfEntries() == (long)lastSize) {
                                    this.log.error(this.ME, "PANIC: " + this.subjectQueue.getNumOfEntries() + " entries from old queue " + this.subjectQueue.getStorageId() + " can't be copied, giving up!");
                                    break;
                                }
                                lastSize = (int)this.subjectQueue.getNumOfEntries();
                            }
                            catch (XmlBlasterException e) {
                                this.log.error(this.ME, "PANIC: Can't copy from subject queue '" + this.subjectQueue.getStorageId() + "' with " + this.subjectQueue.getNumOfEntries() + " entries: " + e.getMessage());
                                e.printStackTrace();
                                continue;
                            }
                            I_QueueEntry[] queueEntries = list.toArray(new MsgQueueEntry[list.size()]);
                            try {
                                newQueue.put(queueEntries, false);
                            }
                            catch (XmlBlasterException e) {
                                this.log.warn(this.ME, "flushHoldbackQueue() failed: " + e.getMessage());
                                this.getMsgErrorHandler().handleError(new MsgErrorInfo((Global)this.glob, (MsgQueueEntry[])queueEntries, null, (Throwable)e));
                            }
                            try {
                                long num = this.subjectQueue.remove(list.size(), -1L);
                                if (num == (long)list.size()) continue;
                                this.log.error(this.ME, "PANIC: Expected to remove from subject queue '" + this.subjectQueue.getStorageId() + "' with " + this.subjectQueue.getNumOfEntries() + " entries " + list.size() + " entries, but only " + num + " where removed");
                            }
                            catch (XmlBlasterException e) {
                                this.log.error(this.ME, "PANIC: Expected to remove from subject queue '" + this.subjectQueue.getStorageId() + "' with " + this.subjectQueue.getNumOfEntries() + " entries " + list.size() + " entries: " + e.getMessage());
                            }
                        }
                        this.subjectQueue.clear();
                        this.subjectQueue.shutdown();
                        this.subjectQueue = newQueue;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var10_6 = null;
                        this.lock.release();
                        throw throwable;
                    }
                }
                this.lock.release();
                return;
            }
            Object var10_4 = null;
            this.lock.release();
            return;
        }
        Object var10_5 = null;
        this.lock.release();
        this.log.error(this.ME + ".setSubjectQueueProperty()", "Can't reconfigure subject queue type '" + origProp.getTypeVersion() + "' to '" + prop.getTypeVersion() + "'");
    }

    public I_Queue getSubjectQueue() {
        return this.subjectQueue;
    }

    public I_Subject getSecurityCtx() {
        return this.securityCtx;
    }

    public void setSecurityCtx(I_Subject securityCtx) {
        this.securityCtx = securityCtx;
    }

    public boolean isAuthorized(MethodName actionKey, String key) {
        if (this.securityCtx == null) {
            this.log.warn(this.ME, "No authorization for '" + actionKey + "' and msg=" + key);
            return false;
        }
        return this.securityCtx.isAuthorized(actionKey, key);
    }

    public final void queueMessage(MsgQueueEntry entry) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Queuing message for destination " + entry.getReceiver());
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, "Putting PtP message to queue: " + entry.toXml(""));
        }
        this.subjectQueue.put(entry, false);
        this.glob.getSubjectInfoShuffler().shuffle(this);
    }

    public final long forwardToSessionQueue() {
        if (this.getSessions().length < 1 || this.subjectQueue.getNumOfEntries() < 1L) {
            return 0L;
        }
        long numMsgs = 0L;
        MsgQueueUpdateEntry entry = null;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Trying to forward " + this.subjectQueue.getNumOfEntries() + " messages in subject queue to session queue ...");
        }
        while (true) {
            try {
                try {
                    entry = (MsgQueueUpdateEntry)this.subjectQueue.peek();
                }
                catch (Throwable ex) {
                    this.log.error(this.ME, "forwardToDestinationQueue: can't get entry from subject queue when trying to forward it to session queue " + ex.getMessage());
                    break;
                }
                if (entry != null) {
                    int countForwarded = this.forwardToSessionQueue(entry);
                    if (countForwarded > 0) {
                        this.subjectQueue.removeRandom(entry);
                        ++numMsgs;
                        continue;
                    }
                    if (countForwarded != -1) continue;
                }
                break;
            }
            catch (Throwable e) {
                MsgQueueEntry[] msgQueueEntries = new MsgQueueEntry[]{entry};
                MsgErrorInfo msgErrorInfo = new MsgErrorInfo((Global)this.glob, msgQueueEntries, null, e);
                this.getMsgErrorHandler().handleError(msgErrorInfo);
                try {
                    this.subjectQueue.removeRandom(entry);
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "forwardToDestinationQueue: can't empty queue when removing '" + entry.getLogId() + "' " + ex.getMessage());
                    break;
                }
            }
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Forwarded " + numMsgs + " messages from subject queue to session queue");
        }
        if (!this.isLoggedIn()) {
            this.shutdown(false, false);
        }
        return numMsgs;
    }

    private final int forwardToSessionQueue(MsgQueueEntry entry) throws XmlBlasterException {
        if (this.getSessions().length < 1) {
            return -1;
        }
        int countForwarded = 0;
        SessionName destination = entry.getReceiver();
        if (destination.isSession()) {
            String tmp = "Can't forward msg " + entry.getLogId() + " from " + this.subjectQueue.getStorageId() + " size=" + this.subjectQueue.getNumOfEntries() + " to unknown session '" + entry.getReceiver().getAbsoluteName() + "'";
            this.log.warn(this.ME, tmp);
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, tmp);
        }
        SessionInfo[] sessions = this.getSessions();
        int i = 0;
        while (i < sessions.length) {
            SessionInfo sessionInfo = sessions[i];
            if (sessionInfo.getConnectQos().isPtpAllowed() && sessionInfo.hasCallback()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Forwarding msg " + entry.getLogId() + " from " + this.subjectQueue.getStorageId() + " size=" + this.subjectQueue.getNumOfEntries() + " to session queue " + sessionInfo.getSessionQueue().getStorageId() + " size=" + sessionInfo.getSessionQueue().getNumOfEntries() + " ...");
                }
                try {
                    I_Map cache = ((ReferenceEntry)entry).getMsgUnitCache();
                    if (cache == null) {
                        if (!this.log.TRACE) break;
                        this.log.trace(this.ME, "forwardToSessionQueue: MsgUnitStore is null for '" + entry.getLogId() + "'");
                        break;
                    }
                    MsgQueueUpdateEntry entryCb = null;
                    I_Map i_Map = cache;
                    synchronized (i_Map) {
                        entryCb = new MsgQueueUpdateEntry((MsgQueueUpdateEntry)entry, sessionInfo.getSessionQueue().getStorageId());
                    }
                    sessionInfo.queueMessage(entryCb);
                    ++countForwarded;
                }
                catch (XmlBlasterException e) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Can't forward message from subject queue '" + this.subjectQueue.getStorageId() + "' to session '" + sessionInfo.getId() + "', we keep it in the subject queue: " + e.getMessage());
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.log.warn(this.ME, "Can't forward message from subject queue '" + this.subjectQueue.getStorageId() + "' to session '" + sessionInfo.getId() + "', we keep it in the subject queue: " + e.toString());
                }
            }
            ++i;
        }
        if (countForwarded > 0) {
            return countForwarded;
        }
        return -1;
    }

    public final I_MsgErrorHandler getMsgErrorHandler() {
        if (this.msgErrorHandler == null) {
            this.lock.lock();
            try {
                if (this.msgErrorHandler == null) {
                    this.log.error(this.ME, "INTERNAL: Support for MsgErrorHandler is not implemented");
                    this.msgErrorHandler = new MsgErrorHandler(this.glob, null);
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.lock.release();
                throw throwable;
            }
            this.lock.release();
            {
            }
        }
        return this.msgErrorHandler;
    }

    public final boolean isLoggedIn() {
        Map map = this.sessionMap;
        synchronized (map) {
            boolean bl = this.sessionMap.size() > 0;
            return bl;
        }
    }

    public final SessionInfo[] getSessions() {
        if (this.sessionArrCache == null) {
            Map map = this.sessionMap;
            synchronized (map) {
                if (this.sessionArrCache == null) {
                    this.sessionArrCache = this.sessionMap.values().toArray(new SessionInfo[this.sessionMap.size()]);
                }
            }
        }
        return this.sessionArrCache;
    }

    public final SessionInfo getSessionByAbsoluteName(String absoluteName) {
        Map map = this.sessionMap;
        synchronized (map) {
            SessionInfo sessionInfo = (SessionInfo)this.sessionMap.get(absoluteName);
            return sessionInfo;
        }
    }

    public final SessionInfo getSession(SessionName sessionName) {
        Map map = this.sessionMap;
        synchronized (map) {
            SessionInfo sessionInfo = (SessionInfo)this.sessionMap.get(sessionName.getAbsoluteName());
            return sessionInfo;
        }
    }

    public final SessionInfo getFirstSession() {
        SessionInfo[] sessions = this.getSessions();
        return sessions.length > 0 ? sessions[0] : null;
    }

    public final CallbackAddress[] getCallbackAddresses() {
        if (this.callbackAddressCache == null) {
            SessionInfo[] sessions = this.getSessions();
            HashSet<CallbackAddress> set = new HashSet<CallbackAddress>();
            int i = 0;
            while (i < sessions.length) {
                SessionInfo ses = sessions[i];
                if (ses.hasCallback()) {
                    CallbackAddress[] arr = ((CbQueueProperty)ses.getSessionQueue().getProperties()).getCallbackAddresses();
                    int ii = 0;
                    while (arr != null && ii < arr.length) {
                        if (arr[ii].useForSubjectQueue()) {
                            set.add(arr[ii]);
                        }
                        ++ii;
                    }
                }
                ++i;
            }
            this.callbackAddressCache = set.toArray(new CallbackAddress[set.size()]);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Accessing " + this.callbackAddressCache.length + " callback addresses from " + this.getSessions().length + " sessions for '" + this.getLoginName() + "' queue");
        }
        return this.callbackAddressCache;
    }

    public final SessionInfo findSessionInfo(AddressBase addr) {
        SessionInfo[] sessions = this.getSessions();
        int i = 0;
        while (i < sessions.length) {
            SessionInfo ses = sessions[i];
            if (ses.hasAddress(addr)) {
                return ses;
            }
            ++i;
        }
        return null;
    }

    public final void checkNumberOfSessions(ConnectQosData qos) throws XmlBlasterException {
        if (10 != qos.getSessionQos().getMaxSessions()) {
            this.maxSessions = qos.getSessionQos().getMaxSessions();
        }
        if (this.getSessions().length >= this.maxSessions) {
            this.log.warn(this.ME, "Max sessions = " + this.maxSessions + " for user " + this.getLoginName() + " exhausted, login denied.");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION_MAXSESSION, this.ME, "Max sessions = " + this.maxSessions + " exhausted, login denied.");
        }
    }

    public final void notifyAboutLogin(SessionInfo sessionInfo) throws XmlBlasterException {
        if (!this.isAlive()) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "SubjectInfo is shutdown, try to login again");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "notifyAboutLogin(" + sessionInfo.getSecretSessionId() + ")");
        }
        Map map = this.sessionMap;
        synchronized (map) {
            this.sessionMap.put(sessionInfo.getId(), sessionInfo);
            this.sessionArrCache = null;
            this.callbackAddressCache = null;
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, this.subjectQueue.toXml(""));
        }
        if (this.subjectQueue.getNumOfEntries() > 0L) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Flushing " + this.subjectQueue.getNumOfEntries() + " messages");
            }
            this.glob.getSubjectInfoShuffler().shuffle(this);
        }
    }

    public final void notifyAboutLogout(String absoluteSessionName, boolean clearQueue, boolean forceShutdownEvenIfEntriesExist) throws XmlBlasterException {
        if (!this.isAlive()) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "SubjectInfo is shutdown, no logout");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering notifyAboutLogout(" + absoluteSessionName + ", " + clearQueue + ")");
        }
        SessionInfo sessionInfo = null;
        Map map = this.sessionMap;
        synchronized (map) {
            sessionInfo = (SessionInfo)this.sessionMap.remove(absoluteSessionName);
            this.sessionArrCache = null;
            this.callbackAddressCache = null;
        }
        if (sessionInfo != null) {
            this.dispatchStatistic.incrNumUpdate(sessionInfo.getNumUpdates());
        } else {
            this.log.warn(this.ME, "Lookup of session with absoluteSessionName=" + absoluteSessionName + " failed");
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, this.subjectQueue.toXml(null));
        }
        this.shutdown(clearQueue, forceShutdownEvenIfEntriesExist);
    }

    public final SessionName getSubjectName() {
        return this.subjectName;
    }

    public final String getId() {
        return this.subjectName.getAbsoluteName();
    }

    public final String toString() {
        return this.subjectName.getAbsoluteName();
    }

    public final String getLoginName() {
        return this.subjectName.getLoginName();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<SubjectInfo id='").append(this.subjectName.getAbsoluteName()).append("'>");
        sb.append(offset).append(" <state>").append(this.getStateStr()).append("</state>");
        if (this.isAlive()) {
            sb.append(offset).append(" <subjectId>").append(this.getLoginName()).append("</subjectId>");
            sb.append(this.subjectQueue.toXml(extraOffset + " "));
            SessionInfo[] sessions = this.getSessions();
            int i = 0;
            while (i < sessions.length) {
                SessionInfo sessionInfo = sessions[i];
                sb.append(sessionInfo.toXml(extraOffset + " "));
                ++i;
            }
        }
        sb.append(offset).append("</SubjectInfo>");
        return sb.toString();
    }

    public final SessionInfo getSessionByPublicId(long publicSessionId) {
        if (publicSessionId == 0L) {
            return null;
        }
        SessionName sessionName = new SessionName((Global)this.glob, this.subjectName, publicSessionId);
        Map map = this.sessionMap;
        synchronized (map) {
            SessionInfo sessionInfo = (SessionInfo)this.sessionMap.get(sessionName.getAbsoluteName());
            return sessionInfo;
        }
    }

    public final boolean isUndef() {
        return this.state == -1;
    }

    public final boolean isAlive() {
        return this.state == 0;
    }

    public final boolean isDead() {
        return this.state == 1;
    }

    public final String getStateStr() {
        if (this.isAlive()) {
            return "ALIVE";
        }
        if (this.isDead()) {
            return "DEAD";
        }
        if (this.isUndef()) {
            return "UNDEF";
        }
        return "INTERNAL_ERROR";
    }

    long getUptime() {
        return (System.currentTimeMillis() - this.uptime) / 1000L;
    }

    long getNumUpdates() {
        long numUpdates = this.dispatchStatistic.getNumUpdate();
        SessionInfo[] sessions = this.getSessions();
        int i = 0;
        while (i < sessions.length) {
            SessionInfo sessionInfo = sessions[i];
            numUpdates += sessionInfo.getNumUpdates();
            ++i;
        }
        return numUpdates;
    }

    long getSubjectQueueNumMsgs() {
        return this.subjectQueue.getNumOfEntries();
    }

    long getSubjectQueueMaxMsgs() {
        return this.subjectQueue.getMaxNumOfEntries();
    }

    int getNumSessions() {
        return this.getSessions().length;
    }

    int getMaxSessions() {
        return this.maxSessions;
    }

    String getSessionList() {
        int numSessions = this.getNumSessions();
        if (numSessions < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(numSessions * 30);
        SessionInfo[] sessions = this.getSessions();
        int i = 0;
        while (i < sessions.length) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(sessions[i].getPublicSessionId());
            ++i;
        }
        return sb.toString();
    }

    I_AdminSession getSessionByPubSessionId(long pubSessionId) {
        SessionInfo sessionInfo = this.getSessionByPublicId(pubSessionId);
        return sessionInfo == null ? null : sessionInfo.getSessionInfoProtector();
    }

    String getKillClient() throws XmlBlasterException {
        int numSessions = this.getNumSessions();
        if (numSessions < 1) {
            return "";
        }
        String sessionList = this.getSessionList();
        while (true) {
            SessionInfo sessionInfo = null;
            Map map = this.sessionMap;
            synchronized (map) {
                Iterator iterator = this.sessionMap.values().iterator();
                if (!iterator.hasNext()) {
                    break;
                }
                sessionInfo = (SessionInfo)iterator.next();
            }
            sessionInfo.getKillSession();
        }
        return this.getId() + " Sessions " + sessionList + " killed";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

