/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.plugin.PluginManagerBase;

public class PluginManager
extends PluginManagerBase {
    private final String ME;
    private static final String defaultPluginName = "org.xmlBlaster.authentication.plugins.htpasswd.Manager";
    private static final String defaultPluginType = "htpasswd";
    private static final String defaultPluginVersion = "1.0";
    private Authenticate auth = null;
    private final Global glob;
    private final LogChannel log;

    public PluginManager(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("auth");
        this.ME = "SecurityPluginManager" + this.glob.getLogPrefixDashed();
        if (glob.getProperty().get("Security.Server.allowSimpleDriver", false)) {
            this.log.warn(this.ME, "* * * Security risk * * * : Security.Server.allowSimpleDriver=true");
            this.log.warn(this.ME, "The Simple security plugin is available, this is not save and can be misused by untrusted clients.");
        }
        String key = this.createPluginPropertyKey(defaultPluginType, defaultPluginVersion);
        if (glob.getProperty().get(key, (String)null) == null) {
            try {
                glob.getProperty().set(key, defaultPluginName);
            }
            catch (Exception e) {
                this.log.warn(this.ME, e.toString());
            }
        }
    }

    public void init(Authenticate auth) {
        this.auth = auth;
    }

    public I_Manager getManager(String type, String version) throws XmlBlasterException {
        if ("simple".equals(type) && !this.glob.getProperty().get("Security.Server.allowSimpleDriver", false)) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, "It's not allowed to use the simple security manager!");
        }
        return (I_Manager)this.getPluginObject(type, version);
    }

    public I_Manager getManager(String sessionId) throws XmlBlasterException {
        SessionInfo sessionInfo = this.auth.check(sessionId);
        if (sessionInfo == null) {
            this.log.error(this.ME, "Authentication internal error, access denied");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, this.ME, "Unknown session!");
        }
        I_Session sessionSecCtx = sessionInfo.getSecuritySession();
        return sessionSecCtx.getManager();
    }

    public void postInstantiate(I_Plugin plugin, PluginInfo pluginInfo) {
    }

    protected String getPluginPropertyName() {
        return "Security.Server.Plugin";
    }

    public String getDefaultPluginName(String type, String version) {
        return defaultPluginName;
    }

    public I_Manager getManager(SessionInfo sessionInfo) throws XmlBlasterException {
        I_Session sessionSecCtx = sessionInfo.getSecuritySession();
        return sessionSecCtx.getManager();
    }

    public I_Manager getDummyManager() throws XmlBlasterException {
        return (I_Manager)super.getDummyPlugin();
    }
}

