/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.demo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Hashtable;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.demo.PluginGUI;
import org.xmlBlaster.authentication.plugins.demo.Session;
import org.xmlBlaster.authentication.plugins.demo.Subject;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.PluginInfo;

public class Manager
implements I_Manager {
    private static final String ME = "Manager";
    private Global glob;
    private LogChannel log;
    private static final String TYPE = "gui";
    private static final String VERSION = "1.0";
    private Hashtable sessions = new Hashtable();
    private boolean packFrame = false;
    private PluginGUI frame;

    public void init(Global glob, PluginInfo pluginInfo) {
        this.glob = glob;
        this.log = glob.getLog("demo");
        this.log.call("Manager.Manager()", "-------START--------\n");
        this.log.info("Manager.Manager()", "Starting GUI ...");
        this.frame = new PluginGUI();
        if (this.packFrame) {
            this.frame.pack();
        } else {
            this.frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this.frame).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        ((Component)this.frame).setVisible(true);
        this.log.info("Manager.Manager()", "... GUI started.");
        this.log.call("Manager.Manager()", "-------END----------\n");
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return VERSION;
    }

    public final Global getGlobal() {
        return this.glob;
    }

    public I_Session reserveSession(String sessionId) {
        this.log.trace("Manager.reserveSessionSecurityContext(String sessionId=" + sessionId + ")", "-------START--------\n");
        Session session = new Session(this, sessionId);
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.put(sessionId, session);
        }
        this.log.trace("Manager.reserveSessionSecurityContext(...))", "-------END--------\n");
        return session;
    }

    public void releaseSession(String sessionId, String qos_literal) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.remove(sessionId);
        }
    }

    void changeSecretSessionId(String oldSessionId, String newSessionId) throws XmlBlasterException {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Session session = (Session)this.sessions.get(oldSessionId);
            if (session == null) {
                throw new XmlBlasterException("Manager.unknownSessionId", "Unknown sessionId!");
            }
            if (this.sessions.get(newSessionId) != null) {
                throw new XmlBlasterException("Manager.invalidSessionId", "This sessionId is already in use!");
            }
            this.sessions.put(session, newSessionId);
            this.sessions.remove(oldSessionId);
        }
    }

    public I_Session getSessionById(String id) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            I_Session i_Session = (I_Session)this.sessions.get(id);
            return i_Session;
        }
    }

    Subject getSubject(String name) throws XmlBlasterException {
        return new Subject(this.frame, name);
    }

    PluginGUI getGUI() {
        return this.frame;
    }

    public void shutdown() throws XmlBlasterException {
    }
}

