/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.demo;

import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.I_Subject;
import org.xmlBlaster.authentication.plugins.demo.Manager;
import org.xmlBlaster.authentication.plugins.demo.ReversibleCrypt;
import org.xmlBlaster.authentication.plugins.demo.SecurityQos;
import org.xmlBlaster.authentication.plugins.demo.Subject;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;

public class Session
implements I_Session {
    private static final String ME = "Session";
    private Subject subject = null;
    private Manager secMgr = null;
    private String sessionId = null;
    private boolean authenticated = false;
    private Subject dummyUsr = null;
    private byte aDemoCryptoKey = (byte)10;
    private ReversibleCrypt crypter = new ReversibleCrypt();

    public Session(Manager sm, String sessionId) {
        this.secMgr = sm;
        this.sessionId = sessionId;
        if (this.dummyUsr == null) {
            this.dummyUsr = new Subject(this.secMgr.getGUI());
        }
    }

    public String init(String securityQos_literal) throws XmlBlasterException {
        return this.init(new org.xmlBlaster.authentication.plugins.simple.SecurityQos(this.secMgr.getGlobal(), securityQos_literal));
    }

    public String init(I_SecurityQos securityQos) throws XmlBlasterException {
        this.authenticated = false;
        this.subject = this.determineSubject(securityQos.getUserId(), ((SecurityQos)securityQos).getCredential());
        this.authenticated = true;
        return null;
    }

    public boolean verify(I_SecurityQos securityQos) {
        if (!this.authenticated) {
            return false;
        }
        try {
            this.determineSubject(securityQos.getUserId(), ((SecurityQos)securityQos).getCredential());
            return true;
        }
        catch (XmlBlasterException e) {
            return false;
        }
    }

    public void changeSecretSessionId(String sessionId) throws XmlBlasterException {
        if (this.sessionId.equals(sessionId)) {
            return;
        }
        String string = sessionId;
        synchronized (string) {
            this.secMgr.changeSecretSessionId(this.sessionId, sessionId);
            this.sessionId = sessionId;
        }
    }

    public String getSecretSessionId() {
        return this.sessionId;
    }

    public I_Subject getSubject() {
        return this.subject;
    }

    public I_Manager getManager() {
        return this.secMgr;
    }

    private Subject determineSubject(String user, String passwd) throws XmlBlasterException {
        Subject subj = this.secMgr.getSubject(user);
        subj.authenticate(passwd);
        return subj;
    }

    public MsgUnitRaw importMessage(MsgUnitRaw msg, MethodName method) throws XmlBlasterException {
        msg = new MsgUnitRaw(msg.getMsgUnit(), this.importMessage(msg.getKey()), this.importMessage(msg.getContent()), this.importMessage(msg.getQos()));
        this.secMgr.getGUI().printQoS(msg.getQos());
        this.secMgr.getGUI().printContent(msg.getContentStr());
        return msg;
    }

    public String importMessage(String xmlMsg) throws XmlBlasterException {
        if (xmlMsg == null) {
            return null;
        }
        String ret = null;
        ret = this.crypter.decrypt(xmlMsg);
        return ret;
    }

    public byte[] importMessage(byte[] byteArr) throws XmlBlasterException {
        this.secMgr.getGUI().printInputStream(new String(byteArr));
        byte[] newByteArr = this.crypter.decrypt(byteArr);
        this.secMgr.getGUI().printOutputStream(new String(newByteArr));
        return newByteArr;
    }

    public MsgUnitRaw exportMessage(MsgUnitRaw msg, MethodName action) throws XmlBlasterException {
        msg = new MsgUnitRaw(msg.getMsgUnit(), this.exportMessage(msg.getKey()), this.exportMessage(msg.getContent()), this.exportMessage(msg.getQos()));
        return msg;
    }

    public String exportMessage(String xmlMsg) throws XmlBlasterException {
        if (xmlMsg == null) {
            return null;
        }
        String ret = null;
        ret = new String(this.crypter.crypt(xmlMsg.getBytes()));
        return ret;
    }

    public byte[] exportMessage(byte[] byteArr) throws XmlBlasterException {
        this.secMgr.getGUI().printOutputStream(new String(byteArr));
        byte[] newByteArr = this.crypter.crypt(byteArr);
        this.secMgr.getGUI().printInputStream(new String(newByteArr));
        return newByteArr;
    }
}

