/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.htpasswd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.htpasswd.jcrypt;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class HtPasswd {
    private static final String ME = "HtPasswd";
    protected LogChannel log;
    protected final int ALLOW_PARTIAL_USERNAME = 1;
    protected final int FULL_USERNAME = 2;
    protected final int SWITCH_OFF = 3;
    protected int useFullUsername = 1;
    protected String htpasswdFilename = null;
    protected Hashtable htpasswd = null;
    private static boolean first = true;

    public HtPasswd(Global glob) throws XmlBlasterException {
        this.log = glob.getLog("auth");
        this.htpasswdFilename = glob.getProperty().get("Security.Server.Plugin.htpasswd.secretfile", "NONE");
        boolean allowPartialUsername = glob.getProperty().get("Security.Server.Plugin.htpasswd.allowPartialUsername", false);
        if (allowPartialUsername) {
            this.useFullUsername = 1;
            if (this.log.TRACE) {
                this.log.trace(ME, "Login names are searched with 'startswith' mode in '" + this.htpasswdFilename + "'.");
            }
        } else {
            this.useFullUsername = 2;
            if (this.log.TRACE) {
                this.log.trace(ME, "contructor(" + this.htpasswdFilename + ") allowPartialUsername=false");
            }
        }
        if (this.htpasswdFilename != null && this.htpasswdFilename.equals("NONE")) {
            this.useFullUsername = 3;
            if (first) {
                this.log.warn(ME, "Security risk, no access control: The passwd file is switched off with 'Security.Server.Plugin.htpasswd.secretfile=NONE'");
                first = false;
            }
            return;
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "contructor(" + this.htpasswdFilename + ") ");
        }
        if (this.readHtpasswordFile(this.htpasswdFilename)) {
            // empty if block
        }
    }

    private boolean checkDetailed(String userPassword, Vector fileEncodedPass) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Comparing '" + userPassword + "' in " + fileEncodedPass.size() + " possibilities");
        }
        String encoded = null;
        Enumeration e = fileEncodedPass.elements();
        while (e.hasMoreElements()) {
            encoded = (String)e.nextElement();
            if (encoded == null) continue;
            String salt = encoded.substring(0, 2);
            String userEncoded = jcrypt.crypt(salt, userPassword);
            if (this.log.TRACE) {
                this.log.trace(ME, "Comparing '" + userEncoded + "' with passwd entry '" + encoded + "'");
            }
            if (!userEncoded.trim().equals(encoded.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean checkPassword(String userName, String userPassword) throws XmlBlasterException {
        if (this.useFullUsername == 3) {
            return true;
        }
        if (this.htpasswd != null && userName != null && userPassword != null) {
            Vector<String> pws = new Vector<String>();
            if (this.useFullUsername == 2) {
                pws.addElement((String)this.htpasswd.get(userName));
            } else {
                Enumeration e = this.htpasswd.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (this.log.TRACE) {
                        this.log.trace(ME, "Checking userName=" + userName + " with key='" + key + "'");
                    }
                    if (!userName.startsWith(key)) continue;
                    pws.addElement((String)this.htpasswd.get(key));
                }
            }
            return this.checkDetailed(userPassword, pws);
        }
        return false;
    }

    boolean readHtpasswordFile(String htpasswdFilename) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "readHtpasswordFile : " + htpasswdFilename);
        }
        if (htpasswdFilename == null) {
            throw new XmlBlasterException(ME, "missing property Security.Server.Plugin.htpasswd.secretfile");
        }
        File htpasswdFile = new File(htpasswdFilename);
        if (!htpasswdFile.exists()) {
            this.log.error(ME, "Secret file doesn't exist : " + htpasswdFilename + ", please check your 'Security.Server.Plugin.htpasswd.secretfile' setting.");
            throw new XmlBlasterException(ME, "secret file doesn't exist : " + htpasswdFilename);
        }
        if (!htpasswdFile.canRead()) {
            this.log.error(ME, "Secret file '" + htpasswdFilename + "' has no read permission");
            throw new XmlBlasterException(ME, "no read access on file : " + htpasswdFilename);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(htpasswdFile);
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            StreamTokenizer st = new StreamTokenizer(r);
            st.slashSlashComments(true);
            st.ordinaryChars(0, 255);
            st.eolIsSignificant(true);
            this.htpasswd = new Hashtable();
            StringBuffer user = new StringBuffer();
            StringBuffer password = new StringBuffer();
            boolean readUser = true;
            boolean end = false;
            block9: while (!end) {
                switch (st.nextToken()) {
                    default: {
                        if (st.ttype < 0) continue block9;
                        if ((char)st.ttype == ':') {
                            readUser = false;
                            break;
                        }
                        if ((char)st.ttype == '*') {
                            this.useFullUsername = 3;
                            if (first) {
                                this.log.warn(ME, "Security risk, no access control: '" + htpasswdFile + "' contains '*'");
                                first = false;
                            }
                            end = true;
                            break;
                        }
                        if (readUser) {
                            user.append((char)st.ttype);
                            break;
                        }
                        password.append((char)st.ttype);
                        break;
                    }
                    case -3: {
                        if (readUser) {
                            user.append(st.sval);
                            break;
                        }
                        password.append(st.sval);
                        break;
                    }
                    case 10: {
                        readUser = true;
                        this.htpasswd.put(user.toString(), password.toString());
                        user.setLength(0);
                        password.setLength(0);
                        break;
                    }
                    case -1: {
                        end = true;
                    }
                }
            }
            fis.close();
            return true;
        }
        catch (Exception ex) {
            try {
                fis.close();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            this.htpasswd = null;
            throw new XmlBlasterException(ME, "problem append when reading file : " + htpasswdFilename + ". Ex=" + ex);
        }
    }

    public String getPasswdFileName() {
        return this.htpasswdFilename;
    }
}

