/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.htpasswd;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.I_Subject;
import org.xmlBlaster.authentication.plugins.htpasswd.HtPasswd;
import org.xmlBlaster.authentication.plugins.htpasswd.Manager;
import org.xmlBlaster.authentication.plugins.htpasswd.SecurityQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;

public class Session
implements I_Session,
I_Subject {
    private static final String ME = "Session";
    private final Global glob;
    private final LogChannel log;
    protected Manager secMgr = null;
    protected String secretSessionId = null;
    protected boolean authenticated = false;
    protected HtPasswd htpasswd;
    protected String loginName;
    protected String passwd;

    public Session(Manager sm, String sessionId) throws XmlBlasterException {
        this.glob = sm.getGlobal() == null ? Global.instance() : sm.getGlobal();
        this.log = this.glob.getLog("auth");
        this.log.trace(ME, "Initializing HTACCESS Session sm=" + sm + ", sessionId=" + sessionId + ".");
        this.secMgr = sm;
        this.secretSessionId = sessionId;
        this.htpasswd = new HtPasswd(this.glob);
    }

    public String init(String securityQos_literal) throws XmlBlasterException {
        return this.init(new SecurityQos(this.glob, securityQos_literal));
    }

    public String init(I_SecurityQos securityQos) throws XmlBlasterException {
        if (securityQos == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, ME, "Authentication failed, due to missing security QoS");
        }
        this.authenticated = false;
        this.loginName = securityQos.getUserId();
        this.passwd = ((SecurityQos)securityQos).getCredential();
        if (this.loginName == null || this.passwd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, ME, "Authentication of user " + this.getName() + " failed, you've passed an illegal login name or password");
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "Checking password ...");
        }
        this.authenticated = this.htpasswd.checkPassword(this.loginName, this.passwd);
        if (this.log.TRACE) {
            this.log.trace(ME, "The password for " + this.loginName + " is " + (this.authenticated ? "" : " NOT ") + " valid.");
        }
        if (!this.authenticated) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, ME, "Authentication of user " + this.getName() + " failed");
        }
        return null;
    }

    public boolean verify(I_SecurityQos securityQos) {
        if (!this.authenticated) {
            return false;
        }
        return this.loginName.equals(securityQos.getUserId()) && this.passwd.equals(((SecurityQos)securityQos).getCredential());
    }

    public String getName() {
        return this.loginName;
    }

    public boolean isAuthorized(MethodName actionKey, String key) {
        if (!this.authenticated) {
            this.log.warn("Session.AccessDenied", "Authentication of user " + this.getName() + " failed");
            return false;
        }
        return true;
    }

    public void changeSecretSessionId(String sessionId) throws XmlBlasterException {
        if (this.secretSessionId.endsWith(sessionId)) {
            return;
        }
        Session session = this;
        synchronized (session) {
            this.secMgr.changeSecretSessionId(this.secretSessionId, sessionId);
            this.secretSessionId = sessionId;
        }
    }

    public String getSecretSessionId() {
        return this.secretSessionId;
    }

    public I_Subject getSubject() {
        return this;
    }

    public I_Manager getManager() {
        return this.secMgr;
    }

    public MsgUnitRaw importMessage(MsgUnitRaw msg, MethodName action) throws XmlBlasterException {
        return msg;
    }

    public String importMessage(String xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public byte[] importMessage(byte[] xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public MsgUnitRaw exportMessage(MsgUnitRaw msg, MethodName action) throws XmlBlasterException {
        return msg;
    }

    public String exportMessage(String xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public byte[] exportMessage(byte[] xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }
}

