/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class LdapGateway {
    private static final String ME = "LdapGateway";
    private final LogChannel log;
    private final String CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private final String rootDN;
    private final String rootPwd;
    private DirContext rootCtx;
    private String loginFieldName;
    private final String serverUrl;

    public LdapGateway(Global glob, String serverUrl, String rootDN, String rootPwd, String loginFieldName) throws XmlBlasterException {
        this.log = glob.getLog("ldap");
        this.serverUrl = serverUrl;
        this.rootDN = rootDN;
        this.rootPwd = rootPwd;
        this.rootCtx = this.getRootContext();
        this.loginFieldName = loginFieldName;
    }

    public void close() {
        block3: {
            if (this.rootCtx != null) {
                try {
                    this.rootCtx.close();
                }
                catch (NamingException e) {
                    if (!this.log.TRACE) break block3;
                    this.log.trace(ME, "Closing DirContext faild: " + e.toString());
                }
            }
        }
        this.rootCtx = null;
    }

    public DirContext getRootContext() throws XmlBlasterException {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>(7, 0.75f);
            if (this.log.TRACE) {
                this.log.trace(ME, "Using the factory com.sun.jndi.ldap.LdapCtxFactory");
            }
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (this.log.TRACE) {
                this.log.trace(ME, "Using ldap server " + this.serverUrl + "??sub   (You can try this URL with your netscape browser)");
            }
            env.put("java.naming.provider.url", this.serverUrl);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.rootDN);
            env.put("java.naming.security.credentials", this.rootPwd);
            if (this.log.TRACE) {
                this.log.trace(ME, "rootDN=" + this.rootDN + " rootPwd=" + this.rootPwd);
            }
            if (this.log.TRACE) {
                this.log.trace(ME, "Getting master context handle with master password from xmlBlaster.org ...");
            }
            InitialDirContext ctx = new InitialDirContext(env);
            if (this.log.TRACE) {
                this.log.trace(ME, "Connected to ldap server '" + this.serverUrl + "' as '" + this.rootDN + "'");
            }
            return ctx;
        }
        catch (NamingException e) {
            this.log.error(ME, "Can't access root context, check your settings ldap.serverUrl='" + this.serverUrl + "', ldap.rootDN='" + this.rootDN + "' and ldap.rootPwd='***'");
            throw new XmlBlasterException(ME, e.toString());
        }
    }

    private String getUserDN(String loginName) throws XmlBlasterException {
        try {
            String filter = this.loginFieldName + "=" + loginName;
            NamingEnumeration answer = this.search(this.rootCtx, filter);
            String baseName = this.getBaseName();
            if (this.log.TRACE) {
                this.log.trace(ME, "DN access for user=" + loginName + ". Trying basename = '" + baseName + "'");
            }
            if (answer.hasMore()) {
                SearchResult sr = (SearchResult)answer.next();
                String userDN = sr.getName() + "," + baseName;
                if (this.log.TRACE) {
                    this.log.trace(ME, "Successful accessed DN='" + userDN + "' for user " + loginName);
                }
                return userDN;
            }
            this.log.error(ME, "Can't access root context, check your setting of ldap.loginFieldName='" + this.loginFieldName + "'");
            throw new XmlBlasterException(ME, this.serverUrl + " is not valid");
        }
        catch (NamingException e) {
            throw new XmlBlasterException(ME, e.toString());
        }
    }

    private DirContext getUserContext(String loginName, String userPassword) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(ME, "Getting user=" + loginName + " context handle");
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>(7, 0.75f);
            if (this.log.TRACE) {
                this.log.trace(ME, "Using the factory com.sun.jndi.ldap.LdapCtxFactory");
            }
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (this.log.TRACE) {
                this.log.trace(ME, "Using ldap server " + this.serverUrl + "??sub   (You can try this URL with your browser)");
            }
            env.put("java.naming.provider.url", this.serverUrl);
            String userDN = this.getUserDN(loginName);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", userPassword);
            if (this.log.TRACE) {
                this.log.trace(ME, "  Getting context handle ...");
            }
            InitialDirContext userCtx = new InitialDirContext(env);
            if (this.log.TRACE) {
                this.log.trace(ME, "  Connected to ldap server url='" + this.serverUrl + "' with DN='" + userDN + "'");
            }
            return userCtx;
        }
        catch (NamingException e) {
            throw new XmlBlasterException(ME, e.toString());
        }
    }

    public String getBaseName() {
        return this.serverUrl.substring(this.serverUrl.indexOf("/", 8) + 1);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    /*
     * Loose catch block
     */
    public Hashtable getAllAttributes(String loginName, String password, String lookupUserId) throws XmlBlasterException {
        Hashtable attrHash;
        block14: {
            BasicAttributes newNode = new BasicAttributes();
            attrHash = new Hashtable();
            DirContext userCtx = null;
            userCtx = loginName == null ? this.rootCtx : (loginName.equals(lookupUserId) ? this.getUserContext(loginName, password) : this.getUserContext(loginName, password));
            NamingEnumeration searchResults = this.search(userCtx, this.loginFieldName + "=" + lookupUserId);
            while (searchResults.hasMore()) {
                SearchResult nextEntry = (SearchResult)searchResults.next();
                System.out.println("name: " + nextEntry.getName());
                Attributes attributeSet = nextEntry.getAttributes();
                if (attributeSet.size() == 0) {
                    this.log.error(ME, "No attributes returned for cn=" + loginName + " in " + this.serverUrl);
                    continue;
                }
                NamingEnumeration<? extends Attribute> allAttributes = attributeSet.getAll();
                while (allAttributes.hasMoreElements()) {
                    Attribute attribute = allAttributes.next();
                    String attributeId = attribute.getID();
                    NamingEnumeration<?> values = attribute.getAll();
                    int ii = 0;
                    while (values.hasMoreElements()) {
                        if (ii > 0 && this.log.TRACE) {
                            this.log.trace(ME, "WARN: Ignoring multiple values for " + attributeId);
                        }
                        Object val = values.nextElement();
                        attrHash.put(attributeId, val);
                        ++ii;
                    }
                }
            }
            Object var17_17 = null;
            try {
                if (userCtx != null) {
                    userCtx.close();
                }
                break block14;
            }
            catch (NamingException e) {
                this.log.warn(ME, "Problems closng the user context: " + e.toString());
            }
            break block14;
            {
                catch (NamingException e) {
                    throw new XmlBlasterException(ME, e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                try {
                    if (userCtx != null) {
                        userCtx.close();
                    }
                }
                catch (NamingException e) {
                    this.log.warn(ME, "Problems closng the user context: " + e.toString());
                }
                throw throwable;
            }
        }
        return attrHash;
    }

    public String getPassword(Attributes result) throws XmlBlasterException {
        try {
            if (result == null) {
                return null;
            }
            Attribute attr = result.get("userPassword");
            if (attr != null) {
                System.out.println("userPassword:");
                String password = null;
                NamingEnumeration<?> vals = attr.getAll();
                while (vals.hasMoreElements()) {
                    password = (String)vals.nextElement();
                }
                return password;
            }
        }
        catch (NamingException e) {
            throw new XmlBlasterException(ME, e.toString());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean userExists(String loginName, String password, String loginNameToCheck) throws XmlBlasterException {
        filter = "(" + this.loginFieldName + "=" + loginNameToCheck + ")";
        userCtx = null;
        try {
            userCtx = loginName == null ? this.rootCtx : this.getUserContext(loginName, password);
            searchResults = null;
            try {
                searchResults = this.search(userCtx, filter);
            }
            catch (XmlBlasterException e) {
                this.log.error("LdapGateway", "The cn=" + loginNameToCheck + " is unknown in " + this.serverUrl);
                var8_10 = false;
                var10_11 = null;
                try {
                    if (userCtx == null) return var8_10;
                    userCtx.close();
                    return var8_10;
                }
                catch (NamingException e) {
                    this.log.warn("LdapGateway", "Problems closng the user context: " + e.toString());
                }
                return var8_10;
            }
            if (!searchResults.hasMore()) ** GOTO lbl48
            if (this.log.TRACE) {
                this.log.trace("LdapGateway", "The cn=" + loginNameToCheck + " (dieser Pappenheimer) is well known in " + this.serverUrl);
            }
            var7_9 = true;
            var10_12 = null;
            ** GOTO lbl41
        }
        catch (NamingException e) {
            throw new XmlBlasterException("LdapGateway", e.toString());
        }
        {
            catch (Throwable var9_19) {
                var10_14 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 231->246)] { 
lbl35:
                // 1 sources

                if (userCtx == null) throw var9_19;
                userCtx.close();
                throw var9_19;
lbl38:
                // 1 sources

                catch (NamingException e) {
                    this.log.warn("LdapGateway", "Problems closng the user context: " + e.toString());
                }
                throw var9_19;
            }
lbl41:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [3 : 231->246)] { 
lbl42:
            // 1 sources

            if (userCtx == null) return var7_9;
            userCtx.close();
            return var7_9;
lbl45:
            // 1 sources

            catch (NamingException e) {
                this.log.warn("LdapGateway", "Problems closng the user context: " + e.toString());
            }
            return var7_9;
lbl48:
            // 1 sources

            var10_13 = null;
            try {}
            catch (NamingException e) {}
            this.log.warn("LdapGateway", "Problems closng the user context: " + e.toString());
            return false;
            if (userCtx == null) return false;
            userCtx.close();
            return false;
        }
    }

    public boolean checkPassword(String loginName, String userPassword) throws XmlBlasterException {
        try {
            DirContext userCtx = this.getUserContext(loginName, userPassword);
            if (userCtx != null) {
                userCtx.close();
                return true;
            }
            return false;
        }
        catch (NamingException e) {
            throw new XmlBlasterException(ME, e.toString());
        }
    }

    private NamingEnumeration search(DirContext ctx, String filter) throws XmlBlasterException {
        try {
            if (this.log.TRACE) {
                this.log.trace(ME, "Calling SearchControl constructor to set search constraints...");
            }
            SearchControls searchControls = new SearchControls(2, 0L, 0, null, true, false);
            String MY_SEARCHBASE = "";
            if (this.log.TRACE) {
                this.log.trace(ME, "Searching " + filter);
            }
            NamingEnumeration<SearchResult> searchResults = ctx.search("", filter, searchControls);
            if (this.log.TRACE) {
                this.log.trace(ME, "Searching successful done\n");
            }
            return searchResults;
        }
        catch (NamingException e) {
            throw new XmlBlasterException(ME, e.toString());
        }
    }

    public static void main(String[] args) {
        System.out.println("\nUsage:\n\n\torg.xmlBlaster.authentication.plugins.ldap.LdapGateway -loginName <name> -userPassword <passwd>\n\torg.xmlBlaster.authentication.plugins.ldap.LdapGateway -loginName tim -userPassword tim");
        try {
            Global glob = new Global(args);
            String serverUrl = glob.getProperty().get("serverUrl", "ldap://localhost:389/o=xmlBlaster,c=ORG");
            String rootDN = glob.getProperty().get("rootDN", "cn=Manager,o=xmlBlaster,c=ORG");
            String rootPwd = glob.getProperty().get("rootPwd", "secret");
            String loginName = glob.getProperty().get("loginName", "tim");
            String userPassword = glob.getProperty().get("userPassword", "tim");
            String loginFieldName = glob.getProperty().get("loginFieldName", "cn");
            LdapGateway ldap = new LdapGateway(glob, serverUrl, rootDN, rootPwd, loginFieldName);
            System.out.println("\nTesting checkPassword() ...");
            boolean pwdOk = ldap.checkPassword(loginName, userPassword);
            System.out.println("The password=" + userPassword + " for cn=" + loginName + " is " + (pwdOk ? "" : " NOT ") + " valid.");
            System.out.println("\nTesting getAllAttributes() ...");
            Hashtable attrHash = ldap.getAllAttributes(loginName, userPassword, loginName);
            Enumeration keys = attrHash.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                System.out.println(key + ": " + attrHash.get(key));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.toString());
            e.printStackTrace();
        }
    }
}

