/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.ldap;

import java.util.Hashtable;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.ldap.Session;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.PluginInfo;

public class Manager
implements I_Manager {
    private Global glob = null;
    private static final String ME = "LdapManager";
    private static final String TYPE = "ldap";
    private static final String VERSION = "1.0";
    private Hashtable sessions = new Hashtable();

    public void init(Global glob, PluginInfo pluginInfo) {
        this.glob = glob;
    }

    final Global getGlobal() {
        return this.glob;
    }

    public final String getType() {
        return TYPE;
    }

    public final String getVersion() {
        return VERSION;
    }

    public final I_Session reserveSession(String sessionId) throws XmlBlasterException {
        Session session = new Session(this, sessionId);
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.put(sessionId, session);
        }
        return session;
    }

    public final void releaseSession(String sessionId, String qos_literal) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.remove(sessionId);
        }
    }

    final void changeSecretSessionId(String oldSessionId, String newSessionId) throws XmlBlasterException {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Session session = (Session)this.sessions.get(oldSessionId);
            if (session == null) {
                throw new XmlBlasterException("LdapManager.unknownSessionId", "Unknown sessionId!");
            }
            if (this.sessions.get(newSessionId) != null) {
                throw new XmlBlasterException("LdapManager.invalidSessionId", "This sessionId is already in use!");
            }
            this.sessions.put(newSessionId, session);
            this.sessions.remove(oldSessionId);
        }
    }

    public I_Session getSessionById(String id) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            I_Session i_Session = (I_Session)this.sessions.get(id);
            return i_Session;
        }
    }

    public void shutdown() throws XmlBlasterException {
    }
}

