/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.ldap;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.I_Subject;
import org.xmlBlaster.authentication.plugins.ldap.LdapGateway;
import org.xmlBlaster.authentication.plugins.ldap.Manager;
import org.xmlBlaster.authentication.plugins.ldap.SecurityQos;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;

public class Session
implements I_Session,
I_Subject {
    private static final String ME = "Session";
    protected final Manager secMgr;
    protected final LogChannel log;
    protected String sessionId;
    protected boolean authenticated = false;
    protected final LdapGateway ldap;
    protected String loginName;

    public Session(Manager sm, String sessionId) throws XmlBlasterException {
        this.secMgr = sm;
        this.log = this.secMgr.getGlobal().getLog("ldap");
        this.sessionId = sessionId;
        String serverUrl = sm.getGlobal().getProperty().get("ldap.serverUrl", "ldap://localhost:389/o=xmlBlaster,c=ORG");
        String rootDN = sm.getGlobal().getProperty().get("ldap.rootDN", "cn=Manager,o=xmlBlaster,c=ORG");
        String rootPwd = sm.getGlobal().getProperty().get("ldap.rootPwd", "secret");
        String loginFieldName = sm.getGlobal().getProperty().get("ldap.loginFieldName", "cn");
        this.log.info(ME, "Initializing LDAP access on ldap.serverUrl='" + serverUrl + "' with rootdn='" + rootDN + "'. The unique uid field name in ldap should be '" + loginFieldName + "'.");
        this.ldap = new LdapGateway(this.secMgr.getGlobal(), serverUrl, rootDN, rootPwd, loginFieldName);
    }

    public String init(String xmlQoS_literal) throws XmlBlasterException {
        return this.init(new SecurityQos(this.secMgr.getGlobal(), xmlQoS_literal));
    }

    public String init(I_SecurityQos securityQos) throws XmlBlasterException {
        this.authenticated = false;
        this.loginName = securityQos.getUserId();
        String passwd = ((SecurityQos)securityQos).getCredential();
        if (this.log.TRACE) {
            this.log.trace(ME, "Checking password ...");
        }
        this.authenticated = this.ldap.checkPassword(this.loginName, passwd);
        if (this.log.TRACE) {
            this.log.trace(ME, "The password for cn=" + this.loginName + " is " + (this.authenticated ? "" : " NOT ") + " valid.");
        }
        if (!this.authenticated) {
            throw new XmlBlasterException(this.secMgr.getGlobal(), ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, ME, "Authentication of user " + this.getName() + " failed, no authentication from LDAP server.");
        }
        return null;
    }

    public boolean verify(I_SecurityQos securityQos) {
        if (!this.authenticated) {
            return false;
        }
        try {
            return this.ldap.checkPassword(securityQos.getUserId(), ((SecurityQos)securityQos).getCredential());
        }
        catch (XmlBlasterException e) {
            return false;
        }
    }

    public String getName() {
        return this.loginName;
    }

    public boolean isAuthorized(MethodName actionKey, String key) {
        if (!this.authenticated) {
            this.log.warn("Session.AccessDenied", "Authentication of user " + this.getName() + " failed");
            return false;
        }
        this.log.warn(ME, "No authorization check for action='" + actionKey + "' on key='" + key + "' is implemented, access generously granted.");
        return true;
    }

    public void changeSecretSessionId(String sessionId) throws XmlBlasterException {
        if (this.sessionId.endsWith(sessionId)) {
            return;
        }
        String string = sessionId;
        synchronized (string) {
            this.secMgr.changeSecretSessionId(this.sessionId, sessionId);
            this.sessionId = sessionId;
        }
    }

    public String getSecretSessionId() {
        return this.sessionId;
    }

    public I_Subject getSubject() {
        return this;
    }

    public I_Manager getManager() {
        return this.secMgr;
    }

    public MsgUnitRaw importMessage(MsgUnitRaw msg, MethodName action) throws XmlBlasterException {
        return msg;
    }

    public String importMessage(String xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public byte[] importMessage(byte[] xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public MsgUnitRaw exportMessage(MsgUnitRaw msg, MethodName action) throws XmlBlasterException {
        return msg;
    }

    public String exportMessage(String xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public byte[] exportMessage(byte[] xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }
}

