/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.simple;

import java.util.Hashtable;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.simple.Session;
import org.xmlBlaster.authentication.plugins.simple.Subject;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.PluginInfo;

public class Manager
implements I_Manager {
    private static final String ME = "SimpleManager";
    private static final String TYPE = "simple";
    private static final String VERSION = "1.0";
    private Global glob = null;
    private Hashtable sessions = new Hashtable();

    public void init(Global glob, PluginInfo pluginInfo) {
        this.glob = glob;
    }

    final Global getGlobal() {
        return this.glob;
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return VERSION;
    }

    public I_Session reserveSession(String sessionId) {
        Session session = new Session(this, sessionId);
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.put(sessionId, session);
        }
        return session;
    }

    public void releaseSession(String sessionId, String qos_literal) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.remove(sessionId);
        }
    }

    void changeSecretSessionId(String oldSessionId, String newSessionId) throws XmlBlasterException {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Session session = (Session)this.sessions.get(oldSessionId);
            if (session == null) {
                throw new XmlBlasterException("SimpleManager.unknownSessionId", "Unknown sessionId!");
            }
            if (this.sessions.get(newSessionId) != null) {
                throw new XmlBlasterException("SimpleManager.invalidSessionId", "This sessionId is already in use!");
            }
            this.sessions.put(newSessionId, session);
            this.sessions.remove(oldSessionId);
        }
    }

    public I_Session getSessionById(String id) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            I_Session i_Session = (I_Session)this.sessions.get(id);
            return i_Session;
        }
    }

    Subject getSubject(String name) throws XmlBlasterException {
        return new Subject(this.glob, name);
    }

    public void shutdown() throws XmlBlasterException {
    }
}

