/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.simple;

import org.jutils.text.StringHelper;
import org.xml.sax.Attributes;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;

public final class SecurityQos
extends SaxHandlerBase
implements I_SecurityQos {
    private static String ME = "SecurityQos-simple";
    private transient boolean inSecurityService = false;
    private transient boolean inUser = false;
    private transient boolean inPasswd = false;
    private String type = "simple";
    private String version = "1.0";
    private String user = null;
    private String passwd = null;

    public SecurityQos(Global glob) {
        super(glob);
    }

    public SecurityQos(Global glob, String xmlQoS_literal) throws XmlBlasterException {
        super(glob);
        this.parse(xmlQoS_literal);
    }

    public void parse(String xmlQoS_literal) throws XmlBlasterException {
        xmlQoS_literal = StringHelper.replaceAll(xmlQoS_literal, "<![CDATA[", "");
        xmlQoS_literal = StringHelper.replaceAll(xmlQoS_literal, "]]>", "");
        this.init(xmlQoS_literal);
    }

    public SecurityQos(Global glob, String loginName, String password) {
        super(glob);
        this.user = loginName;
        this.passwd = password;
    }

    public String getPluginVersion() {
        return this.version;
    }

    public String getPluginType() {
        return this.type;
    }

    public void setUserId(String userId) {
        this.user = userId;
    }

    public String getUserId() {
        return this.user;
    }

    public void setCredential(String cred) {
        this.passwd = cred;
    }

    public String getCredential() {
        return null;
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) {
        if (name.equalsIgnoreCase("securityService")) {
            this.inSecurityService = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int ii = 0;
                ii = 0;
                while (ii < len) {
                    if (attrs.getQName(ii).equalsIgnoreCase("type")) {
                        this.type = attrs.getValue(ii).trim();
                    } else if (attrs.getQName(ii).equalsIgnoreCase("version")) {
                        this.version = attrs.getValue(ii).trim();
                    }
                    ++ii;
                }
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("user")) {
            this.inUser = true;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("passwd")) {
            this.inPasswd = true;
            this.character.setLength(0);
            return;
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (name.equalsIgnoreCase("user")) {
            this.inUser = false;
            this.user = this.character.toString().trim();
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("passwd")) {
            this.inPasswd = false;
            this.passwd = this.character.toString().trim();
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("securityService")) {
            this.inSecurityService = false;
            this.character.setLength(0);
            return;
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(160);
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<securityService type=\"").append(this.getPluginType()).append("\" version=\"").append(this.getPluginVersion()).append("\">");
        sb.append(offset).append("   <![CDATA[");
        sb.append(offset).append("   <user>").append(this.user).append("</user>");
        sb.append(offset).append("   <passwd>").append(this.passwd).append("</passwd>");
        sb.append(offset).append("   ]]>");
        sb.append(offset).append("</securityService>");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            Global glob = new Global(args);
            String xml = "<securityService type=\"simple\" version=\"1.0\">\n   <![CDATA[\n   <passwd>theUsersPwd</passwd>\n   <user>aUser</user>\n   ]]>\n</securityService>";
            System.out.println("Original:\n" + xml);
            SecurityQos qos = new SecurityQos(glob, xml);
            System.out.println("Result:\n" + qos.toXml());
            qos.setUserId("AnotherUser");
            qos.setCredential("AnotherPassword");
            System.out.println(qos.toXml());
        }
        catch (Throwable e) {
            System.err.println("TestFailed: " + e.toString());
        }
    }
}

