/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.authentication.plugins.simple;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_Manager;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.I_Subject;
import org.xmlBlaster.authentication.plugins.simple.Manager;
import org.xmlBlaster.authentication.plugins.simple.SecurityQos;
import org.xmlBlaster.authentication.plugins.simple.Subject;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;

public class Session
implements I_Session {
    private static final String ME = "Session";
    private Subject subject = null;
    private final LogChannel log;
    private Manager secMgr = null;
    private String sessionId = null;
    private boolean authenticated = false;
    private Subject dummyUsr = null;

    public Session(Manager sm, String sessionId) {
        this.secMgr = sm;
        this.log = this.secMgr.getGlobal().getLog("simple");
        this.sessionId = sessionId;
        if (this.dummyUsr == null) {
            this.dummyUsr = new Subject(this.secMgr.getGlobal());
        }
    }

    public String init(String xmlQos_literal) throws XmlBlasterException {
        return this.init(new SecurityQos(this.secMgr.getGlobal(), xmlQos_literal));
    }

    public String init(I_SecurityQos securityQos) throws XmlBlasterException {
        this.authenticated = false;
        this.subject = this.determineSubject(securityQos.getUserId(), ((SecurityQos)securityQos).getCredential());
        this.authenticated = true;
        return null;
    }

    public boolean verify(I_SecurityQos securityQos) {
        if (!this.authenticated) {
            return false;
        }
        try {
            this.determineSubject(securityQos.getUserId(), ((SecurityQos)securityQos).getCredential());
            return true;
        }
        catch (XmlBlasterException e) {
            return false;
        }
    }

    public void changeSecretSessionId(String sessionId) throws XmlBlasterException {
        if (this.sessionId.endsWith(sessionId)) {
            return;
        }
        String string = sessionId;
        synchronized (string) {
            this.secMgr.changeSecretSessionId(this.sessionId, sessionId);
            this.sessionId = sessionId;
        }
    }

    public String getSecretSessionId() {
        return this.sessionId;
    }

    public I_Subject getSubject() {
        return this.subject;
    }

    public I_Manager getManager() {
        return this.secMgr;
    }

    private Subject determineSubject(String user, String passwd) throws XmlBlasterException {
        Subject subj = this.secMgr.getSubject(user);
        subj.authenticate(passwd);
        return subj;
    }

    public MsgUnitRaw importMessage(MsgUnitRaw msg, MethodName method) throws XmlBlasterException {
        return msg;
    }

    public String importMessage(String xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public byte[] importMessage(byte[] xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public MsgUnitRaw exportMessage(MsgUnitRaw msg, MethodName action) throws XmlBlasterException {
        return msg;
    }

    public String exportMessage(String xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }

    public byte[] exportMessage(byte[] xmlMsg) throws XmlBlasterException {
        return xmlMsg;
    }
}

