/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.error.I_MsgErrorHandler;
import org.xmlBlaster.util.error.I_MsgErrorInfo;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class ClientErrorHandler
implements I_MsgErrorHandler {
    private final String ME;
    private final Global glob;
    private final LogChannel log;
    private final I_XmlBlasterAccess xmlBlasterAccess;

    public ClientErrorHandler(Global glob, I_XmlBlasterAccess xmlBlasterAccess) {
        this.ME = "ClientErrorHandler-" + xmlBlasterAccess.getId();
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.xmlBlasterAccess = xmlBlasterAccess;
    }

    public void handleError(I_MsgErrorInfo msgErrorInfo) {
        if (msgErrorInfo == null) {
            return;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering handleError for " + msgErrorInfo.getMsgQueueEntries().length + " messages");
        }
        boolean shutdown = false;
        XmlBlasterException ex = msgErrorInfo.getXmlBlasterException();
        if (ex.isUser()) {
            shutdown = true;
        }
        MsgQueueEntry[] entries = msgErrorInfo.getMsgQueueEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getMethodName() == MethodName.CONNECT) {
                shutdown = true;
            } else {
                this.log.warn(this.ME, "Default error handling: Message '" + entries[i].getEmbeddedType() + "' '" + entries[i].getLogId() + "' is lost: " + msgErrorInfo.getXmlBlasterException().getMessage() + ". You can add your own client side error handler with I_XmlBlasterAccess.setClientErrorHandler() if desired.");
            }
            ++i;
        }
        if (shutdown) {
            this.log.error(this.ME, "Connection failed: " + msgErrorInfo.getXmlBlasterException().getMessage());
            if (msgErrorInfo.getDispatchManager() != null) {
                msgErrorInfo.getDispatchManager().toDead(ConnectionStateEnum.UNDEF, msgErrorInfo.getXmlBlasterException());
                if (this.xmlBlasterAccess.getQueue() != null) {
                    this.xmlBlasterAccess.getQueue().clear();
                }
                msgErrorInfo.getDispatchManager().shutdown();
                return;
            }
        }
        Thread.dumpStack();
        if (this.xmlBlasterAccess.getQueue() != null) {
            this.xmlBlasterAccess.getQueue().clear();
        }
    }

    public void handleErrorSync(I_MsgErrorInfo msgErrorInfo) throws XmlBlasterException {
        if (msgErrorInfo.getXmlBlasterException().isCommunication()) {
            this.handleError(msgErrorInfo);
            return;
        }
        throw msgErrorInfo.getXmlBlasterException();
    }

    public void shutdown() {
    }
}

