/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_ClientPlugin;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class PluginLoader {
    private static final String ME = "SecurityPluginLoader";
    private final Global glob;
    private final LogChannel log;
    private String pluginMechanism = null;
    private String pluginVersion = null;
    private I_ClientPlugin plugin = null;

    public PluginLoader(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("auth");
    }

    public String getType() {
        return this.pluginMechanism;
    }

    public String getVersion() {
        return this.pluginVersion;
    }

    public I_ClientPlugin getCurrentClientPlugin() throws XmlBlasterException {
        if (this.plugin != null) {
            return this.plugin;
        }
        return this.getClientPlugin(null, null);
    }

    public synchronized I_ClientPlugin getClientPlugin(String mechanism, String version) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("SecurityPluginLoader.getClientPlugin", "type=" + mechanism + " version=" + version);
        }
        if (this.pluginMechanism != null && this.pluginMechanism.equals(mechanism) && (this.pluginVersion == null && version == null || version != null && version.equals(this.pluginVersion))) {
            return this.plugin;
        }
        this.plugin = this.loadPlugin(this.fetchClassnameAndParam(mechanism, version));
        return this.plugin;
    }

    private synchronized I_ClientPlugin loadPlugin(String[] param) throws XmlBlasterException {
        if (param == null) {
            return null;
        }
        if (param[0] == null) {
            return null;
        }
        String[] p = new String[param.length - 1];
        I_ClientPlugin clntPlugin = null;
        try {
            if (this.log.TRACE) {
                this.log.trace(ME, "Trying Class.forName('" + param[0] + "') ...");
            }
            Class<?> cl = Class.forName(param[0]);
            clntPlugin = (I_ClientPlugin)cl.newInstance();
            clntPlugin.init(this.glob, null);
            if (this.log.TRACE) {
                this.log.trace(ME, "Found I_ClientPlugin '" + param[0] + "'");
            }
        }
        catch (IllegalAccessException e) {
            this.log.error(ME, "The plugin class '" + param[0] + "' is not accessible\n -> check the plugin name and/or the CLASSPATH");
            throw new XmlBlasterException("SecurityPluginLoader.NoClass", "The plugin class '" + param[0] + "' is not accessible\n -> check the plugin name and/or the CLASSPATH");
        }
        catch (SecurityException e) {
            this.log.error(ME, "Couldn't load security plugin '" + param[0] + "'. Access Denied");
            throw new XmlBlasterException("SecurityPluginLoader.AccessDenied", "The plugin class '" + param[0] + "' couldn't be loaded!");
        }
        catch (Throwable e) {
            this.log.error(ME, "The plugin class '" + param[0] + "'is invalid!" + e.toString());
            throw new XmlBlasterException("SecurityPluginLoader.InvalidClassOrInitializer", "The plugin class '" + param[0] + "'is invalid!" + e.toString());
        }
        System.arraycopy(param, 1, p, 0, param.length - 1);
        if (this.log.TRACE) {
            this.log.trace(ME, "Plugin '" + param[0] + "' successfully initialized");
        }
        return clntPlugin;
    }

    private synchronized String[] fetchClassnameAndParam(String mechanism, String version) throws XmlBlasterException {
        String s;
        String tmp = null;
        Vector<String> v = new Vector<String>();
        if (mechanism == null || mechanism.equals("")) {
            tmp = this.glob.getProperty().get("Security.Client.DefaultPlugin", "htpasswd,1.0");
            if (this.log.TRACE) {
                this.log.trace(ME, "Got Security.Client.DefaultPlugin=" + tmp);
            }
            if (tmp != null) {
                int i = tmp.indexOf(44);
                version = i == -1 ? null : tmp.substring(i + 1);
                mechanism = tmp.substring(0, i);
            } else {
                return null;
            }
        }
        if (version == null) {
            version = "";
        }
        if ((s = this.glob.getProperty().get("Security.Client.Plugin[" + mechanism + "][" + version + "]", (String)null)) == null) {
            if (mechanism.equals("htpasswd")) {
                s = "org.xmlBlaster.authentication.plugins.htpasswd.ClientPlugin";
            } else if (mechanism.equals("simple")) {
                s = "org.xmlBlaster.authentication.plugins.simple.ClientPlugin";
            } else if (mechanism.equals("ldap")) {
                s = "org.xmlBlaster.authentication.plugins.ldap.ClientPlugin";
            } else {
                throw new XmlBlasterException("SecurityPluginLoader.Unknown Plugin", "Unknown Plugin '" + mechanism + "' with version '" + version + "'.");
            }
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] classnameAndParam = new String[v.size()];
        v.copyInto(classnameAndParam);
        this.pluginMechanism = mechanism;
        this.pluginVersion = version;
        return classnameAndParam;
    }
}

