/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public final class SynchronousCache {
    private static final String ME = "SynchronousCache";
    private final Global glob;
    private Hashtable query2SubId = null;
    private Hashtable subscriptions = null;
    private int maxQueriesCached = 0;

    public SynchronousCache(Global glob, int maxQueriesCached) {
        this.glob = glob;
        this.query2SubId = new Hashtable();
        this.subscriptions = new Hashtable();
        this.maxQueriesCached = maxQueriesCached;
    }

    public void removeEntry(String subId) {
        Hashtable dataHashtable = (Hashtable)this.subscriptions.remove(subId);
        if (dataHashtable == null) {
            System.err.println("Expected to remove subId=" + subId + " " + this.toXml(""));
            return;
        }
        Hashtable hashtable = dataHashtable;
        synchronized (hashtable) {
            dataHashtable.clear();
        }
        String query = this.getQueryString(subId);
        if (query != null) {
            this.query2SubId.remove(query);
        } else {
            System.err.println("Expected to remove subId=" + subId + " from query2SubId: " + this.toXml(""));
        }
    }

    public void removeEntryByQueryString(String query, String keyOid) {
        Hashtable dataHashtable;
        String subId = (String)this.query2SubId.get(query);
        if (subId != null && (dataHashtable = (Hashtable)this.subscriptions.get(subId)) != null) {
            Hashtable hashtable = dataHashtable;
            synchronized (hashtable) {
                dataHashtable.remove(keyOid);
                if (dataHashtable.size() < 1) {
                    this.subscriptions.remove(subId);
                    this.query2SubId.remove(query);
                }
            }
        }
    }

    public void removeEntryByQueryString(String query) {
        Hashtable dataHashtable;
        String subId = (String)this.query2SubId.remove(query);
        if (subId != null && (dataHashtable = (Hashtable)this.subscriptions.remove(subId)) != null) {
            Hashtable hashtable = dataHashtable;
            synchronized (hashtable) {
                dataHashtable.clear();
            }
        }
    }

    private String getQueryString(String subscriptionId) {
        Enumeration queryEnum = this.query2SubId.keys();
        while (queryEnum.hasMoreElements()) {
            String query = (String)queryEnum.nextElement();
            String tmpSubscriptionId = (String)this.query2SubId.get(query);
            if (!tmpSubscriptionId.equals(subscriptionId)) continue;
            return query;
        }
        return null;
    }

    public boolean update(String subId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        Hashtable dataHashtable;
        Object obj = this.subscriptions.get(subId);
        if (obj == null) {
            return false;
        }
        if (updateQos.isErased()) {
            String query = this.getQueryString(subId);
            if (query != null) {
                if (query.startsWith("EXACT")) {
                    this.removeEntryByQueryString(query);
                    return true;
                }
                this.removeEntryByQueryString(query, updateKey.getOid());
                return true;
            }
            return true;
        }
        Hashtable hashtable = dataHashtable = (Hashtable)obj;
        synchronized (hashtable) {
            dataHashtable.put(updateKey.getOid(), new MsgUnit(updateKey.getData(), content, updateQos.getData()));
        }
        return true;
    }

    public MsgUnit[] get(GetKey getKey, GetQos getQos) throws XmlBlasterException {
        Hashtable dataHashtable;
        MsgUnit[] messageUnits = null;
        String subId = (String)this.query2SubId.get(this.getQueryString(getKey));
        if (subId != null && (dataHashtable = (Hashtable)this.subscriptions.get(subId)) != null) {
            Hashtable hashtable = dataHashtable;
            synchronized (hashtable) {
                messageUnits = new MsgUnit[dataHashtable.size()];
                int i = 0;
                Enumeration values = dataHashtable.elements();
                while (values.hasMoreElements()) {
                    messageUnits[i] = (MsgUnit)values.nextElement();
                    ++i;
                }
            }
        }
        return messageUnits;
    }

    public String getQueryString(GetKey getKey) {
        if (getKey.getData().isExact()) {
            return "EXACT" + getKey.getOid();
        }
        return getKey.getData().getQueryType() + getKey.getData().getQueryString().trim();
    }

    public boolean newEntry(String subId, GetKey getKey, MsgUnit[] units) throws XmlBlasterException {
        String query = this.getQueryString(getKey);
        if (this.query2SubId.get(query) != null) {
            return true;
        }
        if (this.query2SubId.size() < this.maxQueriesCached) {
            this.query2SubId.put(query, subId);
            Hashtable<String, MsgUnit> dataHashtable = new Hashtable<String, MsgUnit>();
            int i = 0;
            while (i < units.length) {
                dataHashtable.put(units[i].getKeyOid(), units[i]);
                ++i;
            }
            this.subscriptions.put(subId, dataHashtable);
            return true;
        }
        return false;
    }

    public synchronized void clear() {
        this.query2SubId.clear();
        this.subscriptions.clear();
    }

    public int getNumQueriesCached() {
        return this.subscriptions.size();
    }

    public Hashtable getSubscriptions() {
        return this.subscriptions;
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<SynchronousCache maxQueriesCached='").append(this.maxQueriesCached).append("'>");
        Enumeration subIdEnum = this.subscriptions.keys();
        while (subIdEnum.hasMoreElements()) {
            String subscriptionId = (String)subIdEnum.nextElement();
            Hashtable hash = (Hashtable)this.subscriptions.get(subscriptionId);
            sb.append(offset).append("  <subscribe id='").append(subscriptionId).append("'/>");
        }
        Enumeration queryEnum = this.query2SubId.keys();
        while (queryEnum.hasMoreElements()) {
            String query = (String)queryEnum.nextElement();
            String subscriptionId = (String)this.query2SubId.get(query);
            sb.append(offset).append("  <query id='").append(query);
            sb.append("' subscriptionId='").append(subscriptionId).append("'/>");
        }
        sb.append(offset).append("</SynchronousCache>");
        return sb.toString();
    }
}

