/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client;

import java.util.HashMap;
import java.util.Set;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.util.Global;

public final class UpdateDispatcher {
    private static final String ME = "UpdateDispatcher";
    private final Global glob;
    private final HashMap callbackMap;

    public UpdateDispatcher(Global glob) {
        this.glob = glob;
        this.callbackMap = new HashMap();
    }

    public synchronized void addCallback(String subscriptionId, I_Callback callback, boolean isPersistent) {
        if (subscriptionId == null) {
            throw new IllegalArgumentException("Null argument not allowed in addCallback: subscriptionId=" + subscriptionId + " callback=" + callback);
        }
        this.callbackMap.put(subscriptionId, new CallbackInfo(callback, isPersistent));
    }

    public synchronized I_Callback getCallback(String subscriptionId) {
        if (subscriptionId == null) {
            throw new IllegalArgumentException("The subscriptionId is null");
        }
        CallbackInfo info = (CallbackInfo)this.callbackMap.get(subscriptionId);
        return info == null ? null : info.callback;
    }

    public synchronized void ackSubscription(String subscriptionId) {
        if (subscriptionId == null) {
            throw new IllegalArgumentException("The subscriptionId is null");
        }
        CallbackInfo info = (CallbackInfo)this.callbackMap.get(subscriptionId);
        if (info != null) {
            info.ack = true;
        }
    }

    public synchronized I_Callback[] getCallbacks() {
        Set values = this.callbackMap.entrySet();
        if (values == null || values.size() < 1) {
            return new I_Callback[0];
        }
        CallbackInfo[] infoArr = values.toArray(new CallbackInfo[values.size()]);
        I_Callback[] cbArr = new I_Callback[infoArr.length];
        int i = 0;
        while (i < infoArr.length) {
            cbArr[i] = infoArr[i].callback;
            ++i;
        }
        return cbArr;
    }

    public synchronized String[] getSubscriptionIds() {
        Set keys = this.callbackMap.keySet();
        if (keys == null || keys.size() < 1) {
            return new String[0];
        }
        return keys.toArray(new String[keys.size()]);
    }

    public synchronized I_Callback removeCallback(String subscriptionId) {
        CallbackInfo info = (CallbackInfo)this.callbackMap.remove(subscriptionId);
        return info == null ? null : info.callback;
    }

    public synchronized int size() {
        return this.callbackMap.size();
    }

    public synchronized void clear() {
        this.callbackMap.clear();
    }

    public synchronized int clearAckNonPersistentSubscriptions() {
        String[] ids = this.getSubscriptionIds();
        int count = 0;
        int i = 0;
        while (i < ids.length) {
            CallbackInfo info = (CallbackInfo)this.callbackMap.get(ids[i]);
            if (info != null && info.ack && !info.isPersistent()) {
                this.callbackMap.remove(ids[i]);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public synchronized void clearNAKSubscriptions() {
        String[] ids = this.getSubscriptionIds();
        int i = 0;
        while (i < ids.length) {
            CallbackInfo info = (CallbackInfo)this.callbackMap.get(ids[i]);
            if (info != null && !info.ack) {
                this.callbackMap.remove(ids[i]);
            }
            ++i;
        }
    }

    class CallbackInfo {
        I_Callback callback;
        boolean persistent;
        boolean ack = false;

        CallbackInfo(I_Callback callback, boolean persistent) {
            this.callback = callback;
            this.persistent = persistent;
        }

        boolean isPersistent() {
            return this.persistent;
        }
    }
}

