/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client;

import java.io.IOException;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_ClientPlugin;
import org.xmlBlaster.client.ClientErrorHandler;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.PluginLoader;
import org.xmlBlaster.client.SynchronousCache;
import org.xmlBlaster.client.UpdateDispatcher;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.protocol.AbstractCallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.client.protocol.corba.CorbaConnection;
import org.xmlBlaster.client.protocol.rmi.RmiConnection;
import org.xmlBlaster.client.protocol.socket.SocketConnection;
import org.xmlBlaster.client.protocol.xmlrpc.XmlRpcConnection;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.client.queuemsg.MsgQueueConnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueDisconnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueEraseEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueGetEntry;
import org.xmlBlaster.client.queuemsg.MsgQueuePublishEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueSubscribeEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueUnSubscribeEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.dispatch.I_ConnectionStatusListener;
import org.xmlBlaster.util.error.I_MsgErrorHandler;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.ClientQueueProperty;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public class XmlBlasterAccess
extends AbstractCallbackExtended
implements I_XmlBlasterAccess,
I_ConnectionStatusListener {
    private String ME = "XmlBlasterAccess";
    private String serverNodeId = "xmlBlaster";
    private ConnectQos connectQos;
    private ConnectReturnQos connectReturnQos;
    private I_Queue clientQueue;
    private DispatchManager dispatchManager;
    private I_MsgErrorHandler msgErrorHandler;
    private I_ClientPlugin secPlgn;
    private I_CallbackServer cbServer;
    private final UpdateDispatcher updateDispatcher;
    private I_Callback updateListener;
    private I_ConnectionStateListener connectionListener;
    private SynchronousCache synchronousCache;
    private boolean disconnectInProgress;
    private boolean connectInProgress;
    private boolean isValid = true;

    public XmlBlasterAccess(Global glob) {
        super(glob == null ? Global.instance() : glob);
        if (this.glob.getNodeId() != null) {
            throw new IllegalArgumentException("XmlBlasterAccess can't be created with a engine.Global, please clone a org.xmlBlaster.util.Global to create me");
        }
        this.setServerNodeId(this.glob.getId());
        this.updateDispatcher = new UpdateDispatcher(this.glob);
    }

    public XmlBlasterAccess(String[] args) {
        super(new Global(args, true, false));
        this.setServerNodeId(this.glob.getId());
        this.updateDispatcher = new UpdateDispatcher(this.glob);
    }

    public synchronized void registerConnectionListener(I_ConnectionStateListener connectionListener) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Initializing registering connectionListener");
        }
        this.connectionListener = connectionListener;
    }

    public SynchronousCache createSynchronousCache(int size) {
        if (this.synchronousCache != null) {
            return this.synchronousCache;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Initializing synchronous cache: size=" + size);
        }
        this.synchronousCache = new SynchronousCache(this.glob, size);
        this.log.info(this.ME, "SynchronousCache has been initialized with size=" + size);
        return this.synchronousCache;
    }

    public void setClientErrorHandler(I_MsgErrorHandler msgErrorHandler) {
        this.msgErrorHandler = msgErrorHandler;
    }

    public ConnectReturnQos connect(ConnectQos qos, I_Callback updateListener) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "connect");
        }
        XmlBlasterAccess xmlBlasterAccess = this;
        synchronized (xmlBlasterAccess) {
            if (this.isConnected() || this.connectInProgress) {
                String text = "connect() rejected, you are connected already, please check your code";
                throw new XmlBlasterException(this.glob, ErrorCode.USER_CONNECT_MULTIPLE, this.ME, text);
            }
            this.connectInProgress = true;
            try {
                this.connectQos = qos == null ? new ConnectQos(this.glob) : qos;
                SessionName sn = this.getSessionName();
                if (sn != null) {
                    if (sn.isPubSessionIdUser()) {
                        this.glob.setId(sn.toString());
                    } else {
                        this.glob.setId(sn.toString() + System.currentTimeMillis());
                    }
                } else {
                    this.glob.setId(this.getLoginName() + System.currentTimeMillis());
                }
                this.updateListener = updateListener;
                this.initSecuritySettings(this.connectQos.getData().getClientPluginType(), this.connectQos.getData().getClientPluginVersion());
                this.ME = "XmlBlasterAccess-" + this.getId();
                try {
                    ClientQueueProperty prop = this.connectQos.getClientQueueProperty();
                    StorageId queueId = new StorageId("connection", this.getId());
                    this.clientQueue = this.glob.getQueuePluginManager().getPlugin(prop.getType(), prop.getVersion(), queueId, this.connectQos.getClientQueueProperty());
                    if (this.clientQueue == null) {
                        String text = "The client queue plugin is not found with this configuration, please check your connect QoS: " + prop.toXml();
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, text);
                    }
                    if (this.msgErrorHandler == null) {
                        this.msgErrorHandler = new ClientErrorHandler(this.glob, this);
                    }
                    this.dispatchManager = new DispatchManager(this.glob, this.msgErrorHandler, this.getSecurityPlugin(), this.clientQueue, this, this.connectQos.getAddresses());
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Switching to synchronous delivery mode ...");
                    }
                    this.dispatchManager.trySyncMode(true);
                    if (this.updateListener != null) {
                        this.createDefaultCbServer();
                    }
                    MsgQueueConnectEntry entry = new MsgQueueConnectEntry(this.glob, this.clientQueue.getStorageId(), this.connectQos.getData());
                    this.connectReturnQos = (ConnectReturnQos)this.queueMessage(entry);
                    this.connectReturnQos.getData().setInitialConnectionState(this.dispatchManager.getDispatchConnectionsHandler().getState());
                }
                catch (XmlBlasterException e) {
                    if (this.isConnected()) {
                        this.disconnect(null);
                    }
                    throw e;
                }
                catch (Throwable e) {
                    if (this.isConnected()) {
                        this.disconnect(null);
                    }
                    throw XmlBlasterException.convert(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Connection failed", e);
                }
                Object var9_14 = null;
                this.connectInProgress = false;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                this.connectInProgress = false;
                throw throwable;
            }
        }
        if (this.isAlive()) {
            if (this.connectionListener != null) {
                this.connectionListener.reachedAlive(ConnectionStateEnum.UNDEF, this);
            }
            this.log.info(this.ME, "Successful " + this.connectQos.getAddress().getType() + " login as " + this.getId());
            if (this.clientQueue.getNumOfEntries() > 0L) {
                long num = this.clientQueue.getNumOfEntries();
                this.log.info(this.ME, "Sending now our " + num + " client side queued tail back messages");
                this.dispatchManager.switchToASyncMode();
                while (this.clientQueue.getNumOfEntries() > 0L) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException i) {
                        // empty catch block
                    }
                }
                this.log.info(this.ME, num - this.clientQueue.getNumOfEntries() + " client side queued tail back messages sent");
                this.dispatchManager.switchToSyncMode();
            }
        } else {
            if (this.connectionListener != null) {
                this.connectionListener.reachedPolling(ConnectionStateEnum.UNDEF, this);
            }
            this.log.info(this.ME, "Login request as " + this.getId() + " is queued");
        }
        return this.connectReturnQos;
    }

    public boolean isConnected() {
        return this.connectReturnQos != null;
    }

    public void refreshSession() throws XmlBlasterException {
        GetKey gk = new GetKey(this.glob, "__refresh");
        GetQos gq = new GetQos(this.glob);
        this.get(gk, gq);
    }

    private void createDefaultCbServer() throws XmlBlasterException {
        CbQueueProperty prop = this.connectQos.getSessionCbQueueProperty();
        CallbackAddress addr = prop.getCurrentCallbackAddress();
        if (addr == null) {
            addr = new CallbackAddress(this.glob);
        }
        this.cbServer = this.initCbServer(this.getLoginName(), addr);
        addr.setType(this.cbServer.getCbProtocol());
        addr.setRawAddress(this.cbServer.getCbAddress());
        prop.setCallbackAddress(addr);
        this.log.info(this.ME, "Callback settings: " + prop.getSettings());
    }

    public I_CallbackServer initCbServer(String loginName, CallbackAddress callbackAddress) throws XmlBlasterException {
        if (callbackAddress == null) {
            callbackAddress = new CallbackAddress(this.glob);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Using 'client.cbProtocol=" + callbackAddress.getType() + "' to be used by " + this.getServerNodeId() + ", trying to create the callback server ...");
        }
        I_CallbackServer server = this.glob.getCbServerPluginManager().getPlugin(callbackAddress.getType(), callbackAddress.getVersion());
        server.initialize(this.glob, loginName, callbackAddress, this);
        return server;
    }

    private void initSecuritySettings(String secMechanism, String secVersion) {
        PluginLoader secPlgnMgr = this.glob.getClientSecurityPluginLoader();
        try {
            this.secPlgn = secPlgnMgr.getClientPlugin(secMechanism, secVersion);
            if (secMechanism != null) {
                this.log.info(this.ME, "Loaded security plugin=" + secMechanism + " version=" + secVersion);
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Security plugin '" + secMechanism + "/" + secVersion + "' initialization failed. Reason: " + e.getMessage());
            this.secPlgn = null;
        }
    }

    public I_ClientPlugin getSecurityPlugin() {
        return this.secPlgn;
    }

    public synchronized boolean disconnect(DisconnectQos disconnectQos) {
        if (!this.isValid) {
            return false;
        }
        if (this.connectQos == null) {
            this.log.warn(this.ME, "You called disconnect() but you are are not logged in, we ignore it.");
            return false;
        }
        if (disconnectQos == null) {
            disconnectQos = new DisconnectQos(this.glob);
        }
        if (!disconnectQos.getClearClientQueueProp().isModified()) {
            boolean clearClientQueue = true;
            if (this.connectQos != null && this.connectQos.getSessionName().isPubSessionIdUser()) {
                clearClientQueue = false;
            }
            disconnectQos.clearClientQueue(clearClientQueue);
        }
        return this.shutdown(disconnectQos);
    }

    private synchronized boolean shutdown(DisconnectQos disconnectQos) {
        if (this.disconnectInProgress) {
            this.log.warn(this.ME, "Calling disconnect again is ignored, you are in shutdown progress already");
            return false;
        }
        this.disconnectInProgress = true;
        if (disconnectQos == null) {
            disconnectQos = new DisconnectQos(this.glob);
        }
        if (this.isConnected()) {
            long remainingEntries;
            if (this.clientQueue != null && (remainingEntries = this.clientQueue.getNumOfEntries()) > 0L) {
                if (disconnectQos.clearClientQueue()) {
                    this.log.warn(this.ME, "You called disconnect(). Please note that there are " + remainingEntries + " unsent invocations/messages in the queue which are discarded now.");
                } else {
                    this.log.info(this.ME, "You called disconnect(). Please note that there are " + remainingEntries + " unsent invocations/messages in the queue which are sent on next connect of the same client with the same public session ID.");
                }
            }
            String[] subscriptionIdArr = this.updateDispatcher.getSubscriptionIds();
            int ii = 0;
            while (ii < subscriptionIdArr.length) {
                String subscriptionId = subscriptionIdArr[ii];
                UnSubscribeKey key = new UnSubscribeKey(this.glob, subscriptionId);
                try {
                    this.unSubscribe(key, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isCommunication()) break;
                    this.log.warn(this.ME + ".logout", "Couldn't unsubscribe '" + subscriptionId + "' : " + e.getMessage());
                }
                ++ii;
            }
            this.updateDispatcher.clear();
            if (this.clientQueue != null) {
                try {
                    MsgQueueDisconnectEntry entry = new MsgQueueDisconnectEntry(this.glob, this.clientQueue.getStorageId(), disconnectQos);
                    this.queueMessage(entry);
                    this.log.info(this.ME, "Successful disconnect from " + this.getServerNodeId());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.log.warn(this.ME + ".disconnect()", e.toString());
                }
            }
        }
        if (this.synchronousCache != null) {
            this.synchronousCache.clear();
        }
        if (this.clientQueue != null && disconnectQos.clearClientQueue()) {
            this.clientQueue.clear();
        }
        if (disconnectQos.shutdownDispatcher()) {
            if (this.dispatchManager != null) {
                this.dispatchManager.shutdown();
                this.dispatchManager = null;
            }
            if (this.clientQueue != null) {
                this.clientQueue.shutdown();
                this.clientQueue = null;
            }
        }
        if (disconnectQos.shutdownCbServer() && this.cbServer != null) {
            try {
                this.cbServer.shutdown();
                this.cbServer = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.warn(this.ME + ".disconnect()", e.toString());
            }
        }
        if (this.secPlgn != null) {
            this.secPlgn = null;
        }
        this.connectQos = null;
        this.connectReturnQos = null;
        this.disconnectInProgress = false;
        this.msgErrorHandler = null;
        this.updateListener = null;
        this.glob.shutdown();
        return true;
    }

    public I_CallbackServer getCbServer() {
        return this.cbServer;
    }

    public String getId() {
        SessionName sessionName = this.getSessionName();
        return sessionName == null ? "UNKNOWN_SESSION" : sessionName.getAbsoluteName();
    }

    public SessionName getSessionName() {
        if (this.connectReturnQos != null) {
            return this.connectReturnQos.getSessionName();
        }
        if (this.connectQos != null) {
            return this.connectQos.getSessionName();
        }
        return null;
    }

    public String getLoginName() {
        String nm;
        if (this.connectQos != null && this.connectQos.getSecurityQos() != null && (nm = this.connectQos.getSecurityQos().getUserId()) != null && nm.length() > 0) {
            return nm;
        }
        return this.glob.getId();
    }

    public void setServerNodeId(String nodeId) {
        this.serverNodeId = nodeId;
    }

    public String getServerNodeId() {
        return this.serverNodeId;
    }

    private Object queueMessage(MsgQueueEntry entry) throws XmlBlasterException {
        try {
            this.clientQueue.put(entry, false);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Forwarded one '" + entry.getEmbeddedType() + "' message, current state is " + this.getState().toString());
            }
            return entry.getReturnObj();
        }
        catch (Throwable e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, e.toString());
            }
            XmlBlasterException xmlBlasterException = XmlBlasterException.convert(this.glob, null, null, e);
            throw xmlBlasterException;
        }
    }

    private void queueMessage(MsgQueueEntry[] entries) throws XmlBlasterException {
        try {
            this.clientQueue.put(entries, false);
        }
        catch (Throwable e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, e.toString());
            }
            XmlBlasterException xmlBlasterException = XmlBlasterException.convert(this.glob, null, null, e);
            throw xmlBlasterException;
        }
    }

    public SubscribeReturnQos subscribe(String xmlKey, String qos) throws XmlBlasterException {
        return this.subscribe(new SubscribeKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new SubscribeQos(this.glob, this.glob.getQueryQosFactory().readObject(qos)));
    }

    public SubscribeReturnQos subscribe(SubscribeKey subscribeKey, SubscribeQos subscribeQos) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "subscribe");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        MsgQueueSubscribeEntry entry = new MsgQueueSubscribeEntry(this.glob, this.clientQueue.getStorageId(), subscribeKey.getData(), subscribeQos.getData());
        return (SubscribeReturnQos)this.queueMessage(entry);
    }

    public SubscribeReturnQos subscribe(String xmlKey, String qos, I_Callback cb) throws XmlBlasterException {
        return this.subscribe(new SubscribeKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new SubscribeQos(this.glob, this.glob.getQueryQosFactory().readObject(qos)), cb);
    }

    public SubscribeReturnQos subscribe(SubscribeKey subscribeKey, SubscribeQos subscribeQos, I_Callback cb) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "subscribe");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        if (this.updateListener == null) {
            String text = "No callback listener is registered.  Please use XmlBlasterAccess.connect() with default I_Callback given.";
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, text);
        }
        UpdateDispatcher updateDispatcher = this.updateDispatcher;
        synchronized (updateDispatcher) {
            SubscribeReturnQos subscribeReturnQos = this.subscribe(subscribeKey, subscribeQos);
            this.updateDispatcher.addCallback(subscribeReturnQos.getSubscriptionId(), cb, subscribeQos.getPersistent());
            if (!subscribeReturnQos.isFakedReturn()) {
                this.updateDispatcher.ackSubscription(subscribeReturnQos.getSubscriptionId());
            }
            SubscribeReturnQos subscribeReturnQos2 = subscribeReturnQos;
            return subscribeReturnQos2;
        }
    }

    public MsgUnit[] get(String xmlKey, String qos) throws XmlBlasterException {
        return this.get(new GetKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new GetQos(this.glob, this.glob.getQueryQosFactory().readObject(qos)));
    }

    public MsgUnit[] getCached(GetKey getKey, GetQos getQos) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "getCached");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        if (this.synchronousCache == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Can't handle getCached(), please install a cache with createSynchronousCache() first");
        }
        MsgUnit[] msgUnitArr = null;
        msgUnitArr = this.synchronousCache.get(getKey, getQos);
        this.log.info(this.ME, "CHACHE msgUnitArr=" + msgUnitArr + ": '" + getKey.toXml().trim() + "' \n" + getQos.toXml() + this.synchronousCache.toXml(""));
        if (msgUnitArr == null) {
            msgUnitArr = this.get(getKey, getQos);
            SubscribeKey subscribeKey = new SubscribeKey(this.glob, getKey.getData());
            SubscribeQos subscribeQos = new SubscribeQos(this.glob, getQos.getData());
            SubscribeReturnQos subscribeReturnQos = null;
            SynchronousCache synchronousCache = this.synchronousCache;
            synchronized (synchronousCache) {
                subscribeReturnQos = this.subscribe(subscribeKey, subscribeQos);
                this.synchronousCache.newEntry(subscribeReturnQos.getSubscriptionId(), getKey, msgUnitArr);
            }
            this.log.info(this.ME, "New entry in this.synchronousCache created (subscriptionId=" + subscribeReturnQos.getSubscriptionId() + ")");
        }
        return msgUnitArr;
    }

    public MsgUnit[] get(GetKey getKey, GetQos getQos) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "get");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        MsgQueueGetEntry entry = new MsgQueueGetEntry(this.glob, this.clientQueue.getStorageId(), getKey, getQos);
        return (MsgUnit[])this.queueMessage(entry);
    }

    public UnSubscribeReturnQos[] unSubscribe(UnSubscribeKey unSubscribeKey, UnSubscribeQos unSubscribeQos) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "unSubscribe");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        MsgQueueUnSubscribeEntry entry = new MsgQueueUnSubscribeEntry(this.glob, this.clientQueue.getStorageId(), unSubscribeKey, unSubscribeQos);
        UnSubscribeReturnQos[] arr = (UnSubscribeReturnQos[])this.queueMessage(entry);
        this.updateDispatcher.removeCallback(unSubscribeKey.getOid());
        return arr == null ? new UnSubscribeReturnQos[]{} : arr;
    }

    public UnSubscribeReturnQos[] unSubscribe(String xmlKey, String qos) throws XmlBlasterException {
        return this.unSubscribe(new UnSubscribeKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new UnSubscribeQos(this.glob, this.glob.getQueryQosFactory().readObject(qos)));
    }

    public PublishReturnQos publish(MsgUnit msgUnit) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "publish");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        MsgQueuePublishEntry entry = new MsgQueuePublishEntry(this.glob, msgUnit, this.clientQueue.getStorageId());
        return (PublishReturnQos)this.queueMessage(entry);
    }

    public void publishOneway(MsgUnit[] msgUnitArr) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "publishOneway");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        boolean ONEWAY = true;
        int ii = 0;
        while (ii < msgUnitArr.length) {
            MsgQueuePublishEntry entry = new MsgQueuePublishEntry(this.glob, msgUnitArr[ii], this.clientQueue.getStorageId(), true);
            this.queueMessage(entry);
            ++ii;
        }
    }

    public PublishReturnQos[] publishArr(MsgUnit[] msgUnitArr) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "publishArr");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        this.log.warn(this.ME, "Publishing arrays is not atomic implemented - TODO");
        PublishReturnQos[] retQos = new PublishReturnQos[msgUnitArr.length];
        int ii = 0;
        while (ii < msgUnitArr.length) {
            MsgQueuePublishEntry entry = new MsgQueuePublishEntry(this.glob, msgUnitArr[ii], this.clientQueue.getStorageId());
            retQos[ii] = (PublishReturnQos)this.queueMessage(entry);
            ++ii;
        }
        return retQos;
    }

    public EraseReturnQos[] erase(EraseKey eraseKey, EraseQos eraseQos) throws XmlBlasterException {
        if (!this.isValid) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "erase");
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_NOT_CONNECTED, this.ME);
        }
        MsgQueueEraseEntry entry = new MsgQueueEraseEntry(this.glob, this.clientQueue.getStorageId(), eraseKey, eraseQos);
        EraseReturnQos[] arr = (EraseReturnQos[])this.queueMessage(entry);
        return arr == null ? new EraseReturnQos[]{} : arr;
    }

    public EraseReturnQos[] erase(String xmlKey, String qos) throws XmlBlasterException {
        return this.erase(new EraseKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new EraseQos(this.glob, this.glob.getQueryQosFactory().readObject(qos)));
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        Object object;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering update(updateKey=" + updateKey.getOid() + ", subscriptionId=" + updateQos.getSubscriptionId() + ", " + (this.synchronousCache != null ? "using synchronousCache" : "no synchronousCache") + ") ...");
        }
        if (this.synchronousCache != null) {
            boolean retVal;
            object = this.synchronousCache;
            synchronized (object) {
                retVal = this.synchronousCache.update(updateQos.getSubscriptionId(), updateKey, content, updateQos);
            }
            if (retVal) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Putting update message " + updateQos.getSubscriptionId() + " into cache");
                }
                return "<qos><state id='OK'/></qos>";
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Update message " + updateQos.getSubscriptionId() + " is not for cache");
            }
        }
        I_Callback obj = null;
        object = this.updateDispatcher;
        synchronized (object) {
            obj = this.updateDispatcher.getCallback(updateQos.getSubscriptionId());
        }
        if (obj != null) {
            I_Callback cb = obj;
            return cb.update(cbSessionId, updateKey, content, updateQos);
        }
        if (this.updateListener != null) {
            return this.updateListener.update(cbSessionId, updateKey, content, updateQos);
        }
        this.log.error(this.ME, "Ignoring unexpected update message: " + updateKey.toXml() + "" + updateQos.toXml());
        return "<qos><state id='OK'/></qos>";
    }

    public void toAlive(DispatchManager dispatchManager, ConnectionStateEnum oldState) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Changed from connection state " + oldState + " to " + ConnectionStateEnum.ALIVE + " connectInProgress=" + this.connectInProgress);
        }
        if (this.clientQueue != null && this.clientQueue.getNumOfEntries() > 0L) {
            this.log.info(this.ME, "Changed from connection state " + oldState + " to " + ConnectionStateEnum.ALIVE + " connectInProgress=" + this.connectInProgress + " with " + this.clientQueue.getNumOfEntries() + " client side queued messages");
        }
        if (this.connectInProgress) {
            dispatchManager.trySyncMode(true);
            if (this.clientQueue != null && this.clientQueue.getNumOfEntries() > 0L) {
                try {
                    MsgQueueEntry entry = (MsgQueueEntry)this.clientQueue.peek();
                    if (entry.getMethodName() == MethodName.CONNECT) {
                        this.clientQueue.remove();
                        this.log.info(this.ME, "Removed queued connect message, our new connect has precedence");
                    }
                }
                catch (XmlBlasterException e) {
                    this.log.error(this.ME, "Removing connect entry in client tail back queue failed: " + e.getMessage() + "\n" + this.toXml());
                }
            }
            return;
        }
        if (this.connectReturnQos == null || !this.connectReturnQos.isReconnected()) {
            this.cleanupForNewServer();
        }
        if (this.connectionListener != null) {
            this.connectionListener.reachedAlive(oldState, this);
        }
    }

    private void cleanupForNewServer() {
        int num;
        if (this.updateDispatcher.size() > 0 && (num = this.updateDispatcher.clearAckNonPersistentSubscriptions()) > 0) {
            this.log.info(this.ME, "Removed " + num + " subscribe specific callback registrations");
        }
        if (this.synchronousCache != null) {
            this.synchronousCache.clear();
        }
    }

    public void toPolling(DispatchManager dispatchManager, ConnectionStateEnum oldState) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Changed from connection state " + oldState + " to " + ConnectionStateEnum.POLLING + " connectInProgress=" + this.connectInProgress);
        }
        if (this.connectInProgress) {
            return;
        }
        if (this.connectionListener != null) {
            this.connectionListener.reachedPolling(oldState, this);
        }
    }

    public void toDead(DispatchManager dispatchManager, ConnectionStateEnum oldState, String errorText) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD + " connectInProgress=" + this.connectInProgress);
        }
        if (this.connectionListener != null) {
            this.connectionListener.reachedDead(oldState, this);
        }
    }

    public Global getGlobal() {
        return this.glob;
    }

    public I_Queue getQueue() {
        return this.clientQueue;
    }

    public ConnectionStateEnum getState() {
        if (!this.isConnected()) {
            return ConnectionStateEnum.UNDEF;
        }
        return this.dispatchManager.getDispatchConnectionsHandler().getState();
    }

    public boolean isAlive() {
        if (!this.isConnected()) {
            return false;
        }
        return this.dispatchManager.getDispatchConnectionsHandler().isAlive();
    }

    public boolean isPolling() {
        if (!this.isConnected()) {
            return false;
        }
        return this.dispatchManager.getDispatchConnectionsHandler().isPolling();
    }

    public boolean isDead() {
        if (!this.isConnected()) {
            return false;
        }
        return this.dispatchManager.getDispatchConnectionsHandler().isDead();
    }

    public ConnectReturnQos getConnectReturnQos() {
        return this.connectReturnQos;
    }

    public ConnectQos getConnectQos() {
        return this.connectQos;
    }

    public void leaveServer(Map map) {
        if (!this.isValid) {
            return;
        }
        XmlBlasterAccess xmlBlasterAccess = this;
        synchronized (xmlBlasterAccess) {
            this.isValid = false;
            if (this.cbServer != null) {
                try {
                    this.cbServer.shutdown();
                }
                catch (XmlBlasterException ex) {
                    ex.printStackTrace();
                    this.log.error(this.ME, "could not leave the server properly: " + ex.getMessage());
                }
                this.cbServer = null;
            }
            if (this.dispatchManager != null) {
                // empty if block
            }
        }
    }

    public static String usage(Global glob) {
        glob = glob == null ? Global.instance() : glob;
        StringBuffer sb = new StringBuffer(4096);
        sb.append("\n");
        sb.append("Choose a connection protocol:\n");
        sb.append("   -protocol           Specify a protocol to talk with xmlBlaster, 'SOCKET' or 'IOR' or 'RMI' or 'SOAP' or 'XMLRPC'.\n");
        sb.append("                       This is used for connection to xmlBlaster and for the callback connection.\n");
        sb.append("                       Current setting is '" + glob.getProperty().get("client.protocol", "IOR") + "'. See below for protocol settings.\n");
        sb.append("   -dispatch/connection/protocol <protocol>\n");
        sb.append("                       Specify the protocol to connect to xmlBlaster only (not for the callback).\n");
        sb.append("   -dispatch/callback/protocol <protocol>\n");
        sb.append("                       Specify the protocol for the callback connection only.\n");
        sb.append("              Example: java MyApp -protocol SOCKET\n");
        sb.append("                       java MyApp -dispatch/connection/protocol RMI -dispatch/connection/plugin/rmi/hostname 192.168.10.34\n");
        sb.append("                       java MyApp -dispatch/connection/protocol RMI -dispatch/callback/protocol XMLRPC\n");
        sb.append("\n");
        sb.append("Security features:\n");
        sb.append("   -Security.Client.DefaultPlugin \"gui,1.0\"\n");
        sb.append("                       Force the given authentication schema, here the GUI is enforced\n");
        sb.append("                       Clients can overwrite this with ConnectQos.java\n");
        sb.append(new ConnectQos(glob).usage());
        sb.append(new Address(glob).usage());
        sb.append(new ClientQueueProperty(glob, null).usage());
        sb.append(new CallbackAddress(glob).usage());
        sb.append(new CbQueueProperty(glob, null, null).usage());
        sb.append(new HistoryQueueProperty(glob, null).usage("Control the default size of the history queue for each topic (send with publish calls)"));
        sb.append(SocketConnection.usage());
        sb.append(CorbaConnection.usage());
        sb.append(RmiConnection.usage());
        sb.append(XmlRpcConnection.usage());
        return sb.toString();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<XmlBlasterAccess id='").append(this.getId());
        if (this.dispatchManager != null && this.dispatchManager.getDispatchConnectionsHandler() != null) {
            sb.append("' state='").append(this.dispatchManager.getDispatchConnectionsHandler().getState());
        }
        sb.append("'>");
        sb.append(offset).append(" <connected>").append(this.isConnected()).append("</connected>");
        sb.append(offset).append("</XmlBlasterAccess>");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            String ME = "XmlBlasterAccess-Test";
            Global glob = new Global(args);
            final LogChannel log = glob.getLog("client");
            String oid = "HelloWorld";
            I_XmlBlasterAccess xmlBlasterAccess = glob.getXmlBlasterAccess();
            xmlBlasterAccess.registerConnectionListener(new I_ConnectionStateListener(){

                public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                    log.error("XmlBlasterAccess-Test", "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.ALIVE + " with " + connection.getQueue().getNumOfEntries() + " queue entries pending");
                }

                public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                    log.error("XmlBlasterAccess-Test", "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.POLLING);
                }

                public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                    log.error("XmlBlasterAccess-Test", "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
                }
            });
            ConnectReturnQos connectReturnQos = xmlBlasterAccess.connect(null, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    log.info("XmlBlasterAccess-Test", "UPDATE: Receiving asynchronous callback message " + updateKey.toXml() + "\n" + updateQos.toXml());
                    return "";
                }
            });
            if (xmlBlasterAccess.isAlive()) {
                log.info("", "Successfully connected to xmlBlaster");
            } else {
                log.info("", "We continue in fail safe mode: " + connectReturnQos.toXml());
            }
            log.info("XmlBlasterAccess-Test", "Hit a key to subscribe on topic HelloWorld");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            SubscribeKey sk = new SubscribeKey(glob, "HelloWorld");
            SubscribeQos sq = new SubscribeQos(glob);
            SubscribeReturnQos subRet = xmlBlasterAccess.subscribe(sk, sq);
            log.info("XmlBlasterAccess-Test", "Subscribed for " + sk.toXml() + "\n" + sq.toXml() + " return:\n" + subRet.toXml());
            log.info("XmlBlasterAccess-Test", "Hit a key to publish 'HelloWorld'");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            MsgUnit msgUnit = new MsgUnit(glob, "<key oid='HelloWorld'/>", "Hi".getBytes(), "<qos><persistent>true</persistent></qos>");
            PublishReturnQos publishReturnQos = xmlBlasterAccess.publish(msgUnit);
            log.info("XmlBlasterAccess-Test", "Successfully published message to xmlBlaster, msg=" + msgUnit.toXml() + "\n returned QoS=" + publishReturnQos.toXml());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            log.info("XmlBlasterAccess-Test", "Hit a key to 3 times publishOneway 'HelloWorld'");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            MsgUnit[] msgUnitArr = new MsgUnit[]{new MsgUnit(glob, "<key oid='HelloWorld'/>", "Hi".getBytes(), "<qos><persistent>true</persistent></qos>"), new MsgUnit(glob, "<key oid='HelloWorld'/>", "Hi".getBytes(), "<qos><persistent>true</persistent></qos>"), new MsgUnit(glob, "<key oid='HelloWorld'/>", "Hi".getBytes(), "<qos><persistent>true</persistent></qos>")};
            xmlBlasterAccess.publishOneway(msgUnitArr);
            log.info("XmlBlasterAccess-Test", "Successfully published " + msgUnitArr.length + " messages oneway");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            log.info("XmlBlasterAccess-Test", "Hit a key to 3 times publishArr 'HelloWorld'");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            msgUnitArr = new MsgUnit[]{new MsgUnit(glob, "<key oid='HelloWorld'/>", "Hi".getBytes(), "<qos><persistent>true</persistent></qos>"), new MsgUnit(glob, "<key oid='HelloWorld'/>", "Hi".getBytes(), "<qos><persistent>true</persistent></qos>"), new MsgUnit(glob, "<key oid='HelloWorld'/>", "Hi".getBytes(), "<qos><persistent>true</persistent></qos>")};
            PublishReturnQos[] retArr = xmlBlasterAccess.publishArr(msgUnitArr);
            log.info("XmlBlasterAccess-Test", "Successfully published " + retArr.length + " acknowledged messages");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            log.info("XmlBlasterAccess-Test", "Hit a key to get 'HelloWorld'");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            GetKey gk = new GetKey(glob, "HelloWorld");
            GetQos gq = new GetQos(glob);
            MsgUnit[] msgs = xmlBlasterAccess.get(gk, gq);
            log.info("XmlBlasterAccess-Test", "Successfully got message from xmlBlaster, msg=" + msgs[0].toXml());
            int numGetCached = 4;
            SynchronousCache syncCache = xmlBlasterAccess.createSynchronousCache(100);
            int i = 0;
            while (i < numGetCached) {
                log.info("XmlBlasterAccess-Test", "Hit a key to getCached 'HelloWorld' #" + i + "/" + numGetCached);
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    // empty catch block
                }
                GetKey gk2 = new GetKey(glob, "HelloWorld");
                GetQos gq2 = new GetQos(glob);
                MsgUnit[] msgs2 = xmlBlasterAccess.getCached(gk2, gq2);
                log.info("XmlBlasterAccess-Test", "Successfully got message from xmlBlaster, msg=" + msgs2[0].toXml());
                ++i;
            }
            log.info("XmlBlasterAccess-Test", "Hit a key to unSubscribe on topic 'HelloWorld' and '" + subRet.getSubscriptionId() + "'");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            UnSubscribeKey uk = new UnSubscribeKey(glob, subRet.getSubscriptionId());
            UnSubscribeQos uq = new UnSubscribeQos(glob);
            UnSubscribeReturnQos[] unSubRet = xmlBlasterAccess.unSubscribe(uk, uq);
            log.info("XmlBlasterAccess-Test", "UnSubscribed for " + uk.toXml() + "\n" + uq.toXml() + " return:\n" + unSubRet[0].toXml());
            log.info("XmlBlasterAccess-Test", "Hit a key to erase on topic HelloWorld");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            EraseKey ek = new EraseKey(glob, "HelloWorld");
            EraseQos eq = new EraseQos(glob);
            EraseReturnQos[] er = xmlBlasterAccess.erase(ek, eq);
            log.info("XmlBlasterAccess-Test", "Erased for " + ek.toXml() + "\n" + eq.toXml() + " return:\n" + er[0].toXml());
            int numPublish = 10;
            int ii = 0;
            while (ii < numPublish) {
                log.info("XmlBlasterAccess-Test", "Hit a key to publish #" + (ii + 1) + "/" + numPublish);
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    // empty catch block
                }
                MsgUnit msgUnit2 = new MsgUnit(glob, "<key oid=''/>", ("Hi #" + (ii + 1)).getBytes(), "<qos><persistent>true</persistent></qos>");
                PublishReturnQos publishReturnQos2 = xmlBlasterAccess.publish(msgUnit2);
                log.info("XmlBlasterAccess-Test", "Successfully published message #" + (ii + 1) + " to xmlBlaster, msg=" + msgUnit2.toXml() + "\n returned QoS=" + publishReturnQos2.toXml());
                ++ii;
            }
            log.info("XmlBlasterAccess-Test", "Hit a key to disconnect ...");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            xmlBlasterAccess.disconnect(null);
        }
        catch (XmlBlasterException xmlBlasterException) {
            System.out.println("WARNING: Test failed: " + xmlBlasterException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR: Test failed: " + e.toString());
        }
        System.exit(0);
    }
}

