/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client;

import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Destination;

public class XmlDbMessageWrapper {
    private final Global glob;
    private static String ME = "XmlDbMessageWrapper";
    private String content;
    private String user = null;
    private String passwd = null;
    private String url = null;

    public XmlDbMessageWrapper(Global glob, String user, String passwd, String url) {
        this.glob = glob;
        this.user = user;
        this.passwd = passwd;
        this.url = url;
    }

    public void initQuery(int limit, boolean confirm, String queryStr) {
        this.init("query", limit, confirm, queryStr);
    }

    public void initUpdate(boolean confirm, String updateStr) {
        this.init("update", 1, confirm, updateStr);
    }

    public void init(String type, int limit, boolean confirm, String queryStr) {
        if (type.equalsIgnoreCase("insert") || type.equalsIgnoreCase("delete")) {
            type = "update";
        }
        StringBuffer tmp = new StringBuffer();
        tmp.append("<database:adapter xmlns:database='http://www.xmlBlaster.org/jdbc'>");
        tmp.append(" <database:url>").append(this.url).append("</database:url>");
        tmp.append(" <database:username>").append(this.user).append("</database:username>");
        tmp.append(" <database:password>").append(this.passwd).append("</database:password>");
        tmp.append(" <database:interaction type='").append(type).append("'/>");
        tmp.append(" <database:command><![CDATA[").append(queryStr).append("]]></database:command>");
        tmp.append(" <database:connectionlifespan ttl='1'/>");
        tmp.append(" <database:rowlimit max='").append(limit).append("'/>");
        tmp.append(" <database:confirmation confirm='").append(confirm).append("'/>");
        tmp.append("</database:adapter>");
        this.content = tmp.toString();
    }

    public String toXml() throws XmlBlasterException {
        if (this.content == null) {
            throw new XmlBlasterException(ME, "Please use init() method before calling toXml().");
        }
        return this.content;
    }

    public MsgUnit toMessage() throws XmlBlasterException {
        PublishQos qos = new PublishQos(this.glob, new Destination(new SessionName(Global.instance(), "__sys__jdbc")));
        PublishKey key = new PublishKey(this.glob, "", "text/xml", "SQL_QUERY");
        return new MsgUnit(key, this.toXml().getBytes(), qos);
    }
}

