/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.activex;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.beans.SimpleBeanInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Properties;
import org.jutils.JUtilsException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.SynchronousCache;
import org.xmlBlaster.client.activex.UpdateEvent;
import org.xmlBlaster.client.activex.UpdateListener;
import org.xmlBlaster.client.activex.UpdateMsgUnit;
import org.xmlBlaster.client.activex.XmlScriptAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.client.script.XmlScriptInterpreter;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class XmlScriptAccess
extends SimpleBeanInfo
implements I_Callback {
    private static String ME = "XmlScriptAccess";
    private final Global glob = new Global();
    private final LogChannel log = this.glob.getLog("XmlScriptAccess");
    private XmlScriptInterpreter interpreter;
    private Reader reader;
    private OutputStream outStream;
    private UpdateListener updateListener;
    private Latch updateReturnLatch;
    private String updateReturnQos;
    private XmlBlasterException updateReturnException;
    private long responseWaitTime = this.glob.getProperty().get("client/activex/responseWaitTime", 600000L);

    public XmlScriptAccess() {
        String protocol;
        if (this.log.CALL) {
            this.log.call(ME, "Calling ctor of XmlScriptAccess, responseWaitTime=" + this.responseWaitTime);
        }
        if ("".equals(protocol = this.glob.getProperty().get("protocol", ""))) {
            try {
                this.glob.getProperty().set("protocol", "SOCKET");
            }
            catch (JUtilsException e) {
                this.log.error(ME, "Failed setting SOCKET protocol, we continue nevertheless: " + e.toString());
            }
        }
    }

    public void addUpdateListener(UpdateListener updateListener) {
        this.log.info(ME, "Registering update listener");
        if (this.log.DUMP) {
            Thread.dumpStack();
        }
        this.updateListener = updateListener;
    }

    public void removeUpdateListener(UpdateListener updateListener) {
        this.log.info(ME, "Removing update listener");
        if (this.log.DUMP) {
            Thread.dumpStack();
        }
        this.updateListener = null;
    }

    protected synchronized String notifyUpdateEvent(String cbSessionId, UpdateKey key, byte[] content, UpdateQos qos) throws XmlBlasterException {
        if (this.updateListener == null) {
            this.log.warn(ME, "No updateListener is registered, ignoring " + key.toXml());
            return "<qos><state id='WARNING'/></qos>";
        }
        UpdateEvent ev = new UpdateEvent(this, cbSessionId, key, content, qos);
        if (this.log.TRACE) {
            this.log.trace(ME, "Notifying updateListener with new message " + key.toXml());
        }
        this.updateReturnLatch = new Latch();
        this.updateListener.update(ev);
        boolean awaikened = false;
        while (true) {
            try {
                if (this.log.TRACE) {
                    this.log.trace(ME, "notifyUpdateEvent() Entering wait ...");
                }
                awaikened = this.updateReturnLatch.attempt(this.responseWaitTime);
            }
            catch (InterruptedException e) {
                this.log.warn(ME, "Waking up (waited on " + key.getOid() + " update response): " + e.toString());
                continue;
            }
            break;
        }
        try {
            if (awaikened) {
                if (this.updateReturnQos != null) {
                    if (this.log.TRACE) {
                        this.log.trace(ME, "Notifying updateListener done: returned '" + this.updateReturnQos + "'");
                    }
                    String e = this.updateReturnQos;
                    Object var9_10 = null;
                    this.updateReturnLatch = null;
                    return e;
                }
                if (this.updateReturnException != null) {
                    this.log.warn(ME, "Update failed: " + this.updateReturnException.getMessage());
                    throw this.updateReturnException;
                }
                this.log.error(ME, "Update failed, no return available");
                throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, ME, "Update to ActiveX failed, no return available");
            }
            String str = "Timeout of " + this.responseWaitTime + " milliseconds occured when waiting on " + key.getOid() + " return value";
            this.log.warn(ME, str);
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, ME, str);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.updateReturnLatch = null;
            throw throwable;
        }
    }

    public void setUpdateReturn(String updateReturnQos) {
        if (this.updateReturnLatch == null) {
            this.log.warn(ME, "Ignoring setUpdateReturn(), updateReturnLatch == null, probably a timeout occurred");
            return;
        }
        this.updateReturnQos = updateReturnQos;
        this.updateReturnException = null;
        this.updateReturnLatch.release();
        if (this.log.CALL) {
            this.log.call(ME, "setUpdateReturn() called");
        }
    }

    public void setUpdateException(String errorCode, String message) {
        if (this.updateReturnLatch == null) {
            this.log.warn(ME, "Ignoring setUpdateException(), updateReturnLatch == null, probably a timeout occurred");
            return;
        }
        this.updateReturnQos = null;
        ErrorCode code = null;
        try {
            code = ErrorCode.toErrorCode(errorCode);
        }
        catch (IllegalArgumentException e) {
            this.log.warn(ME, "Don't know error code '" + errorCode + "', changing it to " + ErrorCode.USER_UPDATE_ERROR.toString());
            message = message + ": original errorCode=" + errorCode;
            code = ErrorCode.USER_UPDATE_ERROR;
        }
        this.updateReturnException = new XmlBlasterException(this.glob, code, ME, message);
        this.updateReturnLatch.release();
        if (this.log.CALL) {
            this.log.call(ME, "setUpdateException() called");
        }
    }

    public Properties createPropertiesInstance() {
        return new Properties();
    }

    public void initialize(Properties properties) {
        this.glob.init(properties);
    }

    public void initArgs(String[] args) {
        this.glob.init(args);
    }

    public Global getGlobal() {
        return this.glob;
    }

    public String sendRequest(String xmlRequest) {
        try {
            this.reader = new StringReader(xmlRequest);
            this.outStream = new ByteArrayOutputStream();
            this.interpreter = new XmlScriptInterpreter(this.glob, this.glob.getXmlBlasterAccess(), this, null, this.outStream);
            this.interpreter.parse(this.reader);
            return this.outStream.toString();
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "sendRequest failed: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "sendRequest failed: " + e.toString());
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public SynchronousCache createSynchronousCache(int size) {
        return this.glob.getXmlBlasterAccess().createSynchronousCache(size);
    }

    public ConnectReturnQos connect(String xmlQos) throws XmlBlasterException {
        ConnectQos qos = new ConnectQos(this.glob, this.glob.getConnectQosFactory().readObject(xmlQos));
        return this.glob.getXmlBlasterAccess().connect(qos, this);
    }

    public void leaveServer() {
        this.glob.getXmlBlasterAccess().leaveServer(null);
    }

    public boolean isConnected() {
        return this.glob.getXmlBlasterAccess().isConnected();
    }

    public void refreshSession() throws XmlBlasterException {
        this.glob.getXmlBlasterAccess().refreshSession();
    }

    public I_CallbackServer getCbServer() {
        return this.glob.getXmlBlasterAccess().getCbServer();
    }

    public String getId() {
        return this.glob.getXmlBlasterAccess().getId();
    }

    public boolean disconnect(String xmlQos) throws XmlBlasterException {
        DisconnectQos disconnectQos = new DisconnectQos(this.glob, this.glob.getDisconnectQosFactory().readObject(xmlQos));
        return this.glob.getXmlBlasterAccess().disconnect(disconnectQos);
    }

    public SubscribeReturnQos subscribe(String xmlKey, String xmlQos) throws XmlBlasterException {
        return this.glob.getXmlBlasterAccess().subscribe(xmlKey, xmlQos, null);
    }

    public UnSubscribeReturnQos[] unSubscribe(String xmlKey, String xmlQos) throws XmlBlasterException {
        return this.glob.getXmlBlasterAccess().unSubscribe(new UnSubscribeKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new UnSubscribeQos(this.glob, this.glob.getQueryQosFactory().readObject(xmlQos)));
    }

    public MsgUnit[] get(String xmlKey, String xmlQos) throws XmlBlasterException {
        return this.glob.getXmlBlasterAccess().get(new GetKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new GetQos(this.glob, this.glob.getQueryQosFactory().readObject(xmlQos)));
    }

    public MsgUnit[] getCached(String xmlKey, String xmlQos) throws XmlBlasterException {
        return this.glob.getXmlBlasterAccess().getCached(new GetKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new GetQos(this.glob, this.glob.getQueryQosFactory().readObject(xmlQos)));
    }

    public PublishReturnQos publishStr(String xmlKey, String contentStr, String xmlQos) throws XmlBlasterException {
        MsgUnit msgUnit = new MsgUnit(this.glob, xmlKey, contentStr, xmlQos);
        return this.glob.getXmlBlasterAccess().publish(msgUnit);
    }

    public PublishReturnQos publishBlob(String xmlKey, byte[] content, String xmlQos) throws XmlBlasterException {
        MsgUnit msgUnit = new MsgUnit(this.glob, xmlKey, content, xmlQos);
        return this.glob.getXmlBlasterAccess().publish(msgUnit);
    }

    public EraseReturnQos[] erase(String xmlKey, String xmlQos) throws XmlBlasterException {
        return this.glob.getXmlBlasterAccess().erase(new EraseKey(this.glob, this.glob.getQueryKeyFactory().readObject(xmlKey)), new EraseQos(this.glob, this.glob.getQueryQosFactory().readObject(xmlQos)));
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "Callback update arrived: " + updateKey.getOid());
        }
        UpdateMsgUnit msgUnit = new UpdateMsgUnit(cbSessionId, updateKey, content, updateQos);
        return this.notifyUpdateEvent(cbSessionId, updateKey, content, updateQos);
    }

    public String toXml() {
        return this.glob.getXmlBlasterAccess().toXml();
    }

    public static void main(String[] args) {
        try {
            XmlScriptAccess access = new XmlScriptAccess();
            Properties props = access.createPropertiesInstance();
            ((Hashtable)props).put("protocol", "SOCKET");
            access.initialize(props);
            class TestUpdateListener
            implements UpdateListener {
                private final /* synthetic */ XmlScriptAccess val$access;

                TestUpdateListener(XmlScriptAccess val$access) {
                    this.val$access = val$access;
                }

                public void update(UpdateEvent updateEvent) {
                    System.out.println("TestUpdateListener.update: " + updateEvent.getKey());
                    this.val$access.setUpdateReturn("<qos><state id='OK'/></qos>");
                }
            }
            TestUpdateListener listener = new TestUpdateListener(access);
            access.addUpdateListener(listener);
            String request = "<xmlBlaster>   <connect/>   <subscribe><key oid='test'></key><qos/></subscribe>   <publish>     <key oid='test'><airport name='london'/></key>     <content>This is a simple script test</content>     <qos/>   </publish>   <wait delay='1000'/></xmlBlaster>";
            String response = access.sendRequest(request);
            System.out.println("Response is: " + response);
            System.out.println("***** Publishing ...");
            PublishReturnQos ret = access.publishStr("<key oid='test'/>", "Bla", "<qos/>");
            System.out.println("***** Published message ret=" + ret.getState());
            Thread.currentThread();
            Thread.sleep(2000L);
            response = access.sendRequest("<xmlBlaster>disconnect/></xmlBlaster>");
        }
        catch (Throwable e) {
            System.out.println("ERROR: Caught exception: " + e.toString());
        }
    }
}

