/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.dispatch;

import org.xmlBlaster.authentication.plugins.I_MsgSecurityInterceptor;
import org.xmlBlaster.client.dispatch.ClientDispatchConnectionsHandler;
import org.xmlBlaster.client.protocol.I_XmlBlasterConnection;
import org.xmlBlaster.client.protocol.ProtocolPluginManager;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.queuemsg.MsgQueueConnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueDisconnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueEraseEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueGetEntry;
import org.xmlBlaster.client.queuemsg.MsgQueuePublishEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueSubscribeEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueUnSubscribeEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.DispatchConnection;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class ClientDispatchConnection
extends DispatchConnection {
    private final String ME;
    private I_XmlBlasterConnection driver;
    private final I_MsgSecurityInterceptor securityInterceptor;
    private String encryptedConnectQos;
    private ConnectReturnQos connectReturnQos;

    public ClientDispatchConnection(Global glob, ClientDispatchConnectionsHandler connectionsHandler, AddressBase address) throws XmlBlasterException {
        super(glob, connectionsHandler, address);
        this.ME = "ClientDispatchConnection-" + connectionsHandler.getDispatchManager().getQueue().getStorageId();
        this.securityInterceptor = connectionsHandler.getDispatchManager().getMsgSecurityInterceptor();
    }

    public final String getDriverName() {
        return this.driver != null ? this.driver.getProtocol() : "unknown";
    }

    public final String getName() {
        return this.ME;
    }

    public final void loadPlugin() throws XmlBlasterException {
        ProtocolPluginManager loader = this.glob.getProtocolPluginManager();
        this.driver = loader.getPlugin(this.address.getType(), this.address.getVersion());
        if (this.driver == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME, "Sorry, protocol type='" + this.address.getType() + "' is not supported");
        }
    }

    public final void connectLowlevel() throws XmlBlasterException {
        if (this.driver == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME, "Sorry, protocol type='" + this.address.getType() + "' is not supported");
        }
        this.driver.connectLowlevel((Address)this.address);
        this.driver.ping("");
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Connected low level to " + this.address.toString());
        }
    }

    public void doSend(MsgQueueEntry[] msgArr_) throws XmlBlasterException {
        if (msgArr_.length < 1) {
            return;
        }
        boolean onlyPublish = true;
        boolean onlyPublishOneway = true;
        int ii = 0;
        while (ii < msgArr_.length) {
            if (MethodName.PUBLISH_ONEWAY != msgArr_[ii].getMethodName()) {
                onlyPublishOneway = false;
            }
            if (MethodName.PUBLISH != msgArr_[ii].getMethodName()) {
                onlyPublish = false;
            }
            ++ii;
        }
        if (onlyPublishOneway || onlyPublish) {
            this.publish(msgArr_);
            return;
        }
        int ii2 = 0;
        while (ii2 < msgArr_.length) {
            MsgQueueEntry[] tmp;
            if (MethodName.PUBLISH_ONEWAY == msgArr_[ii2].getMethodName()) {
                tmp = new MsgQueueEntry[]{msgArr_[ii2]};
                this.publish(tmp);
            } else if (MethodName.PUBLISH == msgArr_[ii2].getMethodName()) {
                tmp = new MsgQueueEntry[]{msgArr_[ii2]};
                this.publish(tmp);
            } else if (MethodName.GET == msgArr_[ii2].getMethodName()) {
                this.get(msgArr_[ii2]);
            } else if (MethodName.SUBSCRIBE == msgArr_[ii2].getMethodName()) {
                this.subscribe(msgArr_[ii2]);
            } else if (MethodName.UNSUBSCRIBE == msgArr_[ii2].getMethodName()) {
                this.unSubscribe(msgArr_[ii2]);
            } else if (MethodName.ERASE == msgArr_[ii2].getMethodName()) {
                this.erase(msgArr_[ii2]);
            } else if (MethodName.CONNECT == msgArr_[ii2].getMethodName()) {
                this.connect(msgArr_[ii2]);
            } else if (MethodName.DISCONNECT == msgArr_[ii2].getMethodName()) {
                this.disconnect(msgArr_[ii2]);
            } else {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "Message type '" + msgArr_[ii2].getEmbeddedType() + "' is not implemented");
            }
            ++ii2;
        }
    }

    private void publish(MsgQueueEntry[] msgArr_) throws XmlBlasterException {
        int i;
        MsgUnit[] msgArr = new MsgUnit[msgArr_.length];
        int i2 = 0;
        while (i2 < msgArr.length) {
            MsgQueuePublishEntry publishEntry = (MsgQueuePublishEntry)msgArr_[i2];
            msgArr[i2] = publishEntry.getMsgUnit();
            ++i2;
        }
        MsgUnitRaw[] msgUnitRawArr = new MsgUnitRaw[msgArr.length];
        if (this.securityInterceptor != null) {
            i = 0;
            while (i < msgArr.length) {
                msgUnitRawArr[i] = this.securityInterceptor.exportMessage(msgArr[i].getMsgUnitRaw(), MethodName.PUBLISH);
                ++i;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Exported/encrypted " + msgArr.length + " publish messages.");
            }
        } else {
            this.log.warn(this.ME + ".accessDenied", "No session security context, sending " + msgArr.length + " publish messages without encryption");
            i = 0;
            while (i < msgArr.length) {
                msgUnitRawArr[i] = msgArr[i].getMsgUnitRaw();
                ++i;
            }
        }
        if (MethodName.PUBLISH_ONEWAY == msgArr_[0].getMethodName()) {
            this.driver.publishOneway(msgUnitRawArr);
            this.connectionsHandler.getDispatchStatistic().incrNumPublish(msgUnitRawArr.length);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Success, sent " + msgArr.length + " oneway publish messages.");
            }
            return;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Before publish " + msgArr.length + " acknowledged messages ...");
        }
        String[] rawReturnVal = this.driver.publishArr(msgUnitRawArr);
        this.connectionsHandler.getDispatchStatistic().incrNumPublish(rawReturnVal.length);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Success, sent " + msgArr.length + " acknowledged publish messages, return value #1 is '" + rawReturnVal[0] + "'");
        }
        if (rawReturnVal != null) {
            int i3 = 0;
            while (i3 < rawReturnVal.length) {
                if (msgArr_[i3].wantReturnObj()) {
                    if (this.securityInterceptor != null) {
                        rawReturnVal[i3] = this.securityInterceptor.importMessage(rawReturnVal[i3]);
                    }
                    try {
                        msgArr_[i3].setReturnObj(new PublishReturnQos(this.glob, rawReturnVal[i3]));
                    }
                    catch (Throwable e) {
                        this.log.warn(this.ME, "Can't parse publish returned value '" + rawReturnVal[i3] + "', setting to default: " + e.toString());
                        msgArr_[i3].setReturnObj(new PublishReturnQos(this.glob, "<qos/>"));
                    }
                }
                ++i3;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Imported/decrypted " + rawReturnVal.length + " publish message return values.");
            }
        }
    }

    private void subscribe(MsgQueueEntry entry) throws XmlBlasterException {
        MsgQueueSubscribeEntry subscribeEntry = (MsgQueueSubscribeEntry)entry;
        String key = subscribeEntry.getSubscribeKeyData().toXml();
        String qos = subscribeEntry.getSubscribeQosData().toXml();
        if (this.securityInterceptor != null) {
            key = this.securityInterceptor.exportMessage(key);
            qos = this.securityInterceptor.exportMessage(qos);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Exported/encrypted subscribe request.");
            }
        } else {
            this.log.warn(this.ME, "No session security context, subscribe request is not encrypted");
        }
        String rawReturnVal = this.driver.subscribe(key, qos);
        this.connectionsHandler.getDispatchStatistic().incrNumSubscribe(1L);
        if (subscribeEntry.wantReturnObj()) {
            if (this.securityInterceptor != null) {
                rawReturnVal = this.securityInterceptor.importMessage(rawReturnVal);
            }
            try {
                subscribeEntry.setReturnObj(new SubscribeReturnQos(this.glob, rawReturnVal));
            }
            catch (Throwable e) {
                this.log.warn(this.ME, "Can't parse returned subscribe value '" + rawReturnVal + "', setting to default: " + e.toString());
                subscribeEntry.setReturnObj(new SubscribeReturnQos(this.glob, "<qos/>"));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void unSubscribe(MsgQueueEntry entry) throws XmlBlasterException {
        block9: {
            unSubscribeEntry = (MsgQueueUnSubscribeEntry)entry;
            key = unSubscribeEntry.getUnSubscribeKey().toXml();
            qos = unSubscribeEntry.getUnSubscribeQos().toXml();
            if (this.securityInterceptor != null) {
                key = this.securityInterceptor.exportMessage(key);
                qos = this.securityInterceptor.exportMessage(qos);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Exported/encrypted unSubscribe request.");
                }
            } else {
                this.log.warn(this.ME, "No session security context, unSubscribe request is not encrypted");
            }
            rawReturnValArr = this.driver.unSubscribe(key, qos);
            this.connectionsHandler.getDispatchStatistic().incrNumUnSubscribe(1L);
            if (unSubscribeEntry.wantReturnObj()) {
                retQosArr = new UnSubscribeReturnQos[rawReturnValArr.length];
                ii = 0;
                while (ii < rawReturnValArr.length) {
                    if (this.securityInterceptor != null) {
                        xmlQos = this.securityInterceptor.importMessage(rawReturnValArr[ii]);
                        retQosArr[ii] = new UnSubscribeReturnQos(this.glob, xmlQos);
                    }
                    ++ii;
                }
                try {
                    unSubscribeEntry.setReturnObj(retQosArr);
                    break block9;
                }
                catch (Throwable e) {
                    this.log.warn(this.ME, "Can't parse returned unSubscribe value setting to default: " + e.toString());
                    ii = 0;
                    ** while (ii < rawReturnValArr.length)
                }
lbl-1000:
                // 1 sources

                {
                    retQosArr[ii] = new UnSubscribeReturnQos(this.glob, "<qos/>");
                    ++ii;
                    continue;
                }
lbl32:
                // 1 sources

                unSubscribeEntry.setReturnObj(retQosArr);
            }
        }
    }

    private void get(MsgQueueEntry entry) throws XmlBlasterException {
        MsgQueueGetEntry getEntry = (MsgQueueGetEntry)entry;
        String key = getEntry.getGetKey().toXml();
        String qos = getEntry.getGetQos().toXml();
        if (this.securityInterceptor != null) {
            key = this.securityInterceptor.exportMessage(key);
            qos = this.securityInterceptor.exportMessage(qos);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Exported/encrypted get request.");
            }
        } else {
            this.log.warn(this.ME, "No session security context, get request is not encrypted");
        }
        MsgUnitRaw[] rawReturnValArr = this.driver.get(key, qos);
        this.connectionsHandler.getDispatchStatistic().incrNumGet(1L);
        MsgUnit[] msgUnitArr = new MsgUnit[rawReturnValArr.length];
        if (getEntry.wantReturnObj()) {
            int ii = 0;
            while (ii < rawReturnValArr.length) {
                if (this.securityInterceptor != null) {
                    rawReturnValArr[ii] = this.securityInterceptor.importMessage(rawReturnValArr[ii], MethodName.PUBLISH);
                }
                msgUnitArr[ii] = new MsgUnit(this.glob, rawReturnValArr[ii], MethodName.PUBLISH);
                ++ii;
            }
            getEntry.setReturnObj(msgUnitArr);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void erase(MsgQueueEntry entry) throws XmlBlasterException {
        block9: {
            eraseEntry = (MsgQueueEraseEntry)entry;
            key = eraseEntry.getEraseKey().toXml();
            qos = eraseEntry.getEraseQos().toXml();
            if (this.securityInterceptor != null) {
                key = this.securityInterceptor.exportMessage(key);
                qos = this.securityInterceptor.exportMessage(qos);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Exported/encrypted erase request.");
                }
            } else {
                this.log.warn(this.ME, "No session security context, erase request is not encrypted");
            }
            rawReturnValArr = this.driver.erase(key, qos);
            this.connectionsHandler.getDispatchStatistic().incrNumErase(1L);
            if (eraseEntry.wantReturnObj()) {
                retQosArr = new EraseReturnQos[rawReturnValArr.length];
                ii = 0;
                while (ii < rawReturnValArr.length) {
                    if (this.securityInterceptor != null) {
                        xmlQos = this.securityInterceptor.importMessage(rawReturnValArr[ii]);
                        retQosArr[ii] = new EraseReturnQos(this.glob, xmlQos);
                    }
                    ++ii;
                }
                try {
                    eraseEntry.setReturnObj(retQosArr);
                    break block9;
                }
                catch (Throwable e) {
                    this.log.warn(this.ME, "Can't parse returned erase value setting to default: " + e.toString());
                    ii = 0;
                    ** while (ii < rawReturnValArr.length)
                }
lbl-1000:
                // 1 sources

                {
                    retQosArr[ii] = new EraseReturnQos(this.glob, "<qos/>");
                    ++ii;
                    continue;
                }
lbl32:
                // 1 sources

                eraseEntry.setReturnObj(retQosArr);
            }
        }
    }

    private void connect(MsgQueueEntry entry) throws XmlBlasterException {
        String qos;
        MsgQueueConnectEntry connectEntry = (MsgQueueConnectEntry)entry;
        String qosOrig = connectEntry.getConnectQosData().toXml();
        if (this.securityInterceptor != null) {
            qos = this.securityInterceptor.exportMessage(qosOrig);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Exported/encrypted connect request.");
            }
        } else {
            this.log.warn(this.ME, "No session security context, connect request is not encrypted");
            qos = qosOrig;
        }
        this.encryptedConnectQos = qos;
        String rawReturnVal = this.driver.connect(qos);
        this.connectionsHandler.getDispatchStatistic().incrNumConnect(1L);
        if (this.securityInterceptor != null) {
            rawReturnVal = this.securityInterceptor.importMessage(rawReturnVal);
        }
        try {
            this.connectReturnQos = new ConnectReturnQos(this.glob, rawReturnVal);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Can't parse returned connect QoS value '" + rawReturnVal + "': " + e.getMessage());
            throw e;
        }
        if (connectEntry.wantReturnObj()) {
            connectEntry.setReturnObj(this.connectReturnQos);
        }
        this.driver.setConnectReturnQos(this.connectReturnQos);
    }

    private void disconnect(MsgQueueEntry entry) throws XmlBlasterException {
        MsgQueueDisconnectEntry disconnectEntry = (MsgQueueDisconnectEntry)entry;
        String qos = disconnectEntry.getDisconnectQos().toXml();
        if (this.securityInterceptor != null) {
            qos = this.securityInterceptor.exportMessage(qos);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Exported/encrypted disconnect request.");
            }
        } else {
            this.log.warn(this.ME, "No session security context, disconnect request is not encrypted");
        }
        this.driver.disconnect(qos);
    }

    public final String doPing(String data) throws XmlBlasterException {
        String ret = this.driver.ping(data);
        return ret == null ? "" : ret;
    }

    public final void resetConnection() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "resetConnection(): Initializing driver for polling");
        }
        this.connectReturnQos = null;
        this.driver.resetConnection();
    }

    protected final void reconnect() throws XmlBlasterException {
        if (this.driver == null) {
            return;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering reconnect(" + this.driver.getProtocol() + ")");
        }
        if (this.connectReturnQos != null) {
            super.ping("", false);
            return;
        }
        if (this.encryptedConnectQos == null) {
            this.driver.connectLowlevel((Address)this.address);
            return;
        }
        String rawReturnVal = this.driver.connect(this.encryptedConnectQos);
        this.connectionsHandler.getDispatchStatistic().incrNumConnect(1L);
        if (this.securityInterceptor != null) {
            rawReturnVal = this.securityInterceptor.importMessage(rawReturnVal);
        }
        this.connectReturnQos = null;
        try {
            this.connectReturnQos = new ConnectReturnQos(this.glob, rawReturnVal);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "reconnect(): Can't parse returned connect QoS value '" + rawReturnVal + "': " + e.getMessage());
            throw e;
        }
        this.driver.setConnectReturnQos(this.connectReturnQos);
    }

    public final void shutdown() throws XmlBlasterException {
        super.shutdown();
        if (this.driver != null) {
            this.driver.shutdown();
        }
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset + "<ClientDispatchConnection>");
        this.address.toXml(" " + offset);
        if (this.driver == null) {
            sb.append(offset).append(" <noProtocolDriver />");
        } else {
            sb.append(offset).append(" <address type='" + this.driver.getProtocol() + "' state='" + this.getState() + "'/>");
        }
        sb.append(offset).append("</ClientDispatchConnection>");
        return sb.toString();
    }
}

