/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.dispatch;

import org.xmlBlaster.client.dispatch.ClientDispatchConnection;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.queuemsg.MsgQueueConnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueEraseEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueGetEntry;
import org.xmlBlaster.client.queuemsg.MsgQueuePublishEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueSubscribeEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueUnSubscribeEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.DispatchConnection;
import org.xmlBlaster.util.dispatch.DispatchConnectionsHandler;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class ClientDispatchConnectionsHandler
extends DispatchConnectionsHandler {
    public final String ME;

    public ClientDispatchConnectionsHandler(Global glob, DispatchManager dispatchManager) throws XmlBlasterException {
        super(glob, dispatchManager);
        this.ME = "ClientDispatchConnectionsHandler-" + dispatchManager.getQueue().getStorageId();
    }

    public DispatchConnection createDispatchConnection(AddressBase address) throws XmlBlasterException {
        ClientDispatchConnection c = new ClientDispatchConnection(this.glob, this, address);
        c.loadPlugin();
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createFakedReturnObjects(I_QueueEntry[] entries, String state, String stateInfo) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering createFakedReturnObjects() for " + entries.length + " entries");
        }
        int ii = 0;
        while (ii < entries.length) {
            MsgQueueEntry msgQueueEntry = (MsgQueueEntry)entries[ii];
            if (msgQueueEntry.wantReturnObj()) {
                MsgQueueEntry entry;
                StatusQosData statRetQos = new StatusQosData(this.glob, MethodName.UNKNOWN);
                statRetQos.setStateInfo(stateInfo);
                statRetQos.setState(state);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Creating faked return for '" + msgQueueEntry.getMethodName() + "' invocation");
                }
                if (MethodName.PUBLISH_ONEWAY == msgQueueEntry.getMethodName()) {
                    entry = (MsgQueuePublishEntry)msgQueueEntry;
                    entry.setReturnObj(null);
                } else if (MethodName.PUBLISH == msgQueueEntry.getMethodName()) {
                    entry = (MsgQueuePublishEntry)msgQueueEntry;
                    if (!((MsgQueuePublishEntry)entry).getMsgKeyData().hasOid()) {
                        ((MsgQueuePublishEntry)entry).getMsgKeyData().setOid(((MsgQueuePublishEntry)entry).getMsgKeyData().generateOid(((MsgQueuePublishEntry)entry).getSender().getRelativeName()));
                    }
                    statRetQos.setKeyOid(((MsgQueuePublishEntry)entry).getKeyOid());
                    PublishReturnQos publishReturnQos = new PublishReturnQos(this.glob, statRetQos);
                    entry.setReturnObj(new PublishReturnQos(this.glob, statRetQos));
                } else if (MethodName.SUBSCRIBE == msgQueueEntry.getMethodName()) {
                    entry = (MsgQueueSubscribeEntry)msgQueueEntry;
                    if (((MsgQueueSubscribeEntry)entry).getSubscribeQosData().getSubscriptionId() == null) {
                        String subscriptionId = QueryKeyData.generateSubscriptionId(this.dispatchManager.getQueue().getStorageId().getPostfix());
                        ((MsgQueueSubscribeEntry)entry).getSubscribeQosData().setSubscriptionId(subscriptionId);
                    }
                    statRetQos.setSubscriptionId(((MsgQueueSubscribeEntry)entry).getSubscribeQosData().getSubscriptionId());
                    SubscribeReturnQos subscribeReturnQos = new SubscribeReturnQos(this.glob, statRetQos, true);
                    entry.setReturnObj(subscribeReturnQos);
                } else if (MethodName.UNSUBSCRIBE == msgQueueEntry.getMethodName()) {
                    entry = (MsgQueueUnSubscribeEntry)msgQueueEntry;
                    String id = ((MsgQueueUnSubscribeEntry)entry).getUnSubscribeKey().getOid();
                    if (id == null || !id.startsWith("__subId:")) throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "UnSubscribe on oid='" + id + "' is not possible in offline/polling mode without an exact subscription ID given. " + "See 'http://www.xmlBlaster.org/xmlBlaster/doc/requirements/client.failsafe.html' for more details.");
                    statRetQos.setSubscriptionId(id);
                    UnSubscribeReturnQos[] unSubscribeReturnQosArr = new UnSubscribeReturnQos[]{new UnSubscribeReturnQos(this.glob, statRetQos)};
                    entry.setReturnObj(unSubscribeReturnQosArr);
                } else if (MethodName.ERASE == msgQueueEntry.getMethodName()) {
                    entry = (MsgQueueEraseEntry)msgQueueEntry;
                    if (!((MsgQueueEraseEntry)entry).getEraseKey().isExact()) throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Erase on oid='" + ((MsgQueueEraseEntry)entry).getEraseKey().getOid() + "' is not possible in offline/polling mode without an exact topic oid given. " + "See 'http://www.xmlBlaster.org/xmlBlaster/doc/requirements/client.failsafe.html' for more details.");
                    statRetQos.setKeyOid(((MsgQueueEraseEntry)entry).getEraseKey().getOid());
                    EraseReturnQos[] eraseReturnQosArr = new EraseReturnQos[]{new EraseReturnQos(this.glob, statRetQos)};
                    entry.setReturnObj(eraseReturnQosArr);
                } else if (MethodName.CONNECT == msgQueueEntry.getMethodName()) {
                    ConnectReturnQos connectReturnQos = new ConnectReturnQos(this.glob, ((MsgQueueConnectEntry)msgQueueEntry).getConnectQosData());
                    if (!connectReturnQos.getSessionName().isPubSessionIdUser()) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Can't find an xmlBlaster server. Try to provide the server host/port as described in http://www.xmlblaster.org/xmlBlaster/doc/requirements/client.configuration.html or provide a public session ID to support polling for xmlBlaster without an initial connection. See 'http://www.xmlBlaster.org/xmlBlaster/doc/requirements/client.failsafe.html' for more details.");
                    }
                    msgQueueEntry.setReturnObj(connectReturnQos);
                } else if (MethodName.DISCONNECT == msgQueueEntry.getMethodName()) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "disconnect returns void, nothing to do");
                    }
                } else {
                    if (MethodName.GET == msgQueueEntry.getMethodName()) {
                        entry = (MsgQueueGetEntry)msgQueueEntry;
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Synchronous GET on oid='" + ((MsgQueueGetEntry)entry).getGetKey().getOid() + "' is not possible in offline/polling mode. " + "See 'http://www.xmlBlaster.org/xmlBlaster/doc/requirements/client.failsafe.html' for more details.");
                    }
                    this.log.error(this.ME, "Internal problem, MsgQueueEntry '" + msgQueueEntry.getEmbeddedType() + "' not expected here");
                }
            }
            ++ii;
        }
    }
}

