/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.feeder;

import java.io.File;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class PublishFile {
    private static final String ME = "PublishFile";
    private I_XmlBlasterAccess senderConnection;
    private Global glob;
    private LogChannel log;
    private String loginName;
    private String passwd;

    public PublishFile(String[] args) throws JUtilsException {
        this.glob = new Global();
        if (this.glob.init(args) != 0) {
            this.usage();
            System.err.println("PublishFile: Bye");
            System.exit(1);
        }
        this.log = this.glob.getLog("client");
        this.loginName = this.glob.getProperty().get("loginName", ME);
        this.passwd = this.glob.getProperty().get("passwd", "secret");
        String contentMime = this.glob.getProperty().get("m", (String)null);
        String contentMimeExtended = this.glob.getProperty().get("me", "1.0");
        String contentFile = this.glob.getProperty().get("c", (String)null);
        String keyFile = this.glob.getProperty().get("k", (String)null);
        String qosFile = this.glob.getProperty().get("q", (String)null);
        String xmlKeyGiven = this.glob.getProperty().get("xmlKey", (String)null);
        String xmlQosGiven = this.glob.getProperty().get("xmlQos", (String)null);
        String contentGiven = this.glob.getProperty().get("content", (String)null);
        String body = null;
        String exte = null;
        if (contentFile != null) {
            File contentHandle = new File(contentFile);
            String name = contentHandle.getPath();
            body = FileUtil.getBody(name);
            exte = FileUtil.getExtension(name);
        }
        byte[] content = null;
        if (contentFile != null) {
            try {
                content = FileUtil.readFile(contentFile);
            }
            catch (JUtilsException e) {
                this.log.error(ME, e.toString());
            }
        }
        if (content == null && contentGiven != null) {
            content = contentGiven.getBytes();
        }
        if (content == null) {
            content = new byte[]{};
        }
        String xmlKey = null;
        if (keyFile != null) {
            try {
                xmlKey = FileUtil.readAsciiFile(keyFile);
            }
            catch (JUtilsException e) {
                this.log.error(ME, e.toString());
            }
        }
        if (xmlKey == null) {
            xmlKey = xmlKeyGiven;
        }
        if (contentMime == null && exte != null) {
            contentMime = FileUtil.extensionToMime(exte, null);
        }
        if (xmlKey == null && body != null) {
            if (contentMime == null) {
                this.log.error(ME, "File MIME type is unknown, specify MIME type as '-m <MIME>', for example '-m \"image/gif\"' (get help with -?)");
                System.exit(1);
            }
            PublishKey publishKey = new PublishKey(this.glob, body, contentMime, contentMimeExtended);
            xmlKey = publishKey.toXml();
        }
        if (xmlKey == null) {
            this.log.error(ME, "XmlKey is missing, specify key as '-k <file>' or '-xmlKey <the XML key>' (get help with -?)");
            System.exit(1);
        }
        String xmlQos = null;
        if (qosFile != null) {
            try {
                xmlQos = FileUtil.readAsciiFile(qosFile);
            }
            catch (JUtilsException e) {
                this.log.error(ME, e.toString());
            }
        }
        if (xmlQos == null) {
            xmlQos = xmlQosGiven;
        }
        if (xmlQos == null) {
            PublishQos publishQos = new PublishQos(this.glob);
            xmlQos = publishQos.toXml();
        }
        this.feed(xmlKey, content, xmlQos);
    }

    public PublishFile(String loginName, String passwd, String xmlKey, byte[] content, String xmlQos) {
        this.loginName = loginName;
        this.passwd = passwd;
        this.feed(xmlKey, content, xmlQos);
    }

    protected void feed(String xmlKey, byte[] content, String xmlQos) {
        this.setUp();
        this.publish(xmlKey, content, xmlQos);
        this.tearDown();
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            ConnectQos connectQos = new ConnectQos(this.glob, this.loginName, this.passwd);
            this.senderConnection.connect(connectQos, null);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        this.senderConnection.disconnect(null);
    }

    public void publish(String xmlKey, byte[] content, String qos) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing the message ...\nKEY:\n" + xmlKey + "\nCONTENT-LENGTH=" + content.length + "\nQOS:\n" + qos);
        }
        try {
            MsgUnit msgUnit = new MsgUnit(this.glob, xmlKey, content, qos);
            StopWatch stop = new StopWatch();
            PublishReturnQos publish = this.senderConnection.publish(msgUnit);
            this.log.info(ME, "Success: Publishing done: " + publish.toXml() + "\n" + stop.nice());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
        }
    }

    private void usage() {
        System.out.println("----------------------------------------------------------");
        System.out.println("java org.xmlBlaster.client.feeder.PublishFile <options>");
        System.out.println("----------------------------------------------------------");
        System.out.println("Options:");
        System.out.println("   -?                  Print this message.");
        System.out.println("");
        System.out.println("   -loginName <LoginName> Your xmlBlaster login name.");
        System.out.println("   -passwd <Password>  Your xmlBlaster password.");
        System.out.println("");
        System.out.println("   -k  <XmlKeyFile>    The XmlKey for the content, or:");
        System.out.println("   -xmlKey <XmlKey>    The XML key on command line.");
        System.out.println("");
        System.out.println("   -c  <contentFile>   The content file you want to feed, or:");
        System.out.println("   -content <content>  The content on command line.");
        System.out.println("");
        System.out.println("   -q  <XmlQosFile>    The XmlQos for the message, or:");
        System.out.println("   -xmlQos <XmlQos>    The XML qos on command line.");
        System.out.println("");
        System.out.println("   These options only if you didn't specify -k or -xmlKey explicitly");
        System.out.println("   -m  <MIMEtype>      The MIME type of the message.");
        System.out.println("   -me <MIMEextendend> The extenden MIME type (for your own use).");
        System.out.println("----------------------------------------------------------");
        System.out.println("Example:");
        System.out.println("java org.xmlBlaster.client.feeder.PublishFile -c Hello.xml");
        System.out.println("   The message will be named automatically 'Hello' and the MIME will be set to 'text/xml'");
        System.out.println("   and the qos (quality of service) is set to default");
        System.out.println("");
        System.out.println("java org.xmlBlaster.client.feeder.PublishFile -content \"Hello World\" -xmlKey \"<key oid='number12' contentMime='text/plain'></key>\"");
        System.out.println("");
        System.out.println("java org.xmlBlaster.client.feeder.PublishFile -xmlKey \"<key oid='__cmd:sysprop/?trace=true'/>\"");
        System.out.println("----------------------------------------------------------");
        System.out.println("");
    }

    public static void main(String[] args) {
        try {
            PublishFile publishFile = new PublishFile(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("PublishFile: " + e.toString());
            System.exit(1);
        }
    }
}

