/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.TreeMap;
import javax.management.ObjectName;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.jmx.AsyncMBeanServer;
import org.xmlBlaster.client.jmx.ConnectorException;
import org.xmlBlaster.client.jmx.XmlBlasterInvocationHandler;
import org.xmlBlaster.util.Global;

public class ConnectorFactory {
    private static final String ME = "ConnectorFactory";
    private static ConnectorFactory singletonFactory;
    private static Global applicationGlobal;
    private static Object syncObject;
    private Global global;
    private LogChannel log;
    private TreeMap childGlobals;
    private TreeMap servers;
    static /* synthetic */ Class class$org$xmlBlaster$client$jmx$AsyncMBeanServer;

    public static ConnectorFactory getInstance(Global global) {
        if (singletonFactory == null) {
            Object object = syncObject;
            synchronized (object) {
                if (singletonFactory == null) {
                    singletonFactory = new ConnectorFactory(global);
                    applicationGlobal = global;
                }
            }
        }
        if (global != applicationGlobal) {
            global.getLog(null).error(ME, "getInstance: The global used for this invocation is not the same as the application global");
            Thread.currentThread();
            Thread.dumpStack();
        }
        return singletonFactory;
    }

    private ConnectorFactory(Global global) {
        this.global = global;
        this.log = global.getLog("jmx");
        this.childGlobals = new TreeMap();
        this.servers = new TreeMap();
    }

    private synchronized AsyncMBeanServer addAsyncConnector(String transport, String serverName) throws ConnectorException {
        AsyncMBeanServer server = null;
        if (transport.equalsIgnoreCase("xmlBlaster")) {
            Global childGlobal = this.global.getClone(null);
            this.childGlobals.put(serverName, childGlobal);
            try {
                server = (AsyncMBeanServer)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{class$org$xmlBlaster$client$jmx$AsyncMBeanServer == null ? (class$org$xmlBlaster$client$jmx$AsyncMBeanServer = ConnectorFactory.class$("org.xmlBlaster.client.jmx.AsyncMBeanServer")) : class$org$xmlBlaster$client$jmx$AsyncMBeanServer}, (InvocationHandler)new XmlBlasterInvocationHandler(serverName, childGlobal));
                this.servers.put(serverName, server);
                return server;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ConnectorException("Error connecting to xmlBlaster Service", e);
            }
        }
        throw new ConnectorException("Unknown transport " + transport);
    }

    private AsyncMBeanServer getExistingAsyncConnector(String serverName) {
        return (AsyncMBeanServer)this.servers.get(serverName);
    }

    public AsyncMBeanServer getMBeanServer(String serverName) throws ConnectorException {
        String transport = "xmlBlaster";
        AsyncMBeanServer server = this.getExistingAsyncConnector(serverName);
        try {
            if (server == null) {
                server = this.addAsyncConnector(transport, serverName);
                ObjectName requestBroker_name = new ObjectName(transport + ":name=requestBroker");
                server.createMBean("org.xmlBlaster.engine.RequestBroker", requestBroker_name);
            }
        }
        catch (Exception ex) {
            this.global.getLog(null).error(ME, "Exception occured in 'getMBeanServers': " + ex.getMessage());
            ex.printStackTrace();
            throw new ConnectorException("Error when retreiving mbean server ", ex);
        }
        return server;
    }

    public String[] getMBeanServerList() {
        Iterator iter = this.servers.values().iterator();
        String[] ret = new String[this.servers.size()];
        int i = 0;
        try {
            while (iter.hasNext()) {
                AsyncMBeanServer server = (AsyncMBeanServer)iter.next();
                ObjectName requestBroker_name = new ObjectName("xmlBlaster:name=requestBroker");
                ret[i] = server.getAttribute(requestBroker_name, "NodeList").get().toString();
                ++i;
            }
        }
        catch (Exception ex) {
            this.log.error(ME, "Exception occured in 'getMBeanServerList': " + ex.getMessage());
            ex.printStackTrace();
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        syncObject = new Object();
    }
}

