/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.jmx;

import java.io.IOException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.jmx.AsyncMBeanServer;
import org.xmlBlaster.client.jmx.UserFilter;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.jmxgui.JmxPlugin;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.admin.extern.SerializeHelper;

public class NotificationHandler
implements I_Callback {
    private LogChannel log = null;
    private static int port = 3424;
    private I_XmlBlasterAccess returnCon;
    private Global glob;
    private SerializeHelper serHelp;
    private String ME = "NotificationHandler";
    private JmxPlugin panel;
    private String beanSource = "";
    private AsyncMBeanServer server;
    private ObjectName objectName;

    public NotificationHandler(String strObjectName, String className, JmxPlugin panel, AsyncMBeanServer server) {
        this.server = server;
        this.beanSource = strObjectName;
        try {
            this.glob = Global.instance();
            this.log = this.glob.getLog("jmxGUI");
            if (this.log.CALL) {
                this.log.error(this.ME, "Constructor for '" + strObjectName + "' of class '" + className + "'");
            }
            this.objectName = new ObjectName(strObjectName);
            this.serHelp = new SerializeHelper(this.glob);
            this.panel = panel;
            this.returnCon = this.glob.getXmlBlasterAccess();
            SubscribeKey subKey = new SubscribeKey(this.glob, "xmlBlasterMBeans_Notification");
            this.log.info(this.ME, "NotificationHandler... Trying to connect to service...");
            SubscribeQos sQos = new SubscribeQos(this.glob);
            sQos.setWantLocal(false);
            this.returnCon.subscribe(subKey, sQos, (I_Callback)this);
            UserFilter filter = new UserFilter();
            server.addNotificationListener(this.objectName, className, filter);
        }
        catch (Exception ex) {
            this.log.error(this.ME, "Error when invoking internal Server for Connector: " + ex.toString());
            ex.printStackTrace();
        }
    }

    public void unregister() {
        this.server.removeNotificationListener(this.objectName);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        Notification notif = null;
        this.log.info(this.ME, "Received Notification....");
        try {
            notif = (Notification)this.serHelp.deserializeObject(content);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.beanSource.equals(notif.getSource().toString())) {
            this.log.info(this.ME, "sending update to panel: " + notif.getSource());
            this.panel.update();
        }
        return "";
    }
}

