/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.jmx.XmlBlasterCallback;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.admin.extern.MethodInvocation;
import org.xmlBlaster.util.admin.extern.SerializeHelper;
import org.xmlBlaster.util.qos.address.Address;

public class XmlBlasterInvocationHandler
implements I_Callback,
InvocationHandler {
    static SerializeHelper ser;
    static long messageID;
    private SubscribeKey subsKey = null;
    private final Global global;
    private LogChannel log;
    private I_XmlBlasterAccess xmlBlasterAccess;
    private String ME = "XmlBlasterInvocationHandler";
    private static int port;
    private Map callbackBuffer = Collections.synchronizedMap(new HashMap());

    public XmlBlasterInvocationHandler(String serverName, Global global) {
        this.global = global;
        this.log = this.global.getLog("jmx");
        if (this.log.CALL) {
            this.log.error(this.ME, "Constructor for '" + serverName + "'");
        }
        this.log.info(this.ME, "XmlBlasterInvocationHandler called");
        try {
            Address addr = new Address(global);
            Properties prop = new Properties();
            prop.setProperty("bootstrapHostname", serverName);
            prop.setProperty("bootstrapPort", "3424");
            global.init(prop);
            this.xmlBlasterAccess = global.getXmlBlasterAccess();
            this.log.info(this.ME, "Connecting to embedded xmlBlaster on port " + port + " Address " + addr.getBootstrapUrl());
            if (!this.xmlBlasterAccess.isConnected()) {
                ConnectQos qos = new ConnectQos(this.global, "InternalConnector", "connector");
                this.xmlBlasterAccess.connect(qos, this);
            }
            SubscribeKey subKey = new SubscribeKey(this.global, "xmlBlasterMBeans_Return");
            SubscribeQos sQos = new SubscribeQos(this.global);
            sQos.setWantLocal(false);
            this.xmlBlasterAccess.subscribe(subKey, sQos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        this.log.info(this.ME, "invoke: within XmlBlasterInvocationHandler called - Method called: " + method);
        MethodInvocation mi = new MethodInvocation(method);
        mi.setParams(args);
        String ID = "" + messageID++;
        mi.setId(ID);
        this.log.info(this.ME, "invoke: Put MethodInvocation-ID into callback-buffer in order to rematch again '" + mi.getId() + "' and method '" + method.getName() + "'");
        XmlBlasterCallback cb = new XmlBlasterCallback(ID, mi);
        this.callbackBuffer.put(ID, cb);
        if (method.getName().equals("close")) {
            if (this.log.DUMP) {
                this.log.dump(this.ME, "invoke 'close': ");
                Thread.currentThread();
                Thread.dumpStack();
            }
            this.close();
            return null;
        }
        ser = new SerializeHelper(this.global);
        PublishReturnQos rqos = this.xmlBlasterAccess.publish(new MsgUnit("<key oid='xmlBlasterMBeans_Invoke'/>", ser.serializeObject(mi), "<qos/>"));
        this.log.info(this.ME, "invoke: Returning callback-object: " + cb);
        return cb;
    }

    private synchronized void close() {
        this.log.error(this.ME, "Disconnecting from xmlBlaster.... (not really disconnecting)");
    }

    public synchronized String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "update: Received asynchronous message in \"update()\" clientSide '" + updateKey.getOid() + "' state=" + updateQos.getState() + " from xmlBlaster - extracting MethodInvocation...");
        }
        MethodInvocation mi = null;
        SerializeHelper serHelp = new SerializeHelper(this.global);
        try {
            mi = (MethodInvocation)serHelp.deserializeObject(content);
            this.log.info(this.ME, "update: Method received: " + mi.getMethodName());
        }
        catch (Exception ex) {
            this.log.error(this.ME, "update: Error when trying to expand MethodInvocationObject " + ex.toString());
            ex.printStackTrace();
        }
        String ID = mi.getId();
        this.log.info(this.ME, " update: ID from MethodInvocation that maps callback-buffer: " + ID);
        XmlBlasterCallback cb = (XmlBlasterCallback)this.callbackBuffer.get(ID);
        if (this.log.TRACE) {
            this.log.trace(this.ME, " update: Whats in Received Object?? - " + mi.getReturnValue());
            this.log.trace(this.ME, "update: the callback with ID '" + ID + "' is '" + cb + "'");
        }
        if (cb != null) {
            cb.setMethodInvocation(mi);
        }
        return "";
    }

    static {
        messageID = -1L;
        port = 3424;
    }
}

