/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_ClientPlugin;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public abstract class AbstractCallbackExtended
implements I_CallbackExtended {
    private String ME = "AbstractCallbackExtended";
    protected final Global glob;
    protected final LogChannel log;

    public AbstractCallbackExtended(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = glob.getLog("client");
    }

    public abstract I_ClientPlugin getSecurityPlugin();

    public String update(String cbSessionId, String updateKeyLiteral, byte[] content, String updateQosLiteral) throws XmlBlasterException {
        I_ClientPlugin secPlgn = this.getSecurityPlugin();
        if (secPlgn != null) {
            updateKeyLiteral = secPlgn.importMessage(updateKeyLiteral);
            content = secPlgn.importMessage(content);
            updateQosLiteral = secPlgn.importMessage(updateQosLiteral);
        }
        UpdateKey updateKey = null;
        UpdateQos updateQos = null;
        try {
            updateKey = new UpdateKey(this.glob, updateKeyLiteral);
            updateQos = new UpdateQos(this.glob, updateQosLiteral);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME + ".update", "Parsing error: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ILLEGALARGUMENT, this.ME + ".update", "Parsing error", e);
        }
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Received message [" + updateKey.getOid() + "] from publisher " + updateQos.getSender());
            }
            String ret = this.update(cbSessionId, updateKey, content, updateQos);
            if (secPlgn != null) {
                ret = secPlgn.exportMessage(ret);
            }
            return ret;
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.warn(this.ME + ".update", "Error in client user code of update(): " + e.toString());
            e.printStackTrace();
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_INTERNALERROR, this.ME + ".update", "Error in client code", e);
        }
    }

    public void updateOneway(String cbSessionId, String updateKeyLiteral, byte[] content, String updateQosLiteral) {
        try {
            this.update(cbSessionId, updateKeyLiteral, content, updateQosLiteral);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Caught exception, can't deliver it to xmlBlaster server as we are in oneway mode: " + e.toString());
        }
    }

    public String[] update(String cbSessionId, MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (msgUnitArr == null) {
            this.log.warn(this.ME, "Entering update() with null array.");
            return new String[0];
        }
        if (msgUnitArr.length == 0) {
            this.log.warn(this.ME, "Entering update() with 0 messages.");
            return new String[0];
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Receiving update of " + msgUnitArr.length + " messages ...");
        }
        String[] retArr = new String[msgUnitArr.length];
        int ii = 0;
        while (ii < msgUnitArr.length) {
            MsgUnitRaw msgUnit = msgUnitArr[ii];
            retArr[ii] = this.update(cbSessionId, msgUnit.getKey(), msgUnit.getContent(), msgUnit.getQos());
            ++ii;
        }
        return retArr;
    }

    public void updateOneway(String cbSessionId, MsgUnitRaw[] msgUnitArr) {
        try {
            this.update(cbSessionId, msgUnitArr);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Caught exception, can't deliver it to xmlBlaster server as we are in oneway mode: " + e.toString());
        }
    }

    public abstract String update(String var1, UpdateKey var2, byte[] var3, UpdateQos var4) throws XmlBlasterException;
}

