/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.plugin.PluginManagerBase;

public class CbServerPluginManager
extends PluginManagerBase {
    private final String ME;
    private final Global glob;
    private final LogChannel log;
    private static final String defaultPluginName = "org.xmlBlaster.client.protocol.corba.CorbaCallbackServer";
    public static final String pluginPropertyName = "ClientCbServerProtocolPlugin";

    public CbServerPluginManager(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("protocol");
        this.ME = "CbServerPluginManager" + this.glob.getLogPrefixDashed();
        if (this.log.CALL) {
            this.log.call(this.ME, "Constructor CbServerPluginManager");
        }
    }

    protected String getPluginPropertyName() {
        return pluginPropertyName;
    }

    public String getDefaultPluginName(String type, String version) {
        return defaultPluginName;
    }

    public final I_CallbackServer getNewProtocolDriverInstance(String driverType) throws XmlBlasterException {
        return this.getPlugin(driverType, "1.0");
    }

    public I_CallbackServer getPlugin(String type, String version) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME + ".getPlugin()", "Creating instance of " + this.createPluginPropertyKey(type, version));
        }
        PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)this, type, version);
        I_CallbackServer driver = (I_CallbackServer)super.instantiatePlugin(pluginInfo, false);
        return driver;
    }

    public void postInstantiate(I_Plugin plugin, PluginInfo pluginInfo) {
    }

    public void activateDrivers() throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Don't know how to activate the calback server protocol drivers, they are created for each client and session separately");
        }
    }

    public final void deactivateDrivers(boolean force) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Don't know how to deactivate the calback server protocol drivers, they are created for each client and session separately");
        }
    }

    public void shutdownDrivers(boolean force) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Don't know how to shutdown the calback server protocol drivers, they are created for each client and session separately");
        }
    }
}

