/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.corba;

import org.jutils.log.LogChannel;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.protocol.corba.CorbaDriver;
import org.xmlBlaster.protocol.corba.OrbInstanceFactory;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallback;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackHelper;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackOperations;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackPOATie;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public final class CorbaCallbackServer
implements BlasterCallbackOperations,
I_CallbackServer {
    private ORB orb;
    private POA rootPOA;
    private BlasterCallback callback;
    private String ME;
    private Global glob;
    private LogChannel log;
    private I_CallbackExtended boss;
    private CallbackAddress callbackAddress;

    public CorbaCallbackServer() {
    }

    public CorbaCallbackServer(Global glob, String name, CallbackAddress callbackAddress, I_CallbackExtended boss, ORB orb_) throws org.xmlBlaster.util.XmlBlasterException {
        this.initialize(glob, name, callbackAddress, boss);
    }

    public void initialize(Global glob, String name, CallbackAddress callbackAddress, I_CallbackExtended boss) throws org.xmlBlaster.util.XmlBlasterException {
        this.glob = glob;
        if (this.glob == null) {
            this.glob = new Global();
        }
        this.log = this.glob.getLog("corba");
        this.callbackAddress = callbackAddress;
        this.orb = OrbInstanceFactory.createOrbInstance(this.glob, null, glob.getProperty().getProperties(), this.callbackAddress);
        this.ME = "CorbaCallbackServer-" + name;
        this.boss = boss;
        this.createCallbackServer();
        this.log.info(this.ME, "Success, created CORBA callback server");
    }

    public String getType() {
        return this.getCbProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    private void createCallbackServer() throws org.xmlBlaster.util.XmlBlasterException {
        BlasterCallbackPOATie callbackTie = new BlasterCallbackPOATie(this);
        try {
            this.rootPOA = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
        }
        catch (COMM_FAILURE e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_CALLBACKSERVER_CREATION, this.ME, "Could not initialize CORBA, do you use the SUN-JDK delivered ORB instead of JacORB or ORBaccus? Try 'jaco' instead of 'java' and read instructions in xmlBlaster/bin/jaco or xmlBlaster/config/orb.properties: " + e.toString());
        }
        catch (Exception e) {
            this.log.error(this.ME + ".CallbackCreationError", "Can't create a BlasterCallback server, RootPOA not found: " + e.toString());
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_CALLBACKSERVER_CREATION, this.ME, e.toString());
        }
        try {
            this.rootPOA.the_POAManager().activate();
            this.callback = BlasterCallbackHelper.narrow(this.rootPOA.servant_to_reference(callbackTie));
            if (this.orb.work_pending()) {
                this.orb.perform_work();
            }
        }
        catch (Exception e) {
            this.log.error(this.ME + ".CallbackCreationError", "Can't create a BlasterCallback server, narrow failed: " + e.toString());
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_CALLBACKSERVER_CREATION, this.ME, e.toString());
        }
    }

    public void shutdown() {
        if (this.callback == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No callback server to shutdown.");
            }
            return;
        }
        if (this.rootPOA != null && this.callback != null) {
            try {
                this.callback._release();
                this.rootPOA.deactivate_object(this.rootPOA.reference_to_id(this.callback));
            }
            catch (Exception e) {
                this.log.warn(this.ME, "POA deactivate callback failed");
            }
            this.callback = null;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Doing orb.shutdown()");
            }
            try {
                this.orb.shutdown(false);
            }
            catch (Exception ex) {
                this.log.warn(this.ME, "shutdown:exception occured destroy(): " + ex.toString());
            }
        }
        this.callback = null;
        this.log.info(this.ME, "The callback server is shutdown.");
    }

    public final String getCbProtocol() {
        return "IOR";
    }

    public String getCbAddress() throws org.xmlBlaster.util.XmlBlasterException {
        return this.orb.object_to_string(this.callback);
    }

    public void updateOneway(String cbSessionId, MessageUnit[] msgUnitArr) {
        if (msgUnitArr == null) {
            this.log.warn(this.ME, "Receiving in updateOneway(" + cbSessionId + ") null message");
            return;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering updateOneway(" + cbSessionId + ") of " + msgUnitArr.length + " messages");
        }
        try {
            MsgUnitRaw[] localMsgUnitRawArr = CorbaDriver.convert(this.glob, msgUnitArr);
            this.boss.updateOneway(cbSessionId, localMsgUnitRawArr);
        }
        catch (Throwable e) {
            this.log.warn(this.ME, "updateOneway() failed in client code, exception is not sent to xmlBlaster: " + e.toString());
            e.printStackTrace();
        }
    }

    public String[] update(String cbSessionId, MessageUnit[] msgUnitArr) throws XmlBlasterException {
        if (msgUnitArr == null) {
            throw CorbaDriver.convert(new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ILLEGALARGUMENT, this.ME, "Received update of null message"));
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering update(" + cbSessionId + ") of " + msgUnitArr.length + " messages");
        }
        if (this.log.DUMP) {
            int ii = 0;
            while (ii < msgUnitArr.length) {
                this.log.dump(this.ME, "update()\n" + msgUnitArr[ii].xmlKey + "\n" + msgUnitArr[ii].qos);
                ++ii;
            }
        }
        try {
            MsgUnitRaw[] localMsgUnitRawArr = CorbaDriver.convert(this.glob, msgUnitArr);
            return this.boss.update(cbSessionId, localMsgUnitRawArr);
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            this.log.warn(this.ME, "Delivering message to client failed, message is not handled by client: " + e.toString());
            throw CorbaDriver.convert(e);
        }
        catch (Throwable e) {
            this.log.warn(this.ME, "Delivering message to client failed, message is not handled by client: " + e.toString());
            e.printStackTrace();
            throw CorbaDriver.convert(new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "Delivering message to client failed, message is not handled by client: " + e.toString()));
        }
    }

    public String ping(String qos) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering ping(" + qos + ") ...");
        }
        return "<qos><state id='OK'/></qos>";
    }
}

