/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.corba;

import java.applet.Applet;
import java.util.Hashtable;
import java.util.Properties;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.xmlBlaster.client.protocol.I_XmlBlasterConnection;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.protocol.corba.CorbaDriver;
import org.xmlBlaster.protocol.corba.OrbInstanceFactory;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServer;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServerHelper;
import org.xmlBlaster.protocol.corba.serverIdl.Server;
import org.xmlBlaster.protocol.corba.serverIdl.ServerHelper;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.Address;

public final class CorbaConnection
implements I_XmlBlasterConnection,
I_Plugin {
    private String ME = "CorbaConnection";
    private Global glob;
    private LogChannel log;
    private ORB orb;
    private NamingContextExt nameService;
    private AuthServer authServer;
    private Server xmlBlaster;
    private Address clientAddress;
    private String sessionId;
    private boolean verbose = true;

    public CorbaConnection() {
    }

    public CorbaConnection(Global glob, Applet ap) {
        String orbClassName = "org.jacorb.orb.ORB";
        String orbSingleton = "org.jacorb.orb.ORBSingleton";
        Properties props = new Properties();
        ((Hashtable)props).put("org.omg.CORBA.ORBClass", orbClassName);
        ((Hashtable)props).put("org.omg.CORBA.ORBSingletonClass", orbSingleton);
        this.orb = ORB.init(ap, props);
        this.init(glob, null);
        this.log.info(this.ME, "Using ORB=" + orbClassName + " and ORBSingleton=" + orbSingleton);
    }

    public String getType() {
        return this.getProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("corba");
        this.resetConnection();
        this.log.info(this.ME, "Created '" + this.getProtocol() + "' protocol plugin to connect to xmlBlaster server");
    }

    public void resetConnection() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "resetConnection():");
        }
        this.authServer = null;
        this.xmlBlaster = null;
    }

    public final String getProtocol() {
        return "IOR";
    }

    public ORB getOrb() {
        return this.orb;
    }

    private Server getXmlBlaster() throws org.xmlBlaster.util.XmlBlasterException {
        if (this.xmlBlaster == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No CORBA connection available.");
            }
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "The CORBA xmlBlaster handle is null, no connection available");
        }
        return this.xmlBlaster;
    }

    NamingContextExt getNamingService() throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "getNamingService() ...");
        }
        if (this.nameService != null) {
            return this.nameService;
        }
        if (this.orb == null) {
            this.log.error(this.ME, "orb==null, internal problem");
            Thread.dumpStack();
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "orb==null, internal problem");
        }
        Object nameServiceObj = null;
        try {
            nameServiceObj = this.orb.resolve_initial_references("NameService");
        }
        catch (Throwable e) {
            String text = "Can't access naming service, is there any running?\n - try to specify '-dispatch/connection/plugin/ior/iorFile <fileName>' if server is running on same host (not using any naming service)\n - try to specify '-bootstrapHostname <hostName> -bootstrapPort 3412' to locate xmlBlaster (not using any naming service)\n - or contact the server administrator to start a naming service";
            if (this.verbose) {
                this.log.warn(this.ME + ".NoNameService", text);
            }
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, "NoNameService", text);
        }
        if (nameServiceObj == null) {
            throw new org.xmlBlaster.util.XmlBlasterException("NoNameService", "Can't access naming service (null), is there any running?");
        }
        try {
            this.nameService = NamingContextExtHelper.narrow(nameServiceObj);
            if (this.nameService == null) {
                this.log.error(this.ME + ".NoNameService", "Can't access naming service (narrow problem)");
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, "NoNameService", "Can't access naming service (narrow problem)");
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Successfully narrowed handle for naming service");
            }
            return this.nameService;
        }
        catch (Throwable e) {
            if (this.verbose) {
                this.log.warn(this.ME + ".NoNameService", "Can't access naming service");
            }
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, "NoNameService", e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthServer getAuthenticationService(Address address) throws org.xmlBlaster.util.XmlBlasterException {
        AuthServer e22;
        block45: {
            AuthServer e22;
            block44: {
                AuthServer authServer;
                block43: {
                    if (this.log.CALL) {
                        this.log.call(this.ME, "getAuthenticationService() ...");
                    }
                    if (this.authServer != null) {
                        return this.authServer;
                    }
                    address = address == null ? new Address(this.glob) : address;
                    try {
                        String clusterKind;
                        String clusterId;
                        String contextKind;
                        String contextId;
                        block46: {
                            String authServerIORFile;
                            if (address.getRawAddress() != null && address.getRawAddress().length() > 2) {
                                String authServerIOR = address.getRawAddress();
                                this.authServer = AuthServerHelper.narrow(this.orb.string_to_object(authServerIOR));
                                if (this.verbose) {
                                    this.log.info(this.ME, "Accessing xmlBlaster using your given IOR string in Address.getRawAddress()");
                                }
                                AuthServer authServer2 = this.authServer;
                                java.lang.Object var31_7 = null;
                                this.verbose = false;
                                return authServer2;
                            }
                            String authServerIOR = address.getEnv("iorString", null).getValue();
                            if (authServerIOR != null) {
                                this.authServer = AuthServerHelper.narrow(this.orb.string_to_object(authServerIOR));
                                if (this.verbose) {
                                    this.log.info(this.ME, "Accessing xmlBlaster using your given IOR string");
                                }
                                authServer = this.authServer;
                                break block43;
                            }
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "No -dispatch/connection/plugin/ior/iorString ...");
                            }
                            if ((authServerIORFile = this.glob.getProperty().get("dispatch/connection/plugin/ior/iorFile", (String)null)) != null) {
                                try {
                                    authServerIOR = FileUtil.readAsciiFile(authServerIORFile);
                                }
                                catch (JUtilsException e22) {
                                    throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "dispatch/connection/plugin/ior/iorFile", e22);
                                }
                                this.authServer = AuthServerHelper.narrow(this.orb.string_to_object(authServerIOR));
                                this.log.info(this.ME, "Accessing xmlBlaster using your given IOR file " + authServerIORFile);
                                e22 = this.authServer;
                                break block44;
                            }
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "No -dispatch/connection/plugin/ior/iorFile ...");
                            }
                            try {
                                authServerIOR = this.glob.accessFromInternalHttpServer(address, "AuthenticationService.ior", this.verbose);
                                if (System.getProperty("java.version").startsWith("1") && !authServerIOR.startsWith("IOR:")) {
                                    authServerIOR = "IOR:000" + authServerIOR;
                                    this.log.warn(this.ME, "Manipulated IOR because of missing 'IOR:'");
                                }
                                this.authServer = AuthServerHelper.narrow(this.orb.string_to_object(authServerIOR));
                                this.log.info(this.ME, "Accessing xmlBlaster AuthServer IOR using builtin http connection to " + address.getBootstrapUrl());
                                e22 = this.authServer;
                                break block45;
                            }
                            catch (org.xmlBlaster.util.XmlBlasterException e3) {
                            }
                            catch (Throwable e4) {
                                if (!this.verbose) break block46;
                                this.log.error(this.ME, "XmlBlaster not found with internal HTTP download");
                                e4.printStackTrace();
                            }
                        }
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "No -bootstrapHostname / -bootstrapPort for " + address.getBootstrapUrl() + " ...");
                        }
                        if ((contextId = this.glob.getProperty().get("NameService.context.id", "xmlBlaster")) == null) {
                            contextId = "";
                        }
                        if ((contextKind = this.glob.getProperty().get("NameService.context.kind", "MOM")) == null) {
                            contextKind = "";
                        }
                        if ((clusterId = this.glob.getProperty().get("NameService.node.id", this.glob.getStrippedId())) == null) {
                            clusterId = "";
                        }
                        if ((clusterKind = this.glob.getProperty().get("NameService.node.kind", "MOM")) == null) {
                            clusterKind = "";
                        }
                        String text = "Can't access xmlBlaster Authentication Service, is the server running and ready?\n - try to specify '-dispatch/connection/plugin/ior/iorFile <fileName>' if server is running on same host\n - try to specify '-bootstrapHostname <hostName> -bootstrapPort 3412' to locate xmlBlaster\n - or start a naming service '" + contextId + "." + contextKind + "/" + clusterId + "." + clusterKind + "'";
                        boolean useNameService = address.getEnv("useNameService", true).getValue();
                        if (!useNameService) {
                            if (!this.log.TRACE) throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, text);
                            this.log.trace(this.ME, "No -plugin/ior/useNameService ...");
                            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, text);
                        }
                        if (this.verbose) {
                            this.log.info(this.ME, "Trying to find a CORBA naming service ...");
                        }
                        try {
                            String serverNameList;
                            int countServerFound;
                            String firstServerName;
                            String tmpId;
                            AuthServer authServerFirst;
                            NameComponent[] nameNode;
                            NameComponent[] nameXmlBlaster;
                            block47: {
                                int i;
                                BindingHolder bh;
                                BindingIteratorHolder bi;
                                Object obj;
                                NamingContextExt relativeContext;
                                NamingContextExt namingContextExt = this.getNamingService();
                                nameXmlBlaster = new NameComponent[]{new NameComponent(contextId, contextKind)};
                                if (this.log.TRACE) {
                                    this.log.trace(this.ME, "Query NameServer -ORBInitRef NameService=" + this.glob.getProperty().get("ORBInitRef", "") + (System.getProperty("ORBInitRef.NameService") != null ? System.getProperty("ORBInitRef.NameService") : "") + " to find the xmlBlaster root context " + CorbaDriver.getString(nameXmlBlaster));
                                }
                                if ((relativeContext = NamingContextExtHelper.narrow(obj = namingContextExt.resolve(nameXmlBlaster))) == null) {
                                    throw new Exception("Can't resolve CORBA NameService");
                                }
                                nameNode = new NameComponent[]{new NameComponent(clusterId, clusterKind)};
                                authServerFirst = null;
                                tmpId = "";
                                String tmpServerName = "";
                                firstServerName = "";
                                countServerFound = 0;
                                serverNameList = "";
                                try {
                                    this.authServer = AuthServerHelper.narrow(relativeContext.resolve(nameNode));
                                    break block47;
                                }
                                catch (Exception ex) {
                                    if (this.log.TRACE) {
                                        this.log.trace(this.ME, "Query NameServer to find a suitable xmlBlaster server for " + CorbaDriver.getString(nameXmlBlaster) + "/" + CorbaDriver.getString(nameNode));
                                    }
                                    BindingListHolder bl = new BindingListHolder();
                                    bi = new BindingIteratorHolder();
                                    relativeContext.list(0, bl, bi);
                                    if (this.authServer != null || bi.value == null) break block47;
                                    bh = new BindingHolder();
                                    i = 0;
                                }
                                while (bi.value.next_one(bh)) {
                                    String id = bh.value.binding_name[0].id;
                                    String kind = bh.value.binding_name[0].kind;
                                    NameComponent[] nameNodeTmp = new NameComponent[]{new NameComponent(id, kind)};
                                    tmpId = id;
                                    ++countServerFound;
                                    tmpServerName = CorbaDriver.getString(nameXmlBlaster) + "/" + CorbaDriver.getString(nameNodeTmp);
                                    if (i > 0) {
                                        serverNameList = serverNameList + ", ";
                                    }
                                    ++i;
                                    serverNameList = serverNameList + tmpServerName;
                                    if (clusterId.equals(id) && clusterKind.equals(kind)) {
                                        try {
                                            if (this.log.TRACE) {
                                                this.log.trace(this.ME, "Trying to resolve NameService entry '" + CorbaDriver.getString(nameNodeTmp) + "'");
                                            }
                                            this.authServer = AuthServerHelper.narrow(relativeContext.resolve(nameNodeTmp));
                                            break;
                                        }
                                        catch (Exception exc) {
                                            this.log.warn(this.ME, "Connecting to NameService entry '" + tmpServerName + "' failed: " + exc.toString());
                                        }
                                    }
                                    if (authServerFirst != null) continue;
                                    if (this.log.TRACE) {
                                        this.log.trace(this.ME, "Remember the first server");
                                    }
                                    try {
                                        firstServerName = tmpServerName;
                                        if (this.log.TRACE) {
                                            this.log.trace(this.ME, "Remember the first reachable xmlBlaster server from NameService entry '" + firstServerName + "'");
                                        }
                                        authServerFirst = AuthServerHelper.narrow(relativeContext.resolve(nameNodeTmp));
                                    }
                                    catch (Exception exc) {
                                        this.log.warn(this.ME, "Connecting to NameService entry '" + tmpServerName + "' failed: " + exc.toString());
                                    }
                                }
                            }
                            if (this.authServer == null) {
                                if (authServerFirst == null) throw new Exception("No xmlBlaster server found in NameService");
                                if (countServerFound > 1) {
                                    String str = "Can't choose one of " + countServerFound + " avalailable server in CORBA NameService: " + serverNameList + ". Please choose one with e.g. -NameService.node.id " + tmpId;
                                    this.log.error(this.ME, str);
                                    throw new Exception(str);
                                }
                                this.log.info(this.ME, "Choosing only available server '" + firstServerName + "' in CORBA NameService -ORBInitRef NameService=" + System.getProperty("ORBInitRef"));
                                this.authServer = authServerFirst;
                                AuthServer authServer3 = authServerFirst;
                                java.lang.Object var31_11 = null;
                                this.verbose = false;
                                return authServer3;
                            }
                            this.log.info(this.ME, "Accessing xmlBlaster using a naming service '" + nameXmlBlaster[0].id + "." + nameXmlBlaster[0].kind + "/" + nameNode[0].id + "." + nameNode[0].kind + "' on " + System.getProperty("ORBInitRef"));
                            AuthServer authServer4 = this.authServer;
                            java.lang.Object var31_12 = null;
                            this.verbose = false;
                            return authServer4;
                        }
                        catch (Throwable e5) {
                            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, text, e5);
                        }
                    }
                    catch (Throwable throwable) {
                        java.lang.Object var31_13 = null;
                        this.verbose = false;
                        throw throwable;
                    }
                }
                java.lang.Object var31_8 = null;
                this.verbose = false;
                return authServer;
            }
            java.lang.Object var31_9 = null;
            this.verbose = false;
            return e22;
        }
        java.lang.Object var31_10 = null;
        this.verbose = false;
        return e22;
    }

    public String connect(String connectQos) throws org.xmlBlaster.util.XmlBlasterException {
        if (connectQos == null) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Please pass a valid QoS for connect()");
        }
        this.ME = "CorbaConnection";
        if (this.log.CALL) {
            this.log.call(this.ME, "connect(xmlBlaster=" + this.xmlBlaster + ") ...");
        }
        try {
            AuthServer remoteAuthServer = this.getAuthenticationService(this.clientAddress);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Got authServer handle, trying connect ...");
            }
            return remoteAuthServer.connect(connectQos);
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw e;
        }
        catch (XmlBlasterException e) {
            org.xmlBlaster.util.XmlBlasterException xmlBlasterException = CorbaDriver.convert(this.glob, e);
            throw xmlBlasterException;
        }
        catch (Throwable e) {
            org.xmlBlaster.util.XmlBlasterException xmlBlasterException = org.xmlBlaster.util.XmlBlasterException.convert(this.glob, this.ME, "Login failed", e);
            xmlBlasterException.changeErrorCode(ErrorCode.COMMUNICATION_NOCONNECTION);
            throw xmlBlasterException;
        }
    }

    public void connectLowlevel(Address address) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "connectLowlevel() ...");
        }
        this.clientAddress = address;
        if (this.orb == null) {
            this.orb = OrbInstanceFactory.createOrbInstance(this.glob, null, this.glob.getProperty().getProperties(), this.clientAddress);
        }
        this.getAuthenticationService(this.clientAddress);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Success, connectLowlevel()");
        }
    }

    public void setConnectReturnQos(ConnectReturnQos connectReturnQos) throws org.xmlBlaster.util.XmlBlasterException {
        try {
            this.sessionId = connectReturnQos.getSecretSessionId();
            String xmlBlasterIOR = connectReturnQos.getServerRef().getAddress();
            this.xmlBlaster = ServerHelper.narrow(this.orb.string_to_object(xmlBlasterIOR));
            this.ME = "CorbaConnection-" + connectReturnQos.getSessionName().toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "setConnectReturnQos(): xmlBlaster=" + this.xmlBlaster);
            }
        }
        catch (Throwable e) {
            this.xmlBlaster = null;
            org.xmlBlaster.util.XmlBlasterException xmlBlasterException = org.xmlBlaster.util.XmlBlasterException.convert(this.glob, this.ME, "Login failed", e);
            xmlBlasterException.changeErrorCode(ErrorCode.COMMUNICATION_NOCONNECTION);
            throw xmlBlasterException;
        }
    }

    public boolean disconnect(String qos) {
        if (this.log.CALL) {
            this.log.call(this.ME, "disconnect() ...");
        }
        if (this.xmlBlaster == null) {
            try {
                this.shutdown();
            }
            catch (org.xmlBlaster.util.XmlBlasterException ex) {
                this.log.error(this.ME, "disconnect. Could not shutdown properly. " + ex.getMessage());
            }
            return false;
        }
        try {
            if (this.authServer != null) {
                if (this.sessionId == null) {
                    this.authServer.logout(this.xmlBlaster);
                } else {
                    this.authServer.disconnect(this.sessionId, qos == null ? "" : qos);
                }
            }
            this.shutdown();
            this.xmlBlaster = null;
            return true;
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, "Remote exception: " + CorbaDriver.convert(this.glob, e).getMessage());
        }
        catch (OBJ_ADAPTER e) {
            this.log.warn(this.ME, "No disconnect possible, no CORBA connection available: " + e.toString());
        }
        catch (TRANSIENT e) {
            this.log.warn(this.ME, "No disconnect possible, CORBA connection lost: " + e.toString());
        }
        catch (COMM_FAILURE e) {
            this.log.warn(this.ME, "No disconnect possible, CORBA connection lost: " + e.toString());
        }
        catch (OBJECT_NOT_EXIST e) {
            this.log.warn(this.ME, "No disconnect possible, CORBA connection lost: " + e.toString());
        }
        catch (Throwable e) {
            org.xmlBlaster.util.XmlBlasterException xmlBlasterException = org.xmlBlaster.util.XmlBlasterException.convert(this.glob, this.ME, null, e);
            this.log.warn(this.ME, xmlBlasterException.getMessage());
            e.printStackTrace();
        }
        try {
            this.shutdown();
        }
        catch (org.xmlBlaster.util.XmlBlasterException ex) {
            this.log.error(this.ME, "disconnect. Could not shutdown properly. " + ex.getMessage());
        }
        this.xmlBlaster = null;
        return false;
    }

    public void shutdown() throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown()");
        }
        if (this.authServer != null) {
            this.authServer._release();
            this.authServer = null;
        }
        if (this.xmlBlaster != null) {
            this.xmlBlaster._release();
            this.xmlBlaster = null;
        }
        if (this.orb != null) {
            boolean wait_for_completion = false;
            try {
                this.orb.shutdown(wait_for_completion);
                this.orb = null;
            }
            catch (Throwable ex) {
                this.log.warn(this.ME, "shutdown: Exception occured during orb.shutdown(" + wait_for_completion + "): " + ex.toString());
            }
        }
    }

    public boolean isLoggedIn() {
        return this.xmlBlaster != null;
    }

    public final String subscribe(String xmlKey, String qos) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "subscribe() ...");
        }
        try {
            return this.getXmlBlaster().subscribe(xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            throw CorbaDriver.convert(this.glob, e);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "subscribe", e);
        }
    }

    public final String[] unSubscribe(String xmlKey, String qos) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "unSubscribe() ...");
        }
        try {
            return this.getXmlBlaster().unSubscribe(xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            throw CorbaDriver.convert(this.glob, e);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "unSubscribe", e);
        }
    }

    public final String publish(MsgUnitRaw msgUnit) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Publishing ...");
        }
        try {
            return this.getXmlBlaster().publish(CorbaDriver.convert(msgUnit));
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "XmlBlasterException: " + e.getMessage());
            }
            throw CorbaDriver.convert(this.glob, e);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publish() failed", e);
        }
    }

    public String[] publishArr(MsgUnitRaw[] msgUnitArr) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "publishArr() num of Entries: " + msgUnitArr.length);
        }
        try {
            return this.getXmlBlaster().publishArr(CorbaDriver.convert(msgUnitArr));
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "XmlBlasterException: " + e.getMessage());
            }
            throw CorbaDriver.convert(this.glob, e);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publishArr", e);
        }
    }

    public void publishOneway(MsgUnitRaw[] msgUnitArr) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "publishOneway() ...");
        }
        try {
            this.getXmlBlaster().publishOneway(CorbaDriver.convert(msgUnitArr));
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publishOneway", e);
        }
    }

    public final String[] erase(String xmlKey, String qos) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "erase() ...");
        }
        if (xmlKey == null) {
            xmlKey = "";
        }
        if (qos == null) {
            qos = "";
        }
        try {
            return this.getXmlBlaster().erase(xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            throw CorbaDriver.convert(this.glob, e);
        }
        catch (Throwable e) {
            this.log.error(this.ME + ".erase", "IO exception: " + e.toString() + " sessionId=" + this.sessionId);
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "erase", e);
        }
    }

    public final MsgUnitRaw[] get(String xmlKey, String qos) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "get() ...");
        }
        try {
            return CorbaDriver.convert(this.glob, this.getXmlBlaster().get(xmlKey, qos));
        }
        catch (XmlBlasterException e) {
            throw CorbaDriver.convert(this.glob, e);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "get", e);
        }
    }

    public String ping(String qos) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.xmlBlaster == null && this.authServer != null) {
            return this.authServer.ping(qos);
        }
        try {
            return this.getXmlBlaster().ping(qos);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "ping", e);
        }
    }

    public static String usage() {
        String text = "\n";
        text = text + "CorbaConnection 'IOR' options:\n";
        text = text + "   -bootstrapHostname <hostname or IP>\n";
        text = text + "                       The host where to find xmlBlaster internal HTTP IOR download [localhost]\n";
        text = text + "   -bootstrapPort <port>\n";
        text = text + "                       The bootstrap port where xmlBlaster publishes its IOR [3412]\n";
        text = text + "   -dispatch/connection/plugin/ior/iorString <IOR:00459...>\n";
        text = text + "                       The IOR string from the running xmlBlaster server.\n";
        text = text + "   -dispatch/connection/plugin/ior/iorFile <fileName>\n";
        text = text + "                       A file with the xmlBlaster IOR.\n";
        text = text + "   -dispatch/connection/plugin/ior/useNameService <true/false>\n";
        text = text + "                       Try to access xmlBlaster through a naming service [true]\n";
        text = text + "   -dispatch/callback/plugin/ior/hostname <ip>\n";
        text = text + "                       Allows to set the callback-server's IP address for multi-homed hosts.\n";
        text = text + "   -dispatch/callback/plugin/ior/port <port>\n";
        text = text + "                       Allows to set the callback-server's port number.\n";
        text = text + " For JacORB only:\n";
        text = text + "   java -DOAIAddr=<ip> Use '-dispatch/callback/plugin/ior/hostname'\n";
        text = text + "   java -DOAPort=<nr>  Use '-dispatch/callback/plugin/ior/port'\n";
        text = text + "   java -Djacorb.log.default.verbosity=3  Switch CORBA debugging on\n";
        text = text + "   java ... -ORBInitRef NameService=corbaloc:iiop:localhost:7608/StandardNS/NameServer-POA/_root\n";
        text = text + "   java -DORBInitRef.NameService=corbaloc:iiop:localhost:7608/StandardNS/NameServer-POA/_root\n";
        text = text + "\n";
        return text;
    }
}

