/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.http.common;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlBlaster.client.protocol.http.common.I_ObjectStream;
import org.xmlBlaster.client.protocol.http.common.MsgHolder;

public class ObjectInputStreamMicro
implements I_ObjectStream {
    private DataInputStream in;

    public ObjectInputStreamMicro(InputStream inStream) throws IOException {
        this.in = new DataInputStream(inStream);
    }

    private Hashtable readHashtable() throws IOException {
        int size = this.in.readInt();
        Hashtable<String, String> ret = new Hashtable<String, String>();
        int i = 0;
        while (i < size) {
            String key = this.in.readUTF();
            String val = this.in.readUTF();
            ret.put(key, val);
            ++i;
        }
        return ret;
    }

    private Vector readVector() throws IOException {
        int size = this.in.readInt();
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < size) {
            ret.addElement(this.readHashtable());
            ret.addElement(this.readHashtable());
            int length = this.in.readInt();
            byte[] content = new byte[length];
            this.in.read(content);
            ret.addElement(content);
            ++i;
        }
        return ret;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        int code = this.in.readInt();
        if (code == 0) {
            return this.in.readUTF();
        }
        if (code == 1) {
            return this.readHashtable();
        }
        if (code == 2) {
            int size = this.in.readInt();
            Hashtable[] ret = new Hashtable[size];
            int i = 0;
            while (i < size) {
                ret[i] = this.readHashtable();
                ++i;
            }
            return ret;
        }
        if (code == 3) {
            return this.readVector();
        }
        throw new IOException("object of type with code='" + code + "' is not supported");
    }

    public static MsgHolder readMessage(byte[] buffer) throws IOException {
        int pos;
        if (buffer.length < 4) {
            return new MsgHolder(null, null, null, null);
        }
        int i = pos = 0;
        while (buffer[i] != 0) {
            ++i;
        }
        String oid = i == 0 ? null : new String(buffer, 0, i);
        pos = ++i;
        while (buffer[i] != 0) {
            ++i;
        }
        String key = new String(buffer, pos, i - pos);
        if (key.length() < 1) {
            key = null;
        }
        pos = ++i;
        while (buffer[i] != 0) {
            ++i;
        }
        String qos = new String(buffer, pos, i - pos);
        if (qos.length() < 1) {
            qos = null;
        }
        pos = ++i;
        byte[] content = new byte[buffer.length - pos];
        while (i < buffer.length) {
            content[i - pos] = buffer[i];
            ++i;
        }
        return new MsgHolder(oid, key, qos, content);
    }
}

